/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.preferences;

import com.spket.as.internal.compiler.ast.CompilationUnitDeclaration;
import com.spket.as.internal.compiler.ast.Expression;
import com.spket.as.internal.compiler.ast.InclucdeStatement;
import com.spket.as.internal.compiler.ast.InvokeExpression;
import com.spket.as.internal.compiler.ast.Statement;
import com.spket.as.internal.compiler.ast.UseStatement;
import com.spket.js.internal.JSImages;
import com.spket.js.internal.JSPlugin;
import com.spket.js.model.Context;
import com.spket.js.model.Profile;
import com.spket.js.preferences.JSPMessages;
import com.spket.js.preferences.LibraryDialog;
import com.spket.js.preferences.ProfileDialog;
import com.spket.js.preferences.ProfileItem;
import com.spket.js.preferences.ReloadContextJob;
import com.spket.js.profile.ProfileContext;
import com.spket.js.profile.ProfileLoader;
import com.spket.ui.internal.dialogfields.DialogField;
import com.spket.ui.internal.dialogfields.IDialogFieldListener;
import com.spket.ui.internal.dialogfields.IStatusChangeListener;
import com.spket.ui.internal.dialogfields.ITreeListAdapter;
import com.spket.ui.internal.dialogfields.TreeListDialogField;
import com.spket.ui.preferences.OptionsConfigurationBlock;
import com.spket.ui.util.PixelConverter;
import com.spket.util.FileUtils;
import com.spket.util.StringUtils;
import com.spket.widget.UIUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class JSProfileConfigurationBlock
extends OptionsConfigurationBlock {
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;
    private static final int IDX_NEW_LIBRARY = 4;
    private static final int IDX_FILE = 5;
    private static final int IDX_FOLDER = 6;
    private static final int IDX_UP = 8;
    private static final int IDX_DOWN = 9;
    private static final int IDX_DEFAULT = 11;
    private static final int IDX_RELOAD = 12;
    private static final OptionsConfigurationBlock.Key PREF_PROFILE = JSProfileConfigurationBlock.getKey((String)"com.spket.js", (String)"js.profile");
    private static Image imgJSB = JSImages.get("c.s.js.jsb.gif");
    private static Image imgJavaScript = JSImages.get("c.s.js.js.gif");
    private static Image imgLibrary = JSImages.get("c.s.js.library.gif");
    private static Image imgChecked = JSImages.get("c.s.js.checked.gif");
    private static Image imgUnchecked = JSImages.get("c.s.js.unchecked.gif");
    private static Image imgSystemProfile = JSImages.get("c.s.js.function_obj.gif");
    private static Image imgCustomProfile = JSImages.get("c.s.js.global_var_obj.gif");
    private String fProfileId;
    private TreeListDialogField fProfileList;

    private static OptionsConfigurationBlock.Key[] getKeys() {
        return new OptionsConfigurationBlock.Key[]{PREF_PROFILE};
    }

    public JSProfileConfigurationBlock(IStatusChangeListener iStatusChangeListener, IProject iProject, IWorkbenchPreferenceContainer iWorkbenchPreferenceContainer) {
        super(iStatusChangeListener, iProject, JSProfileConfigurationBlock.getKeys(), iWorkbenchPreferenceContainer);
        ProfileAdapter profileAdapter = new ProfileAdapter();
        String[] stringArray = new String[]{JSPMessages.Page_Profile_add_button, JSPMessages.Page_Profile_edit_button, JSPMessages.Page_Profile_remove_button, null, JSPMessages.Page_Profile_library_button, JSPMessages.Page_Profile_file_button, JSPMessages.Page_Profile_folder_button, null, JSPMessages.Page_Profile_up_button, JSPMessages.Page_Profile_down_button, null, JSPMessages.Page_Profile_setdefault_button, JSPMessages.Page_Profile_reload_button};
        this.fProfileList = new TreeListDialogField((ITreeListAdapter)profileAdapter, stringArray, (ILabelProvider)new ProfileLabelProvider());
        this.fProfileList.setDialogFieldListener((IDialogFieldListener)profileAdapter);
        this.fProfileList.setViewerComparator((ViewerComparator)new ProfileSorter());
        this.fProfileList.setElements(this.getProfileList());
        if (this.fProject != null) {
            this.fProfileList.enableButton(0, false);
        }
        if (this.fProject != null || this.fProfileList.getSize() == 0) {
            this.fProfileList.enableButton(1, false);
            this.fProfileList.enableButton(2, false);
            this.fProfileList.enableButton(4, false);
            this.fProfileList.enableButton(5, false);
            this.fProfileList.enableButton(6, false);
            this.fProfileList.enableButton(8, false);
            this.fProfileList.enableButton(9, false);
            this.fProfileList.enableButton(1, false);
            this.fProfileList.enableButton(11, false);
            this.fProfileList.enableButton(12, false);
        }
        if (this.fProfileList.getSize() > 0) {
            this.fProfileList.selectFirstElement();
        }
    }

    protected Control createContents(Composite composite) {
        Profile profile;
        List list;
        this.setShell(composite.getShell());
        this.fProfileId = this.getValue(PREF_PROFILE);
        if (this.fProfileId != null) {
            boolean bl = false;
            list = this.fProfileList.getElements();
            for (int i = 0; i < list.size(); ++i) {
                profile = (Profile)((ProfileItem)((Object)list.get(i))).getData();
                if (!this.fProfileId.equals(profile.getId())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.fProfileId = null;
            }
        }
        Composite composite2 = new Composite(composite, 0);
        list = new GridLayout();
        ((GridLayout)list).marginHeight = 0;
        ((GridLayout)list).marginWidth = 0;
        ((GridLayout)list).numColumns = 2;
        composite2.setLayout((Layout)list);
        composite2.setFont(composite.getFont());
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        profile = new GridData(1808);
        ((GridData)profile).widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        Control control = this.fProfileList.getTreeControl(composite2);
        control.setLayoutData((Object)profile);
        Composite composite3 = this.fProfileList.getButtonBox(composite2);
        composite3.setLayoutData((Object)new GridData(258));
        this.validateSettings(null, null, null);
        Tree tree = this.fProfileList.getTreeViewer().getTree();
        TargetListener targetListener = new TargetListener();
        tree.addListener(3, (Listener)targetListener);
        tree.addListener(4, (Listener)targetListener);
        return composite2;
    }

    public boolean performOk() {
        Object object;
        Map map;
        boolean bl = true;
        ArrayList<String> arrayList = null;
        ArrayList<String> arrayList2 = null;
        Profile[] profileArray = null;
        boolean bl2 = false;
        if (this.fProject == null) {
            arrayList = new ArrayList<String>();
            arrayList2 = new ArrayList<String>();
            ArrayList<Profile> arrayList3 = new ArrayList<Profile>();
            map = Context.getProfiles();
            object = this.fProfileList.getElements();
            for (int i = 0; i < object.size(); ++i) {
                ProfileItem profileItem = (ProfileItem)((Object)object.get(i));
                if (profileItem.getCategory() != 2) continue;
                arrayList.add(profileItem.getName());
                String string = this.convert(profileItem);
                arrayList2.add(string);
                Profile profile = (Profile)profileItem.getData();
                ProfileContext profileContext = (ProfileContext)profile.getContext();
                if (profileContext == null) {
                    profileContext = new ProfileContext(null);
                    profile.setContext(profileContext);
                }
                arrayList3.add(profile);
                if (bl2) continue;
                Profile profile2 = (Profile)map.get(profile.getId());
                bl2 = profile2 == null || !profile2.getName().equals(profileItem.getName()) ? true : !StringUtils.equals((Object)string, (Object)(profileContext = (ProfileContext)profile2.getContext()).getContent());
            }
            if (arrayList3.size() > 0) {
                profileArray = new Profile[arrayList3.size()];
                arrayList3.toArray(profileArray);
            }
            if (bl2) {
                try {
                    ProfileLoader.saveProfiles(profileArray, arrayList, arrayList2);
                }
                catch (CoreException coreException) {
                    bl = false;
                    this.reportError((Exception)((Object)coreException));
                }
            }
        }
        if (bl) {
            bl &= super.performOk();
            if (this.fProject == null) {
                if (bl2) {
                    for (int i = 0; i < profileArray.length; ++i) {
                        map = profileArray[i];
                        ((Profile)((Object)map)).setName((String)arrayList.get(i));
                        object = (ProfileContext)((Profile)((Object)map)).getContext();
                        ((ProfileContext)object).setContent((String)arrayList2.get(i));
                    }
                    Context.update(profileArray, this.getValue(PREF_PROFILE));
                } else {
                    Context.resetDefault(this.getValue(PREF_PROFILE));
                }
            } else {
                Context.resetDefault(this.getValue(PREF_PROFILE));
            }
        }
        return bl;
    }

    protected String[] getFullBuildDialogStrings(boolean bl) {
        return null;
    }

    protected void validateSettings(OptionsConfigurationBlock.Key key, String string, String string2) {
    }

    protected final void updateModel(DialogField dialogField) {
    }

    private void onButtonPressed(int n) {
        switch (n) {
            case 0: {
                this.editProfile(null);
                break;
            }
            case 1: {
                this.editEntry();
                break;
            }
            case 2: {
                this.removeEntry();
                break;
            }
            case 4: {
                this.editLibrary(null);
                break;
            }
            case 5: {
                this.editFile(null);
                break;
            }
            case 6: {
                this.newFolder();
                break;
            }
            case 8: {
                this.doMoveUp();
                break;
            }
            case 9: {
                this.doMoveDown();
                break;
            }
            case 11: {
                this.setDefault();
                break;
            }
            case 12: {
                this.reload();
            }
        }
    }

    private boolean isDefaultProfile(Object object) {
        ProfileItem profileItem = (ProfileItem)((Object)object);
        if (profileItem.getCategory() < 3) {
            Profile profile = (Profile)profileItem.getData();
            if (this.fProfileId == null) {
                return profile.isDefault();
            }
            return this.fProfileId.equals(profile.getId());
        }
        return false;
    }

    protected boolean hasBuilder() {
        return false;
    }

    private boolean canEdit(List list) {
        if (list.size() == 1) {
            ProfileItem profileItem = (ProfileItem)((Object)list.get(0));
            switch (profileItem.getCategory()) {
                case 2: 
                case 3: 
                case 4: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean canRemove(List list) {
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                ProfileItem profileItem = (ProfileItem)((Object)list.get(i));
                switch (profileItem.getCategory()) {
                    case 1: 
                    case 6: 
                    case 7: {
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private ProfileItem getCommonParent(List list) {
        ProfileItem profileItem = null;
        for (int i = 0; i < list.size(); ++i) {
            ProfileItem profileItem2 = (ProfileItem)((Object)list.get(i));
            ProfileItem profileItem3 = (ProfileItem)((Object)profileItem2.getParent());
            if (!(profileItem == null ? (profileItem = profileItem3) == null : profileItem != profileItem3)) continue;
            return null;
        }
        return profileItem;
    }

    private Object[] getMovable(ProfileItem profileItem) {
        Object[] objectArray = profileItem.getChildren();
        if (profileItem.getCategory() == 4) {
            ProfileItem profileItem2;
            ArrayList<ProfileItem> arrayList = new ArrayList<ProfileItem>(objectArray.length);
            for (int i = 0; i < objectArray.length && (profileItem2 = (ProfileItem)((Object)objectArray[i])).getData() != null; ++i) {
                arrayList.add(profileItem2);
            }
            if (arrayList.size() > 0) {
                objectArray = new Object[arrayList.size()];
                arrayList.toArray(objectArray);
            }
        }
        return objectArray;
    }

    private boolean canMoveUp(List list) {
        ProfileItem profileItem = this.getCommonParent(list);
        if (profileItem != null) {
            if (profileItem.getCategory() == 6) {
                return false;
            }
            if (profileItem.getCategory() == 4) {
                for (int i = 0; i < list.size(); ++i) {
                    if (((ProfileItem)((Object)list.get(i))).getData() != null) continue;
                    return false;
                }
            }
            Object[] objectArray = this.getMovable(profileItem);
            int n = Math.min(list.size(), objectArray.length);
            for (int i = 0; i < n; ++i) {
                if (list.contains(objectArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean canMoveDown(List list) {
        ProfileItem profileItem = this.getCommonParent(list);
        if (profileItem != null) {
            if (profileItem.getCategory() == 6) {
                return false;
            }
            if (profileItem.getCategory() == 4) {
                for (int i = 0; i < list.size(); ++i) {
                    if (((ProfileItem)((Object)list.get(i))).getData() != null) continue;
                    return false;
                }
            }
            Object[] objectArray = this.getMovable(profileItem);
            int n = Math.max(0, objectArray.length - list.size());
            for (int i = objectArray.length - 1; i >= n; --i) {
                if (list.contains(objectArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean canAddLibrary(List list) {
        ProfileItem profileItem;
        return list.size() == 1 && 2 == (profileItem = (ProfileItem)((Object)list.get(0))).getCategory();
    }

    private boolean canAddFile(List list) {
        ProfileItem profileItem;
        return list.size() == 1 && 3 == (profileItem = (ProfileItem)((Object)list.get(0))).getCategory();
    }

    private boolean canAddFolder(List list) {
        ProfileItem profileItem;
        return list.size() == 1 && 3 == (profileItem = (ProfileItem)((Object)list.get(0))).getCategory();
    }

    private boolean canSetToDefault(List list) {
        ProfileItem profileItem;
        if (list.size() == 1 && (profileItem = (ProfileItem)((Object)list.get(0))).getCategory() < 3) {
            return !this.isDefaultProfile((Object)profileItem);
        }
        return false;
    }

    private List getProfileList() {
        ArrayList<ProfileItem> arrayList = new ArrayList<ProfileItem>();
        Iterator iterator = Context.getProfiles().values().iterator();
        while (iterator.hasNext()) {
            Profile profile = (Profile)iterator.next();
            ProfileItem profileItem = new ProfileItem();
            profileItem.setData(profile);
            profileItem.setName(profile.getName());
            profileItem.setImage(profile.isCustom() ? imgCustomProfile : imgSystemProfile);
            profileItem.setCategory(profile.isCustom() ? 2 : 1);
            if (profile.isCustom()) {
                try {
                    this.initialize(profileItem);
                }
                catch (SAXException sAXException) {
                    JSPlugin.log(sAXException);
                }
                catch (IOException iOException) {
                    JSPlugin.log(iOException);
                }
            }
            arrayList.add(profileItem);
        }
        return arrayList;
    }

    private void editProfile(ProfileItem profileItem) {
        ProfileDialog profileDialog = new ProfileDialog(this.getShell(), profileItem, this.fProfileList.getElements());
        if (profileDialog.open() == 0) {
            String string = profileDialog.getProfileName();
            if (profileItem == null) {
                profileItem = new ProfileItem();
                Profile profile = new Profile();
                profile.setId(this.generateProfileId(string));
                profile.setName(string);
                profile.setCustom(true);
                profileItem.setData(profile);
                profileItem.setName(string);
                profileItem.setCategory(2);
                profileItem.setImage(imgCustomProfile);
                this.fProfileList.addElement((Object)profileItem);
                this.fProfileList.selectElements((ISelection)new StructuredSelection((Object)profileItem));
            } else if (!string.equals(profileItem.getName())) {
                profileItem.setName(string);
                this.fProfileList.update((Object)profileItem);
            }
        }
    }

    private void setDefault() {
        List list = this.fProfileList.getSelectedElements();
        if (this.canSetToDefault(list)) {
            ProfileItem profileItem = null;
            ProfileItem profileItem2 = (ProfileItem)((Object)list.get(0));
            list = this.fProfileList.getElements();
            for (int i = 0; i < list.size(); ++i) {
                ProfileItem profileItem3 = (ProfileItem)((Object)list.get(i));
                Profile profile = (Profile)profileItem3.getData();
                if (this.fProfileId == null) {
                    if (!profile.isDefault()) continue;
                    profileItem = profileItem3;
                    break;
                }
                if (!this.fProfileId.equals(profile.getId())) continue;
                profileItem = profileItem3;
                break;
            }
            Profile profile = (Profile)profileItem2.getData();
            this.fProfileId = profile.getId();
            this.setValue(PREF_PROFILE, this.fProfileId);
            if (profileItem != null) {
                this.fProfileList.update((Object)profileItem);
            }
            this.fProfileList.update((Object)profileItem2);
            this.fProfileList.enableButton(11, this.canSetToDefault(list));
        }
    }

    private void editEntry() {
        List list = this.fProfileList.getSelectedElements();
        if (this.canEdit(list)) {
            ProfileItem profileItem = (ProfileItem)((Object)list.get(0));
            switch (profileItem.getCategory()) {
                case 2: {
                    this.editProfile(profileItem);
                    break;
                }
                case 3: {
                    this.editLibrary(profileItem);
                    break;
                }
                case 4: {
                    this.editFile(profileItem);
                }
            }
        }
    }

    private void editLibrary(ProfileItem profileItem) {
        LibraryDialog libraryDialog = new LibraryDialog(this.getShell(), profileItem);
        if (libraryDialog.open() == 0) {
            String string = libraryDialog.getLibrary();
            if (profileItem == null) {
                profileItem = new ProfileItem();
                profileItem.setName(string);
                profileItem.setCategory(3);
                profileItem.setImage(imgLibrary);
                ProfileItem profileItem2 = (ProfileItem)((Object)this.fProfileList.getSelectedElements().get(0));
                profileItem2.addChild(profileItem);
                this.fProfileList.refresh((Object)profileItem2);
                this.fProfileList.expandElement((Object)profileItem2, 1);
                this.fProfileList.selectElements((ISelection)new StructuredSelection((Object)profileItem));
            } else if (!string.equals(profileItem.getName())) {
                profileItem.setName(string);
                this.fProfileList.update((Object)profileItem);
            }
        }
    }

    private void select(ProfileItem profileItem, ProfileItem[] profileItemArray) {
        int n;
        ArrayList<ProfileItem> arrayList = new ArrayList<ProfileItem>();
        for (n = 0; n < profileItemArray.length; ++n) {
            ProfileItem profileItem2 = profileItemArray[n];
            for (ProfileItem profileItem3 = (ProfileItem)((Object)profileItem2.getParent()); profileItem3 != null && profileItem3 != profileItem; profileItem3 = (ProfileItem)((Object)profileItem3.getParent())) {
                if (arrayList.contains((Object)profileItem3)) continue;
                arrayList.add(profileItem3);
            }
        }
        this.fProfileList.expandElement((Object)profileItem, 1);
        if (arrayList.size() > 0) {
            for (n = arrayList.size() - 1; n >= 0; --n) {
                this.fProfileList.expandElement(arrayList.get(n), 1);
            }
        }
        this.fProfileList.selectElements((ISelection)new StructuredSelection((Object[])profileItemArray));
    }

    private void addFiles(String string, String[] stringArray) throws SAXException, IOException {
        if (stringArray != null && stringArray.length > 0) {
            HashMap hashMap = new HashMap();
            FileUtils fileUtils = new FileUtils();
            ProfileItem profileItem = (ProfileItem)((Object)this.fProfileList.getSelectedElements().get(0));
            this.getFiles(profileItem, hashMap);
            ProfileItem[] profileItemArray = new ProfileItem[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(fileUtils.resolve(string, stringArray[i], false));
                String string2 = file.getAbsolutePath();
                ProfileItem profileItem2 = (ProfileItem)((Object)hashMap.get(string2));
                if (profileItem2 == null) {
                    profileItem2 = new ProfileItem();
                    this.setupItem(profileItem2, string2);
                    profileItem.addChild(profileItem2);
                }
                profileItemArray[i] = profileItem2;
            }
            this.fProfileList.refresh((Object)profileItem);
            this.select(profileItem, profileItemArray);
        }
    }

    private void reportError(Exception exception) {
        Object object = exception instanceof CoreException ? ((CoreException)((Object)exception)).getStatus() : new Status(4, "com.spket.js", 4, exception.getMessage(), (Throwable)exception);
        ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)object);
    }

    private void newFolder() {
        ProfileItem profileItem;
        String[] stringArray;
        File file;
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell());
        String string = directoryDialog.open();
        if (string != null && (file = new File(string)).exists() && file.isDirectory() && (stringArray = ProfileLoader.list((profileItem = (ProfileItem)((Object)this.fProfileList.getSelectedElements().get(0))).getName(), string)) != null && stringArray.length > 0) {
            try {
                this.addFiles(string, stringArray);
            }
            catch (Exception exception) {
                this.reportError(exception);
            }
        }
    }

    private void editFile(ProfileItem profileItem) {
        FileDialog fileDialog = new FileDialog(this.getShell(), profileItem == null ? 2 : 4);
        fileDialog.setFilterExtensions(new String[]{"*.js;*.jsb"});
        String string = fileDialog.open();
        if (string == null) {
            return;
        }
        try {
            if (profileItem == null) {
                String string2 = fileDialog.getFilterPath();
                if (string2 != null && string2.length() > 0) {
                    String[] stringArray = fileDialog.getFileNames();
                    this.addFiles(string2, stringArray);
                }
            } else if (!string.equals(profileItem.getName())) {
                HashMap hashMap = new HashMap();
                ProfileItem profileItem2 = (ProfileItem)((Object)profileItem.getParent());
                this.getFiles(profileItem2, hashMap);
                ProfileItem profileItem3 = (ProfileItem)((Object)hashMap.get(string));
                if (profileItem3 == null) {
                    this.setupItem(profileItem, string);
                    this.fProfileList.refresh((Object)profileItem);
                } else {
                    profileItem2.removeChild(profileItem);
                    this.fProfileList.refresh((Object)profileItem2);
                    this.select(profileItem2, new ProfileItem[]{profileItem3});
                }
            }
        }
        catch (Exception exception) {
            this.reportError(exception);
        }
    }

    protected void setupItem(ProfileItem profileItem, String string) throws SAXException, IOException {
        Element[] elementArray;
        profileItem.setName(string);
        profileItem.setCategory(4);
        boolean bl = string.endsWith(".jsb");
        profileItem.setImage(bl ? imgJSB : imgJavaScript);
        if (bl && (elementArray = ProfileLoader.getTargets(ProfileLoader.getDocument(string))) != null && elementArray.length > 0) {
            FileUtils fileUtils = new FileUtils();
            ProfileItem[] profileItemArray = new ProfileItem[elementArray.length];
            for (int i = 0; i < elementArray.length; ++i) {
                String[] stringArray;
                ProfileItem profileItem2;
                Element element = elementArray[i];
                profileItemArray[i] = profileItem2 = new ProfileItem();
                profileItem2.setName(element.getAttribute("name"));
                profileItem2.setCategory(6);
                profileItem2.setImage(imgUnchecked);
                if (!element.hasChildNodes() || (stringArray = ProfileLoader.getIncludes(element)) == null || stringArray.length <= 0) continue;
                ProfileItem[] profileItemArray2 = new ProfileItem[stringArray.length];
                for (int j = 0; j < stringArray.length; ++j) {
                    ProfileItem profileItem3;
                    String string2 = fileUtils.resolve(string, stringArray[j], true);
                    profileItemArray2[j] = profileItem3 = new ProfileItem();
                    profileItem3.setName(string2);
                    profileItem3.setCategory(7);
                    profileItem3.setImage(imgJavaScript);
                }
                profileItem2.setChildren((Object[])profileItemArray2);
            }
            profileItem.setChildren((Object[])profileItemArray);
        }
    }

    protected void getFiles(ProfileItem profileItem, Map map) {
        if (profileItem.hasChildren()) {
            Object[] objectArray = profileItem.getChildren();
            for (int i = 0; i < objectArray.length; ++i) {
                ProfileItem profileItem2 = (ProfileItem)((Object)objectArray[i]);
                if (profileItem2.getCategory() == 4) {
                    map.put(profileItem2.getName(), profileItem2);
                } else if (profileItem2.getCategory() == 7) {
                    Object object = profileItem2.getData();
                    if (object instanceof String) {
                        map.put(object, profileItem2);
                    } else {
                        map.put(profileItem2.getName(), profileItem2);
                    }
                }
                if (!profileItem2.hasChildren() || profileItem2.getCategory() == 6 && profileItem2.getData() == null) continue;
                this.getFiles(profileItem2, map);
            }
        }
    }

    private void targetChanged(ProfileItem profileItem) {
        Object object = profileItem.getData();
        ProfileItem profileItem2 = (ProfileItem)((Object)profileItem.getParent());
        Object[] objectArray = profileItem2.getChildren();
        if (object == null) {
            int n = -1;
            int n2 = 0;
            for (int i = 0; i < objectArray.length; ++i) {
                ProfileItem profileItem3 = (ProfileItem)((Object)objectArray[i]);
                if (profileItem3 == profileItem) {
                    n2 = i;
                }
                if (n != -1 || profileItem3.getData() != null) continue;
                n = i;
            }
            if (n == -1) {
                n = 0;
            }
            if (n != n2) {
                objectArray[n2] = objectArray[n];
                objectArray[n] = profileItem;
            }
            profileItem.setData(Boolean.TRUE);
            profileItem.setImage(imgChecked);
        } else {
            ProfileItem profileItem4;
            int n = -1;
            int n3 = 0;
            for (n3 = 0; n3 < objectArray.length && (profileItem4 = (ProfileItem)((Object)objectArray[n3])).getData() != null; ++n3) {
                if (n == -1) {
                    if (profileItem4 != profileItem) continue;
                    n = n3;
                    continue;
                }
                objectArray[n] = objectArray[n3];
                n = n3;
            }
            if (n != n3) {
                objectArray[n] = profileItem;
                this.fProfileList.refresh((Object)profileItem2);
            }
            profileItem.setData(null);
            profileItem.setImage(imgUnchecked);
        }
        this.fProfileList.refresh((Object)profileItem2);
        this.fProfileList.selectElements((ISelection)new StructuredSelection((Object)profileItem));
    }

    private void removeEntry() {
        ArrayList<ProfileItem> arrayList = new ArrayList<ProfileItem>();
        List list = this.fProfileList.getSelectedElements();
        for (int i = 0; i < list.size(); ++i) {
            ProfileItem profileItem = (ProfileItem)((Object)list.get(i));
            ProfileItem profileItem2 = (ProfileItem)((Object)profileItem.getParent());
            if (profileItem.getCategory() == 2) {
                Profile profile;
                if (this.fProfileId != null && (profile = (Profile)profileItem.getData()) != null && this.fProfileId.equals(profile.getId())) {
                    this.fProfileId = null;
                    this.setValue(PREF_PROFILE, null);
                }
                this.fProfileList.removeElement((Object)profileItem);
                continue;
            }
            if (list.contains((Object)profileItem2)) continue;
            profileItem2.removeChild(profileItem);
            arrayList.add(profileItem2);
        }
        this.fProfileList.refresh();
        if (arrayList.size() > 0) {
            this.fProfileList.selectElements((ISelection)new StructuredSelection(arrayList));
        } else if (this.fProfileList.getElements().size() > 0) {
            this.fProfileList.selectFirstElement();
        }
    }

    private void doMoveUp() {
        List list = this.fProfileList.getSelectedElements();
        ProfileItem profileItem = this.getCommonParent(list);
        if (profileItem != null) {
            Object[] objectArray = profileItem.getChildren();
            for (int i = 1; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (!list.contains(object)) continue;
                objectArray[i] = objectArray[i - 1];
                objectArray[i - 1] = object;
            }
            this.fProfileList.refresh((Object)profileItem);
            this.fProfileList.selectElements((ISelection)new StructuredSelection(list));
        }
    }

    private void doMoveDown() {
        List list = this.fProfileList.getSelectedElements();
        ProfileItem profileItem = this.getCommonParent(list);
        if (profileItem != null) {
            Object[] objectArray = profileItem.getChildren();
            for (int i = objectArray.length - 2; i >= 0; --i) {
                Object object = objectArray[i];
                if (!list.contains(object)) continue;
                objectArray[i] = objectArray[i + 1];
                objectArray[i + 1] = object;
            }
            this.fProfileList.refresh((Object)profileItem);
            this.fProfileList.selectElements((ISelection)new StructuredSelection(list));
        }
    }

    private String generateProfileId(String string) {
        String string2 = string;
        List list = this.fProfileList.getElements();
        if (list.size() > 0) {
            int n;
            HashSet<String> hashSet = new HashSet<String>(list.size());
            for (n = 0; n < list.size(); ++n) {
                Profile profile = (Profile)((ProfileItem)((Object)list.get(n))).getData();
                hashSet.add(profile.getId());
            }
            n = 0;
            while (hashSet.contains(string2)) {
                string2 = string + n;
                ++n;
            }
        }
        return string2;
    }

    private boolean canReload(List list) {
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                ProfileItem profileItem = (ProfileItem)((Object)list.get(i));
                if (profileItem.getCategory() == 1 || profileItem.getCategory() == 2) {
                    Profile profile = (Profile)profileItem.getData();
                    Context context = profile.getContext();
                    if (context != null && (context.isInitialized() || context.isFailed())) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private void reload() {
        List list = this.fProfileList.getSelectedElements();
        if (list.size() > 0) {
            ArrayList<Context> arrayList = new ArrayList<Context>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                Profile profile = (Profile)((ProfileItem)((Object)list.get(i))).getData();
                Context context = profile.getContext();
                if (context == null || !context.isInitialized() && !context.isFailed()) continue;
                arrayList.add(context);
            }
            if (arrayList.size() > 0) {
                ReloadContextJob reloadContextJob = new ReloadContextJob(arrayList);
                reloadContextJob.schedule();
            }
        }
    }

    private String[] getTargets(ProfileItem profileItem) {
        if (profileItem.hasChildren()) {
            ProfileItem profileItem2;
            ArrayList<String> arrayList = new ArrayList<String>();
            Object[] objectArray = profileItem.getChildren();
            for (int i = 0; i < objectArray.length && (profileItem2 = (ProfileItem)((Object)objectArray[i])).getData() != null; ++i) {
                arrayList.add(profileItem2.getName());
            }
            if (arrayList.size() > 0) {
                String[] stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
                return stringArray;
            }
        }
        return null;
    }

    private String convert(ProfileItem profileItem) {
        StringBuffer stringBuffer = new StringBuffer();
        if (profileItem.hasChildren()) {
            String string = null;
            Object[] objectArray = profileItem.getChildren();
            for (int i = 0; i < objectArray.length; ++i) {
                ProfileItem profileItem2 = (ProfileItem)((Object)objectArray[i]);
                if (!profileItem2.hasChildren()) continue;
                string = profileItem2.getName();
                Object[] objectArray2 = profileItem2.getChildren();
                for (int j = 0; j < objectArray2.length; ++j) {
                    ProfileItem profileItem3 = (ProfileItem)((Object)objectArray2[j]);
                    String string2 = profileItem3.getName();
                    if (string2.endsWith(".jsb")) {
                        String[] stringArray = this.getTargets(profileItem3);
                        stringBuffer.append("use namespace ").append(string);
                        if (stringArray != null) {
                            stringBuffer.append('(');
                            for (int k = 0; k < stringArray.length; ++k) {
                                if (k > 0) {
                                    stringBuffer.append(',');
                                }
                                stringBuffer.append('\"').append(ProfileLoader.escape(stringArray[k], '\"')).append('\"');
                            }
                            stringBuffer.append(')');
                        }
                        stringBuffer.append(";\n");
                    } else if (j == 0) {
                        stringBuffer.append("use namespace ");
                        stringBuffer.append(string).append(";\n");
                    }
                    stringBuffer.append("include '");
                    stringBuffer.append(ProfileLoader.escape(string2, '\''));
                    stringBuffer.append('\'').append(";\n");
                }
            }
        }
        return stringBuffer.toString();
    }

    private void initialize(ProfileItem profileItem) throws SAXException, IOException {
        Profile profile = (Profile)profileItem.getData();
        ProfileContext profileContext = (ProfileContext)profile.getContext();
        String string = profileContext.getContent();
        if (string != null && string.length() > 0) {
            String[] stringArray = null;
            Statement[] statementArray = null;
            ProfileItem profileItem2 = null;
            ArrayList<ProfileItem> arrayList = new ArrayList<ProfileItem>();
            ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>();
            CompilationUnitDeclaration compilationUnitDeclaration = ProfileLoader.parse(string.toCharArray());
            if (compilationUnitDeclaration == null) {
                return;
            }
            statementArray = compilationUnitDeclaration.statements;
            if (statementArray == null) {
                return;
            }
            for (int i = 0; i < statementArray.length; ++i) {
                Object[] objectArray;
                String string2;
                Expression expression;
                Statement statement = statementArray[i];
                if (statement instanceof UseStatement) {
                    stringArray = null;
                    expression = ((UseStatement)statement).namespaces;
                    string2 = ProfileLoader.getNamespace(expression);
                    if (profileItem2 != null && !string2.equals(profileItem2.getName())) {
                        if (arrayList2.size() > 0) {
                            objectArray = new ProfileItem[arrayList2.size()];
                            arrayList2.toArray(objectArray);
                            profileItem2.setChildren(objectArray);
                            arrayList2.clear();
                        }
                        profileItem2 = null;
                    }
                    if (profileItem2 == null) {
                        profileItem2 = new ProfileItem();
                        profileItem2.setName(string2);
                        profileItem2.setImage(imgLibrary);
                        profileItem2.setCategory(3);
                        arrayList.add(profileItem2);
                    }
                    if (!(expression instanceof InvokeExpression) || (objectArray = ((InvokeExpression)expression).arguments) == null || objectArray.length <= 0) continue;
                    stringArray = ProfileLoader.getTargets((Expression[])objectArray);
                    continue;
                }
                if (!(statement instanceof InclucdeStatement)) continue;
                expression = (InclucdeStatement)statement;
                string2 = ProfileLoader.decode(expression.filename);
                objectArray = new ProfileItem();
                this.setupItem((ProfileItem)objectArray, string2);
                if (objectArray.hasChildren() && stringArray != null) {
                    Object[] objectArray2 = objectArray.getChildren();
                    block1: for (int j = 0; j < stringArray.length; ++j) {
                        String string3 = stringArray[j];
                        for (int k = j; k < objectArray2.length; ++k) {
                            ProfileItem profileItem3 = (ProfileItem)((Object)objectArray2[k]);
                            if (!string3.equals(profileItem3.getName())) continue;
                            objectArray2[k] = objectArray2[j];
                            objectArray2[j] = profileItem3;
                            profileItem3.setData(Boolean.TRUE);
                            profileItem3.setImage(imgChecked);
                            continue block1;
                        }
                    }
                }
                arrayList2.add(objectArray);
            }
            if (profileItem2 != null && arrayList2.size() > 0) {
                ProfileItem[] profileItemArray = new ProfileItem[arrayList2.size()];
                arrayList2.toArray(profileItemArray);
                profileItem2.setChildren((Object[])profileItemArray);
            }
            if (arrayList.size() > 0) {
                ProfileItem[] profileItemArray = new ProfileItem[arrayList.size()];
                arrayList.toArray(profileItemArray);
                profileItem.setChildren((Object[])profileItemArray);
            }
        }
    }

    private class TargetListener
    implements Listener {
        private TreeItem fItem;

        private TargetListener() {
        }

        public void handleEvent(Event event) {
            if ((event.stateMask & SWT.MODIFIER_MASK) != 0) {
                return;
            }
            if (!UIUtils.isLeftMouseButton((Event)event)) {
                this.fItem = null;
                return;
            }
            Tree tree = (Tree)event.widget;
            if (3 == event.type) {
                Rectangle rectangle;
                this.fItem = null;
                TreeItem treeItem = tree.getItem(new Point(event.x, event.y));
                if (treeItem != null && this.isTarget(treeItem.getData()) && (rectangle = treeItem.getImageBounds(0)) != null && rectangle.contains(event.x, event.y)) {
                    this.fItem = treeItem;
                }
            } else if (this.fItem != null) {
                Rectangle rectangle;
                Object object;
                TreeItem treeItem = this.fItem;
                this.fItem = null;
                TreeItem treeItem2 = tree.getItem(new Point(event.x, event.y));
                if (treeItem == treeItem2 && this.isTarget(object = treeItem2.getData()) && (rectangle = treeItem2.getImageBounds(0)) != null && rectangle.contains(event.x, event.y)) {
                    JSProfileConfigurationBlock.this.targetChanged((ProfileItem)((Object)object));
                }
            }
        }

        private boolean isTarget(Object object) {
            if (object instanceof ProfileItem) {
                return ((ProfileItem)((Object)object)).getCategory() == 6;
            }
            return false;
        }
    }

    private class ProfileLabelProvider
    extends LabelProvider
    implements IFontProvider,
    IColorProvider {
        private Color background;

        private ProfileLabelProvider() {
        }

        public Image getImage(Object object) {
            return ((ProfileItem)((Object)object)).getImage();
        }

        public String getText(Object object) {
            return ((ProfileItem)((Object)object)).getName();
        }

        public Color getBackground(Object object) {
            ProfileItem profileItem = (ProfileItem)((Object)object);
            if (profileItem.getCategory() == 1) {
                if (this.background == null) {
                    this.background = Display.getCurrent().getSystemColor(29);
                }
                return this.background;
            }
            return null;
        }

        public Color getForeground(Object object) {
            return null;
        }

        public Font getFont(Object object) {
            if (JSProfileConfigurationBlock.this.isDefaultProfile(object)) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
            return null;
        }
    }

    private class ProfileAdapter
    implements ITreeListAdapter,
    IDialogFieldListener {
        private ProfileAdapter() {
        }

        public void customButtonPressed(TreeListDialogField treeListDialogField, int n) {
            JSProfileConfigurationBlock.this.onButtonPressed(n);
        }

        public void doubleClicked(TreeListDialogField treeListDialogField) {
            if (JSProfileConfigurationBlock.this.canEdit(treeListDialogField.getSelectedElements())) {
                JSProfileConfigurationBlock.this.onButtonPressed(1);
            }
        }

        public void keyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
        }

        public void selectionChanged(TreeListDialogField treeListDialogField) {
            List list = treeListDialogField.getSelectedElements();
            treeListDialogField.enableButton(1, JSProfileConfigurationBlock.this.fProject == null ? JSProfileConfigurationBlock.this.canEdit(list) : false);
            treeListDialogField.enableButton(2, JSProfileConfigurationBlock.this.fProject == null ? JSProfileConfigurationBlock.this.canRemove(list) : false);
            treeListDialogField.enableButton(4, JSProfileConfigurationBlock.this.fProject == null ? JSProfileConfigurationBlock.this.canAddLibrary(list) : false);
            treeListDialogField.enableButton(5, JSProfileConfigurationBlock.this.fProject == null ? JSProfileConfigurationBlock.this.canAddFile(list) : false);
            treeListDialogField.enableButton(6, JSProfileConfigurationBlock.this.fProject == null ? JSProfileConfigurationBlock.this.canAddFolder(list) : false);
            treeListDialogField.enableButton(8, JSProfileConfigurationBlock.this.fProject == null ? JSProfileConfigurationBlock.this.canMoveUp(list) : false);
            treeListDialogField.enableButton(9, JSProfileConfigurationBlock.this.fProject == null ? JSProfileConfigurationBlock.this.canMoveDown(list) : false);
            treeListDialogField.enableButton(11, JSProfileConfigurationBlock.this.canSetToDefault(list));
            treeListDialogField.enableButton(12, JSProfileConfigurationBlock.this.canReload(list));
        }

        public void dialogFieldChanged(DialogField dialogField) {
            JSProfileConfigurationBlock.this.updateModel(dialogField);
        }

        public Object[] getChildren(TreeListDialogField treeListDialogField, Object object) {
            return ((ProfileItem)((Object)object)).getChildren();
        }

        public Object getParent(TreeListDialogField treeListDialogField, Object object) {
            return ((ProfileItem)((Object)object)).getParent();
        }

        public boolean hasChildren(TreeListDialogField treeListDialogField, Object object) {
            return ((ProfileItem)((Object)object)).hasChildren();
        }
    }

    private static class ProfileSorter
    extends ViewerComparator {
        private ProfileSorter() {
        }

        public int category(Object object) {
            return ((ProfileItem)((Object)object)).getCategory();
        }

        public int compare(Viewer viewer, Object object, Object object2) {
            int n = this.category(object);
            int n2 = this.category(object2);
            if (n < 3 && n2 < 3) {
                if (n != n2) {
                    return n - n2;
                }
                return this.getComparator().compare(((ProfileItem)((Object)object)).getName(), ((ProfileItem)((Object)object2)).getName());
            }
            if (6 == n && n == n2) {
                ProfileItem profileItem = (ProfileItem)((Object)object);
                ProfileItem profileItem2 = (ProfileItem)((Object)object2);
                Object object3 = profileItem.getData();
                Object object4 = profileItem2.getData();
                if (object3 == null) {
                    if (object4 != null) {
                        return 1;
                    }
                } else {
                    if (object4 == null) {
                        return -1;
                    }
                    return 0;
                }
                return this.getComparator().compare(profileItem.getName(), profileItem2.getName());
            }
            return 0;
        }
    }
}

