/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.internal.text;

import com.spket.js.internal.JSPlugin;
import com.spket.ui.text.AutoEditStrategy;
import com.spket.util.Debug;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;

public class JSStringAutoIndentStrategy
extends AutoEditStrategy {
    private static final char[] JOIN = new char[]{' ', '+'};
    private static final char[] IDENT = new char[]{'\t', '\t'};

    public JSStringAutoIndentStrategy(String string) {
        super(string);
    }

    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.text == null) {
            return;
        }
        IPreferenceStore iPreferenceStore = JSPlugin.getDefault().getPreferenceStore();
        if (iPreferenceStore.getBoolean("wrapStrings") && this.isSmartMode()) {
            try {
                this.indentStringAfterNewLine(iDocument, documentCommand);
            }
            catch (BadLocationException badLocationException) {
                Debug.debug((Throwable)badLocationException);
            }
        }
    }

    private void indentStringAfterNewLine(IDocument iDocument, DocumentCommand documentCommand) throws BadLocationException {
        if (this.isLineDelimiter(iDocument, documentCommand.text)) {
            ITypedRegion iTypedRegion = TextUtilities.getPartition((IDocument)iDocument, (String)this.fPartitioning, (int)documentCommand.offset, (boolean)true);
            int n = iTypedRegion.getOffset();
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            char c = iDocument.getChar(n);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(c);
            stringBuffer.append(JOIN);
            stringBuffer.append(documentCommand.text);
            stringBuffer.append(this.getLineIndentation(iDocument, documentCommand.offset));
            for (int i = n - 1; i >= iRegion.getOffset(); --i) {
                if (Character.isWhitespace(iDocument.getChar(i))) continue;
                stringBuffer.append(IDENT);
                break;
            }
            stringBuffer.append(c);
            documentCommand.text = stringBuffer.toString();
        }
    }
}

