/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.internal.text;

import com.spket.js.internal.text.JSPairMatcher;
import com.spket.js.internal.text.Partitioner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

public class JSDoubleClickStrategy
implements ITextDoubleClickStrategy {
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']'};
    protected JSPairMatcher fPairMatcher;

    public JSDoubleClickStrategy(Partitioner partitioner) {
        this.fPairMatcher = new JSPairMatcher(partitioner, BRACKETS);
    }

    public void doubleClicked(ITextViewer iTextViewer) {
        int n = iTextViewer.getSelectedRange().x;
        if (n < 0) {
            return;
        }
        IDocument iDocument = iTextViewer.getDocument();
        IRegion iRegion = this.fPairMatcher.match(iDocument, n);
        if (iRegion != null && iRegion.getLength() >= 2) {
            iTextViewer.setSelectedRange(iRegion.getOffset() + 1, iRegion.getLength() - 2);
        } else {
            this.selectWord(iTextViewer, iDocument, n);
        }
    }

    protected void selectWord(ITextViewer iTextViewer, IDocument iDocument, int n) {
        try {
            char c;
            int n2;
            for (n2 = n; n2 >= 0 && Character.isJavaIdentifierPart(c = iDocument.getChar(n2)); --n2) {
            }
            int n3 = n2;
            int n4 = iDocument.getLength();
            for (n2 = n; n2 < n4 && Character.isJavaIdentifierPart(c = iDocument.getChar(n2)); ++n2) {
            }
            int n5 = n2;
            if (n3 == n5) {
                iTextViewer.setSelectedRange(n3, 0);
            } else {
                iTextViewer.setSelectedRange(n3 + 1, n5 - n3 - 1);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

