/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.internal.text;

import com.spket.js.internal.JSMessages;
import com.spket.ui.text.html.HTMLPrinter;
import com.spket.ui.text.html.SubstitutionTextReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JSDoc2HTMLTextReader
extends SubstitutionTextReader {
    private List fParameters;
    private String fReturn;
    private List fExceptions;
    private List fAuthors;
    private List fSees;
    private List fSince;
    private List fRest;

    public JSDoc2HTMLTextReader(Reader reader) {
        super(reader);
        this.setSkipWhitespace(false);
    }

    private int getTag(StringBuffer stringBuffer) throws IOException {
        int n = this.nextChar();
        while (n == 46 || n != -1 && Character.isLetter((char)n)) {
            stringBuffer.append((char)n);
            n = this.nextChar();
        }
        return n;
    }

    private int getContent(StringBuffer stringBuffer, char c) throws IOException {
        int n = this.nextChar();
        while (n != -1 && n != c) {
            stringBuffer.append((char)n);
            n = this.nextChar();
        }
        return n;
    }

    private int getContentUntilNextTag(StringBuffer stringBuffer) throws IOException {
        int n = this.nextChar();
        boolean bl = false;
        while (n != -1) {
            if (n == 64) {
                int n2 = stringBuffer.length();
                while (--n2 >= 0 && Character.isWhitespace(stringBuffer.charAt(n2))) {
                    switch (stringBuffer.charAt(n2)) {
                        case '\n': 
                        case '\r': {
                            return n;
                        }
                    }
                    if (n2 > 0) continue;
                    return n;
                }
            }
            if (bl) {
                stringBuffer.append(this.processBlockTag());
                bl = false;
            } else {
                stringBuffer.append((char)n);
            }
            n = this.nextChar();
            bl = n == 123;
        }
        return n;
    }

    private String subsituteQualification(String string) {
        String string2 = string.replace('#', '.');
        if (string2.startsWith(".")) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    private void printDefinitions(StringBuffer stringBuffer, List list, boolean bl) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append("<dd>");
            if (!bl) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append("<b>");
                int n = this.getParamEndOffset(string);
                if (n <= string.length()) {
                    stringBuffer.append(HTMLPrinter.convertToHTMLContent((String)string.substring(0, n)));
                    stringBuffer.append("</b>");
                    stringBuffer.append(string.substring(n));
                } else {
                    stringBuffer.append("</b>");
                }
            }
            stringBuffer.append("</dd>");
        }
    }

    private int getParamEndOffset(String string) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        if (n < n2 && string.charAt(n) == '<') {
            while (n < n2 && Character.isWhitespace(string.charAt(n))) {
                ++n;
            }
            while (n < n2 && Character.isJavaIdentifierPart(string.charAt(n))) {
                ++n;
            }
            while (n < n2 && string.charAt(n) != '>') {
                ++n;
            }
        } else {
            while (n < n2 && Character.isJavaIdentifierPart(string.charAt(n))) {
                ++n;
            }
        }
        return n;
    }

    private void print(StringBuffer stringBuffer, String string, List list, boolean bl) {
        if (!list.isEmpty()) {
            stringBuffer.append("<dt>");
            stringBuffer.append(string);
            stringBuffer.append("</dt>");
            this.printDefinitions(stringBuffer, list, bl);
        }
    }

    private void print(StringBuffer stringBuffer, String string, String string2) {
        if (string2 != null) {
            stringBuffer.append("<dt>");
            stringBuffer.append(string);
            stringBuffer.append("</dt>");
            stringBuffer.append("<dd>");
            stringBuffer.append(string2);
            stringBuffer.append("</dd>");
        }
    }

    private void printRest(StringBuffer stringBuffer) {
        if (!this.fRest.isEmpty()) {
            Iterator iterator = this.fRest.iterator();
            while (iterator.hasNext()) {
                Pair pair = (Pair)iterator.next();
                stringBuffer.append("<dt>");
                if (pair.fTag != null) {
                    stringBuffer.append(pair.fTag);
                }
                stringBuffer.append("</dt>");
                stringBuffer.append("<dd>");
                if (pair.fContent != null) {
                    stringBuffer.append(pair.fContent);
                }
                stringBuffer.append("</dd>");
            }
        }
    }

    private String printSimpleTag() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<dl>");
        this.print(stringBuffer, JSMessages.JSDoc_see_section, this.fSees, false);
        this.print(stringBuffer, JSMessages.JSDoc_parameters_section, this.fParameters, true);
        this.print(stringBuffer, JSMessages.JSDoc_returns_section, this.fReturn);
        this.print(stringBuffer, JSMessages.JSDoc_throws_section, this.fExceptions, false);
        this.print(stringBuffer, JSMessages.JSDoc_author_section, this.fAuthors, false);
        this.print(stringBuffer, JSMessages.JSDoc_since_section, this.fSince, false);
        this.printRest(stringBuffer);
        stringBuffer.append("</dl>");
        return stringBuffer.toString();
    }

    private void handleTag(String string, String string2) {
        string2 = string2.trim();
        if ("@param".equals(string)) {
            this.fParameters.add(string2);
        } else if ("@return".equals(string)) {
            this.fReturn = string2;
        } else if ("@exception".equals(string)) {
            this.fExceptions.add(string2);
        } else if ("@throws".equals(string)) {
            this.fExceptions.add(string2);
        } else if ("@author".equals(string)) {
            this.fAuthors.add(this.subsituteQualification(string2));
        } else if ("@see".equals(string)) {
            this.fSees.add(this.subsituteQualification(string2));
        } else if ("@since".equals(string)) {
            this.fSince.add(this.subsituteQualification(string2));
        } else if (string2 != null) {
            this.fRest.add(new Pair(string, string2));
        }
    }

    private String processSimpleTag() throws IOException {
        this.fParameters = new ArrayList();
        this.fExceptions = new ArrayList();
        this.fAuthors = new ArrayList();
        this.fSees = new ArrayList();
        this.fSince = new ArrayList();
        this.fRest = new ArrayList();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 64;
        while (n != -1) {
            stringBuffer.setLength(0);
            stringBuffer.append((char)n);
            n = this.getTag(stringBuffer);
            String string = stringBuffer.toString();
            stringBuffer.setLength(0);
            if (n != -1) {
                n = this.getContentUntilNextTag(stringBuffer);
            }
            this.handleTag(string, stringBuffer.toString());
        }
        return this.printSimpleTag();
    }

    private String printBlockTag(String string, String string2) {
        if ("@link".equals(string) || "@linkplain".equals(string)) {
            char[] cArray = string2.toCharArray();
            boolean bl = false;
            int n = 0;
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (i == 0 && Character.isWhitespace(c)) {
                    n = 1;
                    continue;
                }
                if (c == '(') {
                    bl = true;
                    continue;
                }
                if (c == ')') {
                    bl = false;
                    continue;
                }
                if (bl || !Character.isWhitespace(c)) continue;
                n = i + 1;
                break;
            }
            return this.subsituteQualification(string2.substring(n));
        }
        return this.subsituteQualification(string2);
    }

    private String processBlockTag() throws IOException {
        int n = this.nextChar();
        if (n != 64) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('{');
            stringBuffer.append((char)n);
            return stringBuffer.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n != -1) {
            stringBuffer.setLength(0);
            stringBuffer.append((char)n);
            n = this.getTag(stringBuffer);
            String string = stringBuffer.toString();
            stringBuffer.setLength(0);
            if (n != -1 & n != 125) {
                stringBuffer.append((char)n);
                n = this.getContent(stringBuffer, '}');
            }
            return this.printBlockTag(string, stringBuffer.toString());
        }
        return null;
    }

    protected String computeSubstitution(int n) throws IOException {
        if (n == 64 && this.fWasWhiteSpace) {
            return this.processSimpleTag();
        }
        if (n == 123) {
            return this.processBlockTag();
        }
        return null;
    }

    private static class Pair {
        String fTag;
        String fContent;

        Pair(String string, String string2) {
            this.fTag = string;
            this.fContent = string2;
        }
    }
}

