/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.internal.text;

import com.spket.js.internal.text.JSWhitespaceDetector;
import com.spket.js.internal.text.JSWordDetector;
import com.spket.ui.text.CombinedWordRule;
import com.spket.ui.text.ConfigurableScanner;
import com.spket.ui.text.IColorManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;

public class JSCodeScanner
extends ConfigurableScanner {
    private static String[] fgKeywords = new String[]{"break", "case", "catch", "const", "continue", "default", "delete", "do", "else", "finally", "for", "function", "if", "in", "instanceof", "new", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with"};
    private static final String RETURN = "return";
    private static String[] fgConstants = new String[]{"false", "null", "true"};
    private static String[] fgReserved = new String[]{"abstract", "boolean", "byte", "char", "class", "debugger", "double", "each", "enum", "export", "extends", "final", "float", "get", "goto", "implements", "import", "include", "int", "interface", "long", "namespace", "native", "package", "private", "protected", "public", "set", "short", "static", "super", "synchronized", "throws", "transient", "volatile", "xml"};
    private static String[] fgTokenProperties = new String[]{"js_default", "js_keyword", "js_keyword_return", "js_reserved", "js_operator"};

    public JSCodeScanner(IColorManager iColorManager, IPreferenceStore iPreferenceStore) {
        super(iColorManager, iPreferenceStore);
        this.initialize();
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    protected List createRules() {
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new WhitespaceRule((IWhitespaceDetector)new JSWhitespaceDetector()));
        JSWordDetector jSWordDetector = new JSWordDetector();
        Token token = this.getToken("js_default");
        CombinedWordRule combinedWordRule = new CombinedWordRule((IWordDetector)jSWordDetector, (IToken)token);
        token = this.getToken("js_operator");
        arrayList.add(new OperatorRule((IToken)token));
        CombinedWordRule.WordMatcher wordMatcher = new CombinedWordRule.WordMatcher();
        token = this.getToken("js_keyword_return");
        wordMatcher.addWord(RETURN, (IToken)token);
        combinedWordRule.addWordMatcher(wordMatcher);
        CombinedWordRule.WordMatcher wordMatcher2 = new CombinedWordRule.WordMatcher();
        token = this.getToken("js_keyword");
        for (n = 0; n < fgKeywords.length; ++n) {
            wordMatcher2.addWord(fgKeywords[n], (IToken)token);
        }
        for (n = 0; n < fgConstants.length; ++n) {
            wordMatcher2.addWord(fgConstants[n], (IToken)token);
        }
        combinedWordRule.addWordMatcher(wordMatcher2);
        wordMatcher2 = new CombinedWordRule.WordMatcher();
        token = this.getToken("js_reserved");
        for (n = 0; n < fgReserved.length; ++n) {
            wordMatcher2.addWord(fgReserved[n], (IToken)token);
        }
        combinedWordRule.addWordMatcher(wordMatcher2);
        arrayList.add(combinedWordRule);
        this.setDefaultReturnToken((IToken)this.getToken("js_default"));
        return arrayList;
    }

    protected class OperatorRule
    implements IRule {
        private final IToken fToken;
        private final char[] JAVA_OPERATORS = new char[]{';', '(', ')', '{', '}', '.', '=', '/', '\\', '+', '-', '*', '[', ']', '<', '>', ':', '?', '!', ',', '|', '&', '^', '%', '~'};

        public OperatorRule(IToken iToken) {
            this.fToken = iToken;
        }

        public boolean isOperator(char c) {
            for (int i = 0; i < this.JAVA_OPERATORS.length; ++i) {
                if (this.JAVA_OPERATORS[i] != c) continue;
                return true;
            }
            return false;
        }

        public IToken evaluate(ICharacterScanner iCharacterScanner) {
            int n = iCharacterScanner.read();
            if (this.isOperator((char)n)) {
                while (this.isOperator((char)(n = iCharacterScanner.read()))) {
                }
                iCharacterScanner.unread();
                return this.fToken;
            }
            iCharacterScanner.unread();
            return Token.UNDEFINED;
        }
    }
}

