/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.internal.text;

import com.spket.as.core.compiler.InvalidInputException;
import com.spket.as.internal.compiler.parser.Scanner;
import com.spket.as.internal.compiler.parser.ScannerHelper;
import com.spket.js.model.Context;
import com.spket.ui.editors.PlainTextEditor;
import com.spket.util.Debug;
import java.util.Stack;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class BracketInserter
implements VerifyKeyListener,
ILinkedModeListener {
    private String[] fContentTypes;
    private PlainTextEditor fEditor;
    private String fDocumentPartitioning;
    private boolean fCloseBrackets = true;
    private boolean fCloseStrings = true;
    private final String CATEGORY = this.toString();
    private IPositionUpdater fUpdater = new ExclusivePositionUpdater(this.CATEGORY);
    private Stack fBracketLevelStack = new Stack();

    private static char getEscapeCharacter(char c) {
        switch (c) {
            case '\"': 
            case '\'': {
                return '\\';
            }
        }
        return '\u0000';
    }

    private static char getPeerCharacter(char c) {
        switch (c) {
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '\"': 
            case '\'': {
                return c;
            }
        }
        throw new IllegalArgumentException();
    }

    public BracketInserter(PlainTextEditor plainTextEditor, String string) {
        this.fEditor = plainTextEditor;
        this.fDocumentPartitioning = string;
    }

    public void setCloseBracketsEnabled(boolean bl) {
        this.fCloseBrackets = bl;
    }

    public void setCloseStringsEnabled(boolean bl) {
        this.fCloseStrings = bl;
    }

    public void setContentTypes(String[] stringArray) {
        this.fContentTypes = stringArray;
    }

    public void verifyKey(VerifyEvent verifyEvent) {
        if (!verifyEvent.doit || this.getInsertMode() != ITextEditorExtension3.SMART_INSERT) {
            return;
        }
        switch (verifyEvent.character) {
            case '\"': 
            case '\'': 
            case '(': 
            case '[': {
                break;
            }
            default: {
                return;
            }
        }
        ISourceViewer iSourceViewer = this.getSourceViewer();
        IDocument iDocument = iSourceViewer.getDocument();
        Point point = iSourceViewer.getSelectedRange();
        int n = point.x;
        int n2 = point.y;
        try {
            char c;
            int n3;
            String string = TextUtilities.getPartition((IDocument)iDocument, (String)this.fDocumentPartitioning, (int)n, (boolean)true).getType();
            if (this.fContentTypes == null) {
                if (!"__dftl_partition_content_type".equals(string)) {
                    return;
                }
            } else {
                boolean bl = false;
                for (int i = 0; i < this.fContentTypes.length; ++i) {
                    if (!this.fContentTypes[i].equals(string)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    return;
                }
            }
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            IRegion iRegion2 = iDocument.getLineInformationOfOffset(n + n2);
            int n4 = iRegion2.getOffset() + iRegion2.getLength();
            block4 : switch (verifyEvent.character) {
                case '(': {
                    if (!this.fCloseBrackets) {
                        return;
                    }
                    for (n3 = n + n2; n3 < n4; ++n3) {
                        c = iDocument.getChar(n3);
                        if (c == '(' || c >= '0' && c <= '9') {
                            return;
                        }
                        if (Character.isWhitespace(c)) continue;
                        if (!Character.isJavaIdentifierStart(c)) break block4;
                        return;
                    }
                    break;
                }
                case '[': {
                    if (!this.fCloseBrackets) {
                        return;
                    }
                    for (n3 = n + n2; n3 < n4; ++n3) {
                        c = iDocument.getChar(n3);
                        if (c >= '0' && c <= '9') {
                            return;
                        }
                        if (Character.isWhitespace(c)) continue;
                        if (!Character.isJavaIdentifierStart(c)) break block4;
                        return;
                    }
                    break;
                }
                case '\"': 
                case '\'': {
                    if (!this.fCloseStrings) {
                        return;
                    }
                    for (n3 = n + n2; n3 < n4; ++n3) {
                        c = iDocument.getChar(n3);
                        if (c >= '0' && c <= '9') {
                            return;
                        }
                        if (Character.isWhitespace(c)) continue;
                        if (!Character.isJavaIdentifierStart(c)) break;
                        return;
                    }
                    for (n3 = n; n3 > 0 && n3 > iRegion.getOffset(); --n3) {
                        c = iDocument.getChar(n3);
                        if (c >= '0' && c <= '9') {
                            return;
                        }
                        if (Character.isWhitespace(c)) continue;
                        if (!Character.isJavaIdentifierPart(c)) break block4;
                        return;
                    }
                    break;
                }
                default: {
                    return;
                }
            }
            if (!this.validateEditorInputState()) {
                return;
            }
            n3 = verifyEvent.character;
            c = BracketInserter.getPeerCharacter((char)n3);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append((char)n3);
            stringBuffer.append(c);
            iDocument.replace(n, n2, stringBuffer.toString());
            BracketLevel bracketLevel = new BracketLevel();
            this.fBracketLevelStack.push(bracketLevel);
            LinkedPositionGroup linkedPositionGroup = new LinkedPositionGroup();
            linkedPositionGroup.addPosition(new LinkedPosition(iDocument, n + 1, 0, -1));
            LinkedModeModel linkedModeModel = new LinkedModeModel();
            linkedModeModel.addLinkingListener((ILinkedModeListener)this);
            linkedModeModel.addGroup(linkedPositionGroup);
            linkedModeModel.forceInstall();
            bracketLevel.fOffset = n;
            bracketLevel.fLength = 2;
            if (this.fBracketLevelStack.size() == 1) {
                iDocument.addPositionCategory(this.CATEGORY);
                iDocument.addPositionUpdater(this.fUpdater);
            }
            bracketLevel.fFirstPosition = new Position(n, 1);
            bracketLevel.fSecondPosition = new Position(n + 1, 1);
            iDocument.addPosition(this.CATEGORY, bracketLevel.fFirstPosition);
            iDocument.addPosition(this.CATEGORY, bracketLevel.fSecondPosition);
            bracketLevel.fUI = new EditorLinkedModeUI(linkedModeModel, (ITextViewer)iSourceViewer);
            bracketLevel.fUI.setSimpleMode(true);
            bracketLevel.fUI.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(c, BracketInserter.getEscapeCharacter(c), this.fBracketLevelStack));
            bracketLevel.fUI.setExitPosition((ITextViewer)iSourceViewer, n + 2, 0, Integer.MAX_VALUE);
            bracketLevel.fUI.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
            bracketLevel.fUI.enter();
            IRegion iRegion3 = bracketLevel.fUI.getSelectedRegion();
            iSourceViewer.setSelectedRange(iRegion3.getOffset(), iRegion3.getLength());
            verifyEvent.doit = false;
        }
        catch (BadLocationException badLocationException) {
            this.log(badLocationException);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            this.log(badPositionCategoryException);
        }
    }

    public void left(LinkedModeModel linkedModeModel, int n) {
        final BracketLevel bracketLevel = (BracketLevel)this.fBracketLevelStack.pop();
        if (n != 8) {
            return;
        }
        ISourceViewer iSourceViewer = this.getSourceViewer();
        final IDocument iDocument = iSourceViewer.getDocument();
        if (iDocument instanceof IDocumentExtension) {
            IDocumentExtension iDocumentExtension = (IDocumentExtension)iDocument;
            iDocumentExtension.registerPostNotificationReplace(null, new IDocumentExtension.IReplace(){

                public void perform(IDocument iDocument2, IDocumentListener iDocumentListener) {
                    if ((bracketLevel.fFirstPosition.isDeleted || bracketLevel.fFirstPosition.length == 0) && !bracketLevel.fSecondPosition.isDeleted && bracketLevel.fSecondPosition.offset == bracketLevel.fFirstPosition.offset) {
                        try {
                            iDocument.replace(bracketLevel.fSecondPosition.offset, bracketLevel.fSecondPosition.length, "");
                        }
                        catch (BadLocationException badLocationException) {
                            BracketInserter.this.log(badLocationException);
                        }
                    }
                    if (BracketInserter.this.fBracketLevelStack.size() == 0) {
                        iDocument.removePositionUpdater(BracketInserter.this.fUpdater);
                        try {
                            iDocument.removePositionCategory(BracketInserter.this.CATEGORY);
                        }
                        catch (BadPositionCategoryException badPositionCategoryException) {
                            BracketInserter.this.log(badPositionCategoryException);
                        }
                    }
                }
            });
        }
    }

    public void resume(LinkedModeModel linkedModeModel, int n) {
    }

    public void suspend(LinkedModeModel linkedModeModel) {
    }

    protected ISourceViewer getSourceViewer() {
        return this.fEditor.getViewer();
    }

    protected void log(Throwable throwable) {
        Debug.debug((Throwable)throwable);
    }

    protected ITextEditorExtension3.InsertMode getInsertMode() {
        return this.fEditor.getInsertMode();
    }

    protected boolean validateEditorInputState() {
        return this.fEditor.validateEditorInputState();
    }

    protected boolean inRegExp(IDocument iDocument, int n, int n2, int n3) throws BadLocationException {
        int n4;
        while (n < n2) {
            if (Character.isWhitespace((char)(n4 = iDocument.getChar(n++)))) continue;
            --n;
            break;
        }
        if (n < n3) {
            n4 = n3 - n;
            char[] cArray = iDocument.get(n, n2 - n).toCharArray();
            Scanner scanner = new Scanner(Context.JS_1_6);
            scanner.setSource(cArray);
            int n5 = 0;
            int n6 = 0;
            while (true) {
                try {
                    n5 = scanner.getNextToken();
                }
                catch (InvalidInputException invalidInputException) {
                    String string = invalidInputException.getMessage();
                    n5 = "Unterminated_RegExp" == string || "Invalid_RegExp_Flag" == string ? 59 : 116;
                }
                if (n5 == 45) break;
                if ((n5 == 10 || n5 == 89) && (ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[n6] & 0x300000) == 0) {
                    try {
                        n5 = scanner.scanRegExp();
                    }
                    catch (InvalidInputException invalidInputException) {
                        n5 = 59;
                    }
                }
                if (scanner.currentPosition >= n4) {
                    return 59 == n5;
                }
                n6 = n5;
            }
        }
        return false;
    }

    private static class ExclusivePositionUpdater
    implements IPositionUpdater {
        private final String fCategory;

        public ExclusivePositionUpdater(String string) {
            this.fCategory = string;
        }

        public void update(DocumentEvent documentEvent) {
            int n = documentEvent.getOffset();
            int n2 = documentEvent.getLength();
            int n3 = documentEvent.getText() == null ? 0 : documentEvent.getText().length();
            int n4 = n3 - n2;
            try {
                Position[] positionArray = documentEvent.getDocument().getPositions(this.fCategory);
                for (int i = 0; i != positionArray.length; ++i) {
                    int n5;
                    Position position = positionArray[i];
                    if (position.isDeleted()) continue;
                    int n6 = position.getOffset();
                    int n7 = position.getLength();
                    int n8 = n6 + n7;
                    if (n6 >= n + n2) {
                        position.setOffset(n6 + n4);
                        continue;
                    }
                    if (n8 <= n) continue;
                    if (n6 <= n && n8 >= n + n2) {
                        position.setLength(n7 + n4);
                        continue;
                    }
                    if (n6 < n) {
                        n5 = n;
                        position.setLength(n5 - n6);
                        continue;
                    }
                    if (n8 > n + n2) {
                        n5 = n + n3;
                        position.setOffset(n5);
                        position.setLength(n8 - n5);
                        continue;
                    }
                    position.delete();
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
        }

        public String getCategory() {
            return this.fCategory;
        }
    }

    private class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char fExitCharacter;
        final char fEscapeCharacter;
        final Stack fStack;
        final int fSize;

        public ExitPolicy(char c, char c2, Stack stack) {
            this.fExitCharacter = c;
            this.fEscapeCharacter = c2;
            this.fStack = stack;
            this.fSize = this.fStack.size();
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel linkedModeModel, VerifyEvent verifyEvent, int n, int n2) {
            if (this.fSize == this.fStack.size() && !this.isMasked(n)) {
                BracketLevel bracketLevel;
                if (verifyEvent.character == this.fExitCharacter) {
                    bracketLevel = (BracketLevel)this.fStack.peek();
                    if (bracketLevel.fFirstPosition.offset > n || bracketLevel.fSecondPosition.offset < n) {
                        return null;
                    }
                    if (bracketLevel.fSecondPosition.offset == n && n2 == 0) {
                        return new LinkedModeUI.ExitFlags(2, false);
                    }
                }
                if (verifyEvent.character == '\r' && n > 0) {
                    bracketLevel = BracketInserter.this.getSourceViewer().getDocument();
                    try {
                        if (bracketLevel.getChar(n - 1) == '{') {
                            return new LinkedModeUI.ExitFlags(1, true);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            return null;
        }

        private boolean isMasked(int n) {
            IDocument iDocument = BracketInserter.this.getSourceViewer().getDocument();
            try {
                return this.fEscapeCharacter == iDocument.getChar(n - 1);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
    }

    private static class BracketLevel {
        int fOffset;
        int fLength;
        LinkedModeUI fUI;
        Position fFirstPosition;
        Position fSecondPosition;

        private BracketLevel() {
        }
    }
}

