/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.internal;

import com.spket.js.internal.template.JSDocContextType;
import com.spket.js.internal.template.JavaScriptContextType;
import com.spket.js.text.JSTextTools;
import com.spket.ui.internal.UIPlugin;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.osgi.framework.BundleContext;

public class JSPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.spket.js";
    private static JSPlugin plugin;
    private JSTextTools textTools;
    private TemplateStore fTemplateStore;
    private ContextTypeRegistry fContextTypeRegistry;
    private IPreferenceStore fCombinedPreferenceStore;

    public static JSPlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus iStatus) {
        plugin.getLog().log(iStatus);
    }

    public static void logErrorMessage(String string) {
        JSPlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, string, null));
    }

    public static void log(Throwable throwable) {
        JSPlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, "Internal", throwable));
    }

    public static void log(Throwable throwable, String string) {
        JSPlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, string, throwable));
    }

    public JSPlugin() {
        plugin = this;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.fTemplateStore != null) {
            this.fTemplateStore.stopListeningForPreferenceChanges();
            this.fTemplateStore = null;
        }
        super.stop(bundleContext);
    }

    public synchronized JSTextTools getTextTools() {
        if (this.textTools == null) {
            this.textTools = new JSTextTools(this.getPreferenceStore());
        }
        return this.textTools;
    }

    public ContextTypeRegistry getTemplateContextRegistry() {
        if (this.fContextTypeRegistry == null) {
            this.fContextTypeRegistry = new ContributionContextTypeRegistry();
            this.fContextTypeRegistry.addContextType((TemplateContextType)new JavaScriptContextType());
            this.fContextTypeRegistry.addContextType((TemplateContextType)new JSDocContextType());
        }
        return this.fContextTypeRegistry;
    }

    public TemplateStore getTemplateStore() {
        if (this.fTemplateStore == null) {
            IPreferenceStore iPreferenceStore = this.getPreferenceStore();
            this.fTemplateStore = new ContributionTemplateStore(this.getTemplateContextRegistry(), iPreferenceStore, "com.spket.js.tmpl");
            try {
                this.fTemplateStore.load();
            }
            catch (IOException iOException) {
                JSPlugin.log(iOException);
            }
            this.fTemplateStore.startListeningForPreferenceChanges();
        }
        return this.fTemplateStore;
    }

    public IPreferenceStore getCombinedPreferenceStore() {
        if (this.fCombinedPreferenceStore == null) {
            IPreferenceStore iPreferenceStore = EditorsUI.getPreferenceStore();
            IPreferenceStore iPreferenceStore2 = UIPlugin.getDefault().getPreferenceStore();
            this.fCombinedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), iPreferenceStore2, iPreferenceStore});
        }
        return this.fCombinedPreferenceStore;
    }
}

