/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.internal;

import com.spket.js.internal.JSImages;
import com.spket.js.internal.JSPlugin;
import com.spket.js.model.Flags;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class JSImageDescriptor
extends CompositeImageDescriptor {
    public static final Point DEFAULT_SIZE = new Point(16, 16);
    private int flags;
    private Point size;
    private ImageDescriptor baseImage;

    public JSImageDescriptor(ImageDescriptor imageDescriptor, int n) {
        this(imageDescriptor, n, DEFAULT_SIZE);
    }

    public JSImageDescriptor(ImageDescriptor imageDescriptor, int n, Point point) {
        this.size = point;
        this.flags = n;
        this.baseImage = imageDescriptor;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof JSImageDescriptor) {
            JSImageDescriptor jSImageDescriptor = (JSImageDescriptor)((Object)object);
            return this.flags == jSImageDescriptor.flags && this.size.equals((Object)jSImageDescriptor.size) && this.baseImage.equals(jSImageDescriptor.baseImage);
        }
        return false;
    }

    public int hashCode() {
        return this.baseImage.hashCode() | this.flags | this.size.hashCode();
    }

    protected void drawCompositeImage(int n, int n2) {
        ImageData imageData = this.getImageData(this.baseImage);
        if (Flags.isDeprecated(this.flags)) {
            Point point = this.getSize();
            ImageData imageData2 = this.getImageData(JSImages.DESC_OVR_DEPRECATED);
            this.drawImage(imageData2, 0, point.y - imageData2.height);
        }
        this.drawImage(imageData, 0, 0);
        this.drawTopRight();
        this.drawBottomRight();
        this.drawBottomLeft();
    }

    protected Point getSize() {
        return this.size;
    }

    private ImageData getImageData(ImageDescriptor imageDescriptor) {
        ImageData imageData = imageDescriptor.getImageData();
        if (imageData == null) {
            imageData = DEFAULT_IMAGE_DATA;
            JSPlugin.logErrorMessage("Image data not available: " + imageDescriptor.toString());
        }
        return imageData;
    }

    private void drawTopRight() {
        int n = this.getSize().x;
        if ((this.flags & 0x100000) != 0) {
            ImageData imageData = this.getImageData(JSImages.DESC_OVR_PROTO);
            this.drawImage(imageData, n -= imageData.width, 0);
        }
    }

    private void drawBottomRight() {
    }

    private void drawBottomLeft() {
        Point point = this.getSize();
        int n = 0;
        if (Flags.isReadonly(this.flags)) {
            ImageData imageData = this.getImageData(JSImages.DESC_OVR_CONST);
            this.drawImage(imageData, n, point.y - imageData.height);
            n += imageData.width;
        }
    }
}

