/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xml.text;

import com.spket.ui.text.ConfigurableScanner;
import com.spket.ui.text.IColorManager;
import com.spket.ui.text.IConfigurable;
import com.spket.ui.text.IReconcilingParticipant;
import com.spket.ui.text.ReconcilingStrategy;
import com.spket.ui.text.SingleTokenScanner;
import com.spket.ui.text.html.HTMLTextPresenter;
import com.spket.xml.XMLModel;
import com.spket.xml.editors.XMLEditor;
import com.spket.xml.internal.text.XMLAutoIndentStrategy;
import com.spket.xml.internal.text.XMLCommentScanner;
import com.spket.xml.internal.text.XMLCompletionProcessor;
import com.spket.xml.internal.text.XMLFormattingStrategy;
import com.spket.xml.internal.text.XMLTextHover;
import com.spket.xml.text.XMLTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class XMLSourceViewerConfiguration
extends TextSourceViewerConfiguration
implements IConfigurable {
    private XMLEditor fEditor;
    private IColorManager fColorManager;
    private String fDocumentPartitioning;
    protected ConfigurableScanner[] fScanners;
    protected ContentAssistant fContentAssistant;

    public XMLSourceViewerConfiguration(XMLEditor xMLEditor, IColorManager iColorManager, IPreferenceStore iPreferenceStore, String string) {
        super(iPreferenceStore);
        this.fEditor = xMLEditor;
        this.fColorManager = iColorManager;
        this.fDocumentPartitioning = string;
        this.initializeScanners();
    }

    public String[] getConfiguredContentTypes(ISourceViewer iSourceViewer) {
        return XMLTextTools.CONTENT_TYPES;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer iSourceViewer) {
        if (this.fDocumentPartitioning != null) {
            return this.fDocumentPartitioning;
        }
        return super.getConfiguredDocumentPartitioning(iSourceViewer);
    }

    public boolean affectsTextPresentation(PropertyChangeEvent propertyChangeEvent) {
        for (int i = 0; i < this.fScanners.length; ++i) {
            if (this.fScanners[i] == null || !this.fScanners[i].affectsTextPresentation(propertyChangeEvent)) continue;
            return true;
        }
        return false;
    }

    public void changeConfiguration(PropertyChangeEvent propertyChangeEvent) {
        if (this.fContentAssistant != null) {
            String string = propertyChangeEvent.getProperty();
            if ("xmlPropose".equals(string)) {
                this.fContentAssistant.enableAutoActivation(this.fPreferenceStore.getBoolean(string));
                return;
            }
            if ("xmlDelay".equals(string)) {
                this.fContentAssistant.setAutoActivationDelay(this.fPreferenceStore.getInt(string));
                return;
            }
            if ("xml_propose_char".equals(string)) {
                this.changedActivationCharacters(string, "__dftl_partition_content_type");
                return;
            }
            if ("tag_propose_char".equals(string)) {
                this.changedActivationCharacters(string, "__xml_tag");
                return;
            }
        }
        for (int i = 0; i < this.fScanners.length; ++i) {
            if (this.fScanners[i] == null) continue;
            this.fScanners[i].changeConfiguration(propertyChangeEvent);
        }
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer iSourceViewer, String string) {
        if (this.fEditor != null) {
            return new IAutoEditStrategy[]{new XMLAutoIndentStrategy(this.fEditor, this.getConfiguredDocumentPartitioning(iSourceViewer))};
        }
        return super.getAutoEditStrategies(iSourceViewer, string);
    }

    public IContentAssistant getContentAssistant(ISourceViewer iSourceViewer) {
        XMLEditor xMLEditor = this.getEditor();
        if (xMLEditor != null) {
            ContentAssistant contentAssistant = this.fContentAssistant = new ContentAssistant();
            contentAssistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(iSourceViewer));
            XMLModel xMLModel = xMLEditor.getModel();
            XMLCompletionProcessor xMLCompletionProcessor = this.createCompletionProcessor(xMLModel, true);
            String string = this.fPreferenceStore.getString("xml_propose_char");
            if (string != null && string.length() > 0) {
                xMLCompletionProcessor.setActivationCharacters(string.toCharArray());
            }
            contentAssistant.setContentAssistProcessor((IContentAssistProcessor)xMLCompletionProcessor, "__dftl_partition_content_type");
            contentAssistant.setContentAssistProcessor((IContentAssistProcessor)xMLCompletionProcessor, "__xml_attr_value");
            xMLCompletionProcessor = this.createCompletionProcessor(xMLModel, false);
            string = this.fPreferenceStore.getString("tag_propose_char");
            if (string != null && string.length() > 0) {
                xMLCompletionProcessor.setActivationCharacters(string.toCharArray());
            }
            contentAssistant.setContentAssistProcessor((IContentAssistProcessor)xMLCompletionProcessor, "__xml_tag");
            contentAssistant.setContextInformationPopupOrientation(20);
            contentAssistant.setInformationControlCreator(this.getInformationControlCreator(iSourceViewer));
            contentAssistant.setAutoActivationDelay(this.fPreferenceStore.getInt("xmlDelay"));
            contentAssistant.enableAutoActivation(this.fPreferenceStore.getBoolean("xmlPropose"));
            return contentAssistant;
        }
        return null;
    }

    protected XMLCompletionProcessor createCompletionProcessor(XMLModel xMLModel, boolean bl) {
        return new XMLCompletionProcessor(xMLModel);
    }

    public IContentFormatter getContentFormatter(ISourceViewer iSourceViewer) {
        MultiPassContentFormatter multiPassContentFormatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(iSourceViewer), "__dftl_partition_content_type");
        multiPassContentFormatter.setMasterStrategy((IFormattingStrategy)new XMLFormattingStrategy(this.getEditor()));
        return multiPassContentFormatter;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer iSourceViewer) {
        return null;
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer iSourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new DefaultInformationControl(shell, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        };
    }

    public IReconciler getReconciler(ISourceViewer iSourceViewer) {
        if (this.fEditor != null) {
            ReconcilingStrategy reconcilingStrategy = new ReconcilingStrategy();
            reconcilingStrategy.addParticipant((IReconcilingParticipant)this.fEditor);
            MonoReconciler monoReconciler = new MonoReconciler((IReconcilingStrategy)reconcilingStrategy, false);
            monoReconciler.setDelay(500);
            return monoReconciler;
        }
        return null;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer iSourceViewer) {
        PresentationReconciler presentationReconciler = new PresentationReconciler();
        presentationReconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(iSourceViewer));
        String[] stringArray = this.getConfiguredContentTypes(iSourceViewer);
        for (int i = 0; i < this.fScanners.length; ++i) {
            ConfigurableScanner configurableScanner = this.fScanners[i];
            if (configurableScanner == null) continue;
            DefaultDamagerRepairer defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.fScanners[i]);
            presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, stringArray[i]);
            presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, stringArray[i]);
        }
        return presentationReconciler;
    }

    public ITextHover getTextHover(ISourceViewer iSourceViewer, String string) {
        return this.getTextHover(iSourceViewer, string, 255);
    }

    public ITextHover getTextHover(ISourceViewer iSourceViewer, String string, int n) {
        return new XMLTextHover();
    }

    protected void changedActivationCharacters(String string, String string2) {
        String string3 = this.fPreferenceStore.getString(string);
        IContentAssistProcessor iContentAssistProcessor = this.fContentAssistant.getContentAssistProcessor(string2);
        if (iContentAssistProcessor instanceof XMLCompletionProcessor) {
            if (string3 != null && string3.length() > 0) {
                ((XMLCompletionProcessor)iContentAssistProcessor).setActivationCharacters(string3.toCharArray());
            } else {
                ((XMLCompletionProcessor)iContentAssistProcessor).setActivationCharacters(null);
            }
        }
    }

    protected XMLEditor getEditor() {
        return this.fEditor;
    }

    protected IColorManager getColorManager() {
        return this.fColorManager;
    }

    protected void initializeScanners() {
        IColorManager iColorManager = this.getColorManager();
        this.fScanners = new ConfigurableScanner[XMLTextTools.CONTENT_TYPES.length];
        this.fScanners[0] = new SingleTokenScanner(iColorManager, this.fPreferenceStore, "xml_default");
        this.fScanners[1] = new SingleTokenScanner(iColorManager, this.fPreferenceStore, "xml_proc_instr");
        this.fScanners[2] = new SingleTokenScanner(iColorManager, this.fPreferenceStore, "xml_doctype");
        this.fScanners[3] = new XMLCommentScanner(iColorManager, this.fPreferenceStore, "xml_comments");
        this.fScanners[4] = new SingleTokenScanner(iColorManager, this.fPreferenceStore, "xml_cdata");
        this.fScanners[5] = new SingleTokenScanner(iColorManager, this.fPreferenceStore, "xml_tags");
        this.fScanners[6] = new SingleTokenScanner(iColorManager, this.fPreferenceStore, "xml_attr_value");
    }
}

