/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xml.text;

import com.spket.ui.text.BufferedDocumentScanner;
import com.spket.xml.XMLUtils;
import com.spket.xml.text.XMLPartitions;
import com.spket.xml.text.XMLTextTools;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class XMLPartitionScanner
implements IPartitionTokenScanner,
XMLPartitions {
    private static final String[] TYPES = XMLTextTools.CONTENT_TYPES;
    protected static final IToken[] tokens = new IToken[]{new Token(null), new Token((Object)TYPES[1]), new Token((Object)TYPES[2]), new Token((Object)TYPES[3]), new Token((Object)TYPES[4]), new Token((Object)TYPES[5]), new Token((Object)TYPES[6])};
    private int fLast;
    private int fState;
    private int fTokenOffset;
    private int fTokenLength;
    private int fPrefixLength;
    private int fAttrQuote;
    private String fPartitioning;
    protected char[] fNameBuffer = new char[256];
    protected final BufferedDocumentScanner fScanner = new BufferedDocumentScanner(2048);

    public static int getParentState(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 0;
            }
            case 6: {
                return 5;
            }
        }
        return 0;
    }

    protected static final IToken getToken(int n) {
        return tokens[n & 0xFFFF];
    }

    public static int getState(String string) {
        if (string == null) {
            return 0;
        }
        if ("__xml_tag".equals(string)) {
            return 5;
        }
        if ("__xml_attr_value".equals(string)) {
            return 6;
        }
        if ("__xml_cdata".equals(string)) {
            return 4;
        }
        if ("__xml_comment".equals(string)) {
            return 3;
        }
        if ("__xml_pi".equals(string)) {
            return 1;
        }
        if ("__xml_doctype".equals(string)) {
            return 2;
        }
        return 0;
    }

    public XMLPartitionScanner(String string) {
        this.fPartitioning = string == null ? "__dftl_partitioning" : string;
    }

    public int getTokenLength() {
        return this.fTokenLength;
    }

    public int getTokenOffset() {
        return this.fTokenOffset;
    }

    public IToken nextToken() {
        IToken iToken = this.nextToken0();
        while (this.fTokenLength == 0 && iToken != Token.EOF) {
            iToken = this.nextToken0();
        }
        return iToken;
    }

    public void setRange(IDocument iDocument, int n, int n2) {
        this.setPartialRange(iDocument, n, n2, null, -1);
    }

    public void setPartialRange(IDocument iDocument, int n, int n2, String string, int n3) {
        this.fAttrQuote = 0;
        this.fTokenLength = 0;
        this.fLast = -1;
        this.fTokenOffset = n3;
        this.fPrefixLength = n - n3;
        this.fScanner.setRange(iDocument, n, n2);
        if (n > 0 && n == n3 && string == "__dftl_partition_content_type") {
            ITypedRegion iTypedRegion = null;
            try {
                iTypedRegion = this.getPartition(iDocument, n);
            }
            catch (BadLocationException badLocationException) {
                iTypedRegion = null;
            }
            this.fState = iTypedRegion == null ? XMLPartitionScanner.getState(string) : XMLPartitionScanner.getState(iTypedRegion.getType());
        } else {
            this.fState = XMLPartitionScanner.getState(string);
        }
        if (2 == this.fState) {
            this.fPrefixLength = 0;
            n = n3;
            if (n < 0) {
                n = 0;
            }
            this.fScanner.setRange(iDocument, n, n2);
            this.fState = this.getParentState();
        }
    }

    protected ITypedRegion getPartition(IDocument iDocument, int n) throws BadLocationException {
        if (iDocument instanceof IDocumentExtension3) {
            try {
                return ((IDocumentExtension3)iDocument).getPartition(this.fPartitioning, n, false);
            }
            catch (BadPartitioningException badPartitioningException) {
                return null;
            }
        }
        return iDocument.getPartition(n);
    }

    protected final int getParentState() {
        return XMLPartitionScanner.getParentState(this.fState);
    }

    protected final IToken preFix(int n, int n2, int n3, int n4) {
        this.fPrefixLength = n4;
        this.fLast = n3;
        this.fState = n2;
        return XMLPartitionScanner.getToken(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected IToken nextToken0() {
        this.fTokenOffset += this.fTokenLength;
        this.fTokenLength = this.fPrefixLength;
        while (true) {
            int n;
            if ((n = this.fScanner.read()) != -1) {
                ++this.fTokenLength;
            }
            block0 : switch (n) {
                case -1: {
                    if (this.fTokenLength > 0) {
                        return this.preFix(this.fState, this.getParentState(), n, 0);
                    }
                    this.fPrefixLength = 0;
                    return Token.EOF;
                }
                case 60: {
                    switch (this.fState) {
                        case 0: {
                            this.fTokenOffset += this.fTokenLength - 1;
                            this.fTokenLength = 1;
                            if (this.fScanner.skipChar('!')) {
                                ++this.fTokenLength;
                                if (this.fScanner.skipChar('-')) {
                                    ++this.fTokenLength;
                                    if (!this.fScanner.skipChar('-')) break block0;
                                    ++this.fTokenLength;
                                    this.fState = 3;
                                    break block0;
                                }
                                if (this.fScanner.skipString("[CDATA[")) {
                                    this.fState = 4;
                                    this.fTokenLength = 9;
                                    break block0;
                                }
                                if (!this.fScanner.skipString("DOCTYPE")) break block0;
                                this.fTokenLength = 9;
                                this.scanDoctypeDecl();
                                return this.preFix(2, 0, n, 0);
                            }
                            if (this.fScanner.skipChar('?')) {
                                this.fTokenLength = 2;
                                this.fState = 1;
                                break block0;
                            }
                            if (!XMLUtils.isValidNameStartChar(this.fScanner.peekChar())) break block0;
                            this.fState = 5;
                            break block0;
                        }
                        case 1: 
                        case 3: 
                        case 4: {
                            break block0;
                        }
                        default: {
                            int n2 = this.getParentState();
                            if (n2 == 4) break block0;
                            --this.fTokenLength;
                            this.fScanner.unread();
                            return this.preFix(this.fState, 0, this.fLast, 0);
                        }
                    }
                }
                case 62: {
                    switch (this.fState) {
                        case 5: {
                            return this.preFix(this.fState, 0, n, 0);
                        }
                        case 4: {
                            int n3 = this.fTokenOffset + this.fTokenLength - 2;
                            if (this.fLast == 93 && this.fScanner.getChar(n3 - 1) == 93) {
                                return this.preFix(this.fState, this.getParentState(), n, 0);
                            }
                            break block0;
                        }
                        case 3: {
                            int n3 = this.fTokenOffset + this.fTokenLength - 2;
                            if (this.fLast == 45 && this.fScanner.getChar(n3 - 1) == 45) {
                                return this.preFix(this.fState, this.getParentState(), n, 0);
                            }
                            break block0;
                        }
                        case 1: {
                            if (this.fLast == 63) {
                                return this.preFix(this.fState, this.getParentState(), n, 0);
                            }
                            break block0;
                        }
                    }
                    break;
                }
                case 34: 
                case 39: {
                    switch (this.fState) {
                        case 5: {
                            this.fAttrQuote = n;
                            --this.fTokenLength;
                            return this.preFix(this.fState, 6, n, 1);
                        }
                        case 6: {
                            if (n == this.fAttrQuote) {
                                return this.preFix(this.fState, 5, n, 0);
                            }
                            break block0;
                        }
                    }
                    break;
                }
                case 47: {
                    switch (this.fState) {
                        case 0: {
                            if (this.fLast != 60 || !XMLUtils.isValidNameStartChar(this.fScanner.peekChar())) break;
                            this.fTokenOffset += this.fTokenLength - 2;
                            this.fTokenLength = 2;
                            this.fState = 5;
                        }
                    }
                    break;
                }
            }
            this.fLast = n;
        }
    }

    protected boolean skipSpaces() {
        int n = this.fScanner.read();
        if (XMLUtils.isSpace(n)) {
            while ((n = this.fScanner.read()) != -1) {
                if (XMLUtils.isSpace(n)) continue;
                this.fScanner.unread();
                break;
            }
            return true;
        }
        if (n != -1) {
            this.fScanner.unread();
        }
        return false;
    }

    protected String scanName() {
        int n = 0;
        int n2 = this.fScanner.peekChar();
        if (XMLUtils.isValidNameStartChar(n2)) {
            this.fScanner.scanChar();
            this.fNameBuffer[n++] = (char)n2;
            while (XMLUtils.isValidNameChar(n2 = this.fScanner.peekChar())) {
                this.fScanner.scanChar();
                if (n == this.fNameBuffer.length) {
                    char[] cArray = new char[n << 1];
                    System.arraycopy(this.fNameBuffer, 0, cArray, 0, n);
                    this.fNameBuffer = cArray;
                }
                this.fNameBuffer[n++] = (char)n2;
            }
        }
        if (n > 0) {
            return new String(this.fNameBuffer, 0, n);
        }
        return null;
    }

    protected void scanDecl(boolean bl) {
        int n = -1;
        while (true) {
            int n2 = this.fScanner.read();
            switch (n2) {
                case -1: {
                    return;
                }
                case 62: {
                    if (n != -1) break;
                    return;
                }
                case 34: 
                case 39: {
                    if (n == n2) {
                        n = -1;
                        break;
                    }
                    if (n != -1) break;
                    n = n2;
                    break;
                }
                case 60: {
                    if (bl) {
                        if (n != -1) break;
                        this.fScanner.unread();
                        return;
                    }
                    this.fScanner.unread();
                    return;
                }
            }
        }
    }

    protected void scanComment() {
        int n;
        int n2 = -1;
        int n3 = -1;
        while ((n = this.fScanner.read()) != 62 || n2 != 45 || n3 != 45) {
            n3 = n2;
            n2 = n;
            if (n != -1) continue;
        }
    }

    protected void scanPI() {
        int n;
        int n2 = -1;
        while ((n = this.fScanner.read()) != 62 || n2 != 63) {
            n2 = n;
            if (n != -1) continue;
        }
    }

    protected String scanLiteral() {
        int n = this.fScanner.peekChar();
        if (n == 39 || n == 34) {
            int n2;
            this.fScanner.scanChar();
            StringBuffer stringBuffer = new StringBuffer();
            while ((n2 = this.fScanner.scanChar()) != n) {
                if (n2 == 60) {
                    this.fScanner.unread();
                    break;
                }
                if (n2 == -1) break;
                stringBuffer.append((char)n2);
            }
            if (stringBuffer.length() > 0) {
                return stringBuffer.toString();
            }
        }
        return null;
    }

    protected void scanExternalID(String string) {
        if ("PUBLIC".equals(string) || this.fScanner.skipString("PUBLIC")) {
            this.skipSpaces();
            this.scanLiteral();
            this.skipSpaces();
            this.scanLiteral();
        } else if ("SYSTEM".equals(string) || this.fScanner.skipString("SYSTEM")) {
            this.skipSpaces();
            this.scanLiteral();
        }
    }

    protected void scanDTDInternalSubset() {
        while (true) {
            int n = this.fScanner.read();
            switch (n) {
                case -1: {
                    return;
                }
                case 60: {
                    if (this.fScanner.skipChar('!')) {
                        if (this.fScanner.skipString("--")) {
                            this.scanComment();
                        }
                        this.scanDecl(true);
                        break;
                    }
                    if (!this.fScanner.skipChar('?')) break;
                    this.scanPI();
                    break;
                }
                case 93: {
                    do {
                        if ((n = this.fScanner.read()) == 62) {
                            return;
                        }
                        if (n != 60) continue;
                        this.fScanner.unread();
                        return;
                    } while (n != -1);
                }
            }
        }
    }

    protected void scanDoctypeDecl() {
        int n = this.fTokenLength;
        int n2 = this.fScanner.getOffset();
        this.skipSpaces();
        String string = this.scanName();
        if (this.skipSpaces()) {
            this.scanExternalID(string);
            this.skipSpaces();
        }
        if (this.fScanner.skipChar('[')) {
            this.scanDTDInternalSubset();
        } else {
            this.scanDecl(false);
        }
        this.fTokenLength = n + this.fScanner.getOffset() - n2;
    }

    protected boolean isScriptTag(int n) {
        return false;
    }
}

