/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xml.internal.text;

import com.spket.ui.internal.UIPlugin;
import com.spket.util.StringUtils;
import com.spket.xml.XMLDocument;
import com.spket.xml.XMLModel;
import com.spket.xml.editors.XMLEditor;
import com.spket.xml.internal.XMLPlugin;
import com.spket.xml.internal.text.XMLFormatter;
import java.util.LinkedList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.ui.editors.text.EditorsUI;

public class XMLFormattingStrategy
extends ContextBasedFormattingStrategy {
    private XMLEditor fEditor;
    private final LinkedList fDocuments = new LinkedList();
    private final LinkedList fPartitions = new LinkedList();

    public XMLFormattingStrategy(XMLEditor xMLEditor) {
        this.fEditor = xMLEditor;
    }

    public void format() {
        super.format();
        IDocument iDocument = (IDocument)this.fDocuments.removeFirst();
        TypedPosition typedPosition = (TypedPosition)this.fPartitions.removeFirst();
        if (this.fEditor == null) {
            return;
        }
        XMLModel xMLModel = this.fEditor.getModel();
        if (xMLModel == null) {
            return;
        }
        XMLDocument xMLDocument = xMLModel.getXMLDocument();
        if (xMLDocument == null) {
            return;
        }
        if (iDocument != null) {
            XMLFormatter xMLFormatter = new XMLFormatter();
            xMLFormatter.setUsingTab(!this.isTabConversionEnabled());
            xMLFormatter.setTabSize(this.getTabSize());
            xMLFormatter.setDocument(iDocument);
            try {
                xMLFormatter.format(xMLDocument, typedPosition.getOffset(), typedPosition.getLength());
            }
            catch (BadLocationException badLocationException) {
                XMLPlugin.log(badLocationException);
            }
        }
    }

    public void formatterStarts(IFormattingContext iFormattingContext) {
        super.formatterStarts(iFormattingContext);
        this.fDocuments.addLast(iFormattingContext.getProperty((Object)"formatting.context.medium"));
        this.fPartitions.addLast(iFormattingContext.getProperty((Object)"formatting.context.partition"));
    }

    public void formatterStops() {
        super.formatterStops();
        this.fDocuments.clear();
        this.fPartitions.clear();
    }

    protected boolean isTabConversionEnabled() {
        return UIPlugin.getDefault().getPreferenceStore().getBoolean("tab.char");
    }

    protected int getTabSize() {
        int n = -1;
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        boolean bl = iPreferenceStore.getBoolean("tab.default");
        if (!bl) {
            n = StringUtils.toInt((String)iPreferenceStore.getString("tab.size"), (int)-1);
        }
        if (n < 0) {
            iPreferenceStore = EditorsUI.getPreferenceStore();
            n = iPreferenceStore.getInt("tabWidth");
        }
        return n;
    }
}

