/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xml.internal.text;

import com.spket.util.IntStack;
import com.spket.xml.INodeRegion;
import com.spket.xml.PositionInfo;
import com.spket.xml.XMLDocument;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLNode;
import com.spket.xml.XMLUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;

public class XMLFormatter {
    private static final char[] UNIX = new char[]{'\n'};
    private int fStop;
    private int fLineStart;
    private int fLineEnd;
    private int fCurrentLine;
    private int fTabSize;
    private boolean fUsingTab;
    private int fCount;
    private char[] fLineDelimiter = UNIX;
    private char[] fIndent = new char[80];
    private IDocument fDocument;
    private List fEdits = new ArrayList();

    public IDocument getDocument() {
        return this.fDocument;
    }

    public void setDocument(IDocument iDocument) {
        this.fDocument = iDocument;
    }

    public boolean isUsingTab() {
        return this.fUsingTab;
    }

    public void setUsingTab(boolean bl) {
        this.fUsingTab = bl;
    }

    public int getTabSize() {
        return this.fTabSize;
    }

    public void setTabSize(int n) {
        this.fTabSize = n;
    }

    public void format(XMLDocument xMLDocument, int n, int n2) throws BadLocationException {
        int n3 = 0;
        int n4 = 0;
        XMLNode xMLNode = xMLDocument;
        IntStack intStack = new IntStack();
        if (n2 == 0 || n2 == this.fDocument.getLength()) {
            n4 = -1;
            this.fStop = this.fDocument.getLength();
        } else {
            this.fStop = n + n2;
            PositionInfo positionInfo = new PositionInfo();
            XMLUtils.findNode(xMLDocument, n, positionInfo);
            int n5 = positionInfo.getLevel();
            switch (positionInfo.nodeType) {
                case 101: {
                    xMLNode = positionInfo.node;
                    n3 = xMLNode.getChildrenCount();
                    break;
                }
                case 3: {
                    n3 = positionInfo.index;
                    xMLNode = positionInfo.node;
                    break;
                }
                case 100: {
                    --n5;
                }
                default: {
                    n3 = positionInfo.index;
                    xMLNode = positionInfo.node.getParent();
                }
            }
            n4 = n5 - 1;
            if (n5 > 0) {
                int[] nArray = positionInfo.getIndices();
                for (int i = 0; i < n5; ++i) {
                    intStack.push(nArray[i] + 1);
                }
            }
        }
        block6: while (xMLNode != null) {
            XMLElement xMLElement;
            int n6 = xMLNode.getChildrenCount();
            if (n6 > 0) {
                ++n4;
                XMLNode[] xMLNodeArray = xMLNode.getChildren();
                for (int i = n3; i < n6; ++i) {
                    XMLElement xMLElement2;
                    XMLNode xMLNode2 = xMLNodeArray[i];
                    if (1 == xMLNode2.getNodeType()) {
                        xMLElement2 = (XMLElement)xMLNode2;
                        if (this.startTag(xMLElement2, n4)) {
                            break;
                        }
                    } else if (this.indent(xMLNode2, 4 == xMLNode2.getNodeType() ? n4 - 1 : n4)) break block6;
                    if (xMLNode2.getChildrenCount() > 0) {
                        intStack.push(i + 1);
                        xMLNode = xMLNode2;
                        n3 = 0;
                        continue block6;
                    }
                    if (1 == xMLNode2.getNodeType() && !(xMLElement2 = (XMLElement)xMLNode2).isEmptyTag() && this.endTag(xMLElement2, n4)) break;
                }
                --n4;
            }
            if (1 == xMLNode.getNodeType() && !(xMLElement = (XMLElement)xMLNode).isEmptyTag() && this.endTag(xMLElement, n4) || intStack.size() == 0) break;
            --n4;
            xMLNode = xMLNode.getParent();
            n3 = intStack.pop();
            if (xMLNode != null) continue;
        }
        this.apply(this.fDocument);
    }

    public void setLineDelimiter(char[] cArray) {
        if (cArray == null) {
            this.fLineDelimiter = UNIX;
        }
        this.fLineDelimiter = cArray;
    }

    protected boolean indent(XMLNode xMLNode, int n) throws BadLocationException {
        INodeRegion iNodeRegion = xMLNode.getRegion();
        if (iNodeRegion != null) {
            int n2 = iNodeRegion.getStart();
            if (n2 >= this.fStop) {
                return true;
            }
            if (n2 >= this.fLineEnd) {
                this.reset(n2);
                this.indent(n);
            }
            n2 = iNodeRegion.getEnd();
            if (n2 > this.fLineEnd) {
                int n3 = this.getCurrentLine();
                this.reset(n2);
                this.indent(n3 + 1, n + 1, n2, xMLNode.getNodeType());
            }
        }
        return false;
    }

    protected boolean startTag(XMLElement xMLElement, int n) throws BadLocationException {
        INodeRegion iNodeRegion = xMLElement.getStartTagRegion();
        if (iNodeRegion != null) {
            int n2 = iNodeRegion.getStart();
            if (n2 >= this.fStop) {
                return true;
            }
            if (n2 < this.fLineEnd) {
                this.newLine(n, n2);
            } else {
                this.reset(n2);
                this.indent(n);
            }
            n2 = iNodeRegion.getEnd();
            if (n2 > this.fLineEnd) {
                int n3 = this.getCurrentLine();
                this.reset(n2);
                this.indent(n3 + 1, n + 1, n2, (short)100);
            }
            if (xMLElement.isEmptyTag()) {
                // empty if block
            }
        }
        return false;
    }

    protected boolean endTag(XMLElement xMLElement, int n) throws BadLocationException {
        INodeRegion iNodeRegion = xMLElement.getEndTagRegion();
        if (iNodeRegion != null) {
            int n2 = iNodeRegion.getStart();
            if (n2 >= this.fStop) {
                return true;
            }
            if (n2 < this.fLineEnd) {
                short s = 0;
                int n3 = xMLElement.getChildrenCount();
                if (n3 > 0) {
                    s = xMLElement.getChildren()[n3 - 1].getNodeType();
                }
                if (1 == s) {
                    this.newLine(n, n2);
                }
            } else {
                this.reset(n2);
                if (this.findEndOfWhiteSpace(this.fLineStart, n2) == n2) {
                    this.indent(n);
                }
            }
        }
        return false;
    }

    protected int findEndOfWhiteSpace(int n, int n2) throws BadLocationException {
        block3: while (n < n2) {
            switch (this.fDocument.getChar(n)) {
                case '\t': 
                case ' ': {
                    ++n;
                    continue block3;
                }
            }
            return n;
        }
        return n2;
    }

    protected void reset(int n) throws BadLocationException {
        this.fCurrentLine = -1;
        IRegion iRegion = this.fDocument.getLineInformationOfOffset(n);
        this.fLineStart = iRegion.getOffset();
        this.fLineEnd = this.fLineStart + iRegion.getLength();
    }

    protected int getCurrentLine() throws BadLocationException {
        if (this.fCurrentLine == -1) {
            this.fCurrentLine = this.fDocument.getLineOfOffset(this.fLineStart);
        }
        return this.fCurrentLine;
    }

    protected void indent(int n, int n2, int n3, short s) throws BadLocationException {
        int n4 = this.getCurrentLine();
        if (100 == s) {
            int n5;
            IRegion iRegion;
            for (int i = n; i < n4; ++i) {
                iRegion = this.fDocument.getLineInformation(i);
                n5 = iRegion.getOffset();
                this.indent(n2, n5, n5 + iRegion.getLength());
            }
            iRegion = this.fDocument.getLineInformation(n4);
            n5 = this.findEndOfWhiteSpace(iRegion.getOffset(), n3);
            if (n5 == n3) {
                this.indent(n2 - 1);
            } else {
                n5 = iRegion.getOffset();
                this.indent(n2, n5, n5 + iRegion.getLength());
            }
        } else {
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12 = 0;
            int[] nArray = new int[(n4 - n + 1) * 4];
            for (n11 = n; n11 <= n4; ++n11) {
                IRegion iRegion = this.fDocument.getLineInformation(n11);
                n10 = iRegion.getOffset();
                n9 = n10 + iRegion.getLength();
                n8 = 0;
                if (this.fTabSize > 0) {
                    n7 = 0;
                    for (n6 = n10; n6 < n9; ++n6) {
                        n7 = this.fDocument.getChar(n6);
                        if (n7 == 9) {
                            n8 += this.fTabSize;
                            continue;
                        }
                        if (n7 != 32) break;
                        ++n8;
                    }
                    nArray[n12 + 3] = n8 == 0 || n7 == 32 || n7 == 9 ? 0 : 1;
                }
                nArray[n12++] = n8;
                nArray[n12++] = n10;
                nArray[n12++] = n9;
                ++n12;
            }
            n11 = -1;
            n8 = n4 - n + 1;
            if (4 == s) {
                n12 = this.findEndOfWhiteSpace(nArray[nArray.length - 3], n3);
                if (n12 < n3 - 3) {
                    n11 = n3 - 3;
                } else {
                    --n8;
                }
            }
            if (this.fTabSize > 0) {
                n10 = -1;
                for (n9 = 0; n9 < n8; ++n9) {
                    n12 = n9 * 4;
                    if (nArray[n12 + 3] <= 0) continue;
                    n12 = nArray[n12];
                    if (n10 != -1 && n10 <= n12) continue;
                    n10 = n12;
                }
                if (n10 != -1) {
                    n10 = n2 - n10 / this.fTabSize;
                    for (n9 = 0; n9 < n8; ++n9) {
                        this.fCount = 0;
                        n12 = n9 * 4;
                        if (nArray[n12 + 3] > 0) {
                            n7 = nArray[n12];
                            this.fillIndent(n7 / this.fTabSize + n10);
                            this.ensureCapacity(this.fCount + (n7 %= this.fTabSize));
                            for (n6 = 0; n6 < n7; ++n6) {
                                this.fIndent[this.fCount++] = 32;
                            }
                        }
                        this.createEdit(nArray[n12 + 1], nArray[n12 + 2]);
                    }
                }
            } else {
                for (n10 = 0; n10 < n8; ++n10) {
                    n12 = n10 * 4;
                    this.indent(n2, nArray[n12 + 1], nArray[n12 + 2]);
                }
            }
            if (4 == s) {
                if (n11 > 0) {
                    this.newLine(n2 - 1, n11);
                } else {
                    this.indent(n2 - 1, nArray[nArray.length - 3], nArray[nArray.length - 2]);
                }
            }
        }
    }

    protected void ensureCapacity(int n) {
        if (this.fIndent.length < n) {
            if (this.fCount > 0) {
                char[] cArray = new char[n];
                System.arraycopy(this.fIndent, 0, cArray, 0, this.fCount);
                this.fIndent = cArray;
            } else {
                this.fIndent = new char[n];
            }
        }
    }

    protected void indent(int n) throws BadLocationException {
        this.indent(n, this.fLineStart, this.fLineEnd);
    }

    protected void indent(int n, int n2, int n3) throws BadLocationException {
        this.fCount = 0;
        this.fillIndent(n);
        this.createEdit(n2, n3);
    }

    protected void createEdit(int n, int n2) throws BadLocationException {
        char c;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        for (int i = n; i < n2 && ((c = this.fDocument.getChar(i)) == ' ' || c == '\t'); ++i) {
            if (n3 < this.fCount && !bl) {
                if (c == this.fIndent[n3]) {
                    ++n3;
                } else {
                    bl = true;
                }
            }
            ++n4;
        }
        if (bl || n4 != this.fCount) {
            TextEdit textEdit = new TextEdit();
            textEdit.offset = n3 + n;
            textEdit.length = n4 - n3;
            if (this.fCount > n3) {
                textEdit.text = new String(this.fIndent, n3, this.fCount - n3);
            }
            this.fEdits.add(textEdit);
        }
    }

    protected void newLine(int n, int n2) {
        this.fCount = 0;
        for (int i = 0; i < this.fLineDelimiter.length; ++i) {
            this.fIndent[this.fCount++] = this.fLineDelimiter[i];
        }
        this.fillIndent(n);
        if (this.fCount > 0) {
            TextEdit textEdit = new TextEdit();
            textEdit.offset = n2;
            textEdit.text = new String(this.fIndent, 0, this.fCount);
            this.fEdits.add(textEdit);
        }
    }

    protected void fillIndent(int n) {
        block5: {
            if (n <= 0 || this.fTabSize <= 0) break block5;
            int n2 = this.fCount;
            n2 = this.fUsingTab ? (n2 += n) : (n2 += n * this.fTabSize);
            this.ensureCapacity(n2);
            if (this.fUsingTab) {
                for (int i = 0; i < n; ++i) {
                    this.fIndent[this.fCount++] = 9;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < this.fTabSize; ++j) {
                        this.fIndent[this.fCount++] = 32;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void apply(IDocument iDocument) throws BadLocationException {
        if (this.fEdits.size() == 0) {
            return;
        }
        int n = 0;
        int n2 = 0;
        TextEdit[] textEditArray = new TextEdit[this.fEdits.size()];
        this.fEdits.toArray(textEditArray);
        this.fEdits.clear();
        Map map = null;
        if (textEditArray.length > 20) {
            map = TextUtilities.removeDocumentPartitioners((IDocument)iDocument);
        }
        try {
            for (int i = 0; i < textEditArray.length; ++i) {
                TextEdit textEdit = textEditArray[i];
                n2 = textEdit.offset + n;
                iDocument.replace(n2, textEdit.length, textEdit.text);
                n -= textEdit.length;
                if (textEdit.text == null) continue;
                n += textEdit.text.length();
            }
        }
        finally {
            if (map != null) {
                TextUtilities.addDocumentPartitioners((IDocument)iDocument, (Map)map);
            }
        }
    }

    private static class TextEdit {
        public int offset;
        public int length;
        public String text;

        private TextEdit() {
        }
    }
}

