/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xml;

import com.spket.buffer.IBuffer;
import com.spket.xml.INodeRegion;
import com.spket.xml.NamespaceContextImpl;
import com.spket.xml.PositionInfo;
import com.spket.xml.XMLAttr;
import com.spket.xml.XMLConstants;
import com.spket.xml.XMLDocument;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLModel;
import com.spket.xml.XMLNode;
import java.util.StringTokenizer;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.NamespaceContext;
import org.eclipse.core.runtime.IPath;

public class XMLUtils {
    public static boolean isSpace(int n) {
        return n != -1 && XMLChar.isSpace((int)n);
    }

    public static boolean isValidNameChar(int n) {
        return n != -1 && XMLChar.isName((int)n);
    }

    public static boolean isValidNameStartChar(int n) {
        return n != -1 && XMLChar.isNameStart((int)n);
    }

    public static IPath getPath(XMLNode xMLNode) {
        IBuffer iBuffer = XMLUtils.getBuffer(xMLNode);
        return iBuffer == null ? null : iBuffer.getPath();
    }

    public static IBuffer getBuffer(XMLNode xMLNode) {
        if (xMLNode == null) {
            return null;
        }
        XMLDocument xMLDocument = xMLNode.getDocument();
        return xMLDocument == null ? null : xMLDocument.getBuffer();
    }

    public static NamespaceContext getNamespaceContext(XMLNode xMLNode, SymbolTable symbolTable, NamespaceContext namespaceContext) {
        String string;
        if (namespaceContext == null) {
            namespaceContext = new NamespaceContextImpl();
        }
        namespaceContext.reset();
        if (xMLNode == null) {
            return namespaceContext;
        }
        int n = 0;
        String string2 = null;
        String[] stringArray = new String[8];
        if (xMLNode.getNodeType() != 1) {
            xMLNode = xMLNode.getParent();
        }
        while (xMLNode != null && xMLNode.getNodeType() == 1) {
            XMLElement xMLElement = (XMLElement)xMLNode;
            XMLAttr[] xMLAttrArray = xMLElement.getAttrs();
            for (int i = 0; i < xMLElement.getAttrCount(); ++i) {
                string = null;
                String string3 = xMLAttrArray[i].getName();
                if (string3 == null) continue;
                if (string3.length() == 5 && XMLConstants.PREFIX_XMLNS.equals(string3)) {
                    string = XMLConstants.EMPTY_STRING;
                } else if (string3.length() > 6 && string3.charAt(5) == ':' && string3.startsWith(XMLConstants.PREFIX_XMLNS)) {
                    string = string3.substring(6);
                }
                if (string == null || (string2 = XMLUtils.getValue(xMLAttrArray[i])) == null) continue;
                if (n >= stringArray.length) {
                    String[] stringArray2 = new String[n * 2];
                    System.arraycopy(stringArray, 0, stringArray2, 0, n);
                    stringArray = stringArray2;
                }
                stringArray[n++] = symbolTable != null ? symbolTable.addSymbol(string) : string;
                stringArray[n++] = symbolTable != null ? symbolTable.addSymbol(string2) : string2;
            }
            xMLNode = xMLNode.getParent();
        }
        while (n > 0) {
            string2 = stringArray[--n];
            string = stringArray[--n];
            namespaceContext.declarePrefix(string, string2);
        }
        return namespaceContext;
    }

    public static XMLElement getElement(XMLElement xMLElement, String string) {
        int n = xMLElement.getChildrenCount();
        if (n > 0) {
            XMLNode[] xMLNodeArray = xMLElement.getChildren();
            for (int i = 0; i < n; ++i) {
                XMLNode xMLNode = xMLNodeArray[i];
                if (xMLNode.getNodeType() != 1 || !string.equals(xMLNode.getLocalName())) continue;
                return (XMLElement)xMLNode;
            }
        }
        return null;
    }

    public static String getValue(XMLAttr xMLAttr) {
        XMLElement xMLElement;
        IBuffer iBuffer;
        INodeRegion iNodeRegion = xMLAttr.getValueRegion();
        if (iNodeRegion != null && iNodeRegion.getLength() > 1 && (iBuffer = XMLUtils.getBuffer(xMLElement = (XMLElement)xMLAttr.getParent())) != null) {
            int n = iNodeRegion.getLength() - 1;
            int n2 = xMLElement.getStartTagRegion().getStart() + iNodeRegion.getStart();
            if (iBuffer.get(n2) == iBuffer.get(n2 + n)) {
                --n;
            }
            ++n2;
            if (n > 0) {
                return iBuffer.get(n2, n);
            }
        }
        return null;
    }

    public static String getAttrValue(XMLElement xMLElement, String string) {
        XMLAttr xMLAttr = xMLElement.getAttr(string);
        return xMLAttr == null ? null : XMLUtils.getValue(xMLAttr);
    }

    public static XMLNode findNode(XMLModel xMLModel, int n, PositionInfo positionInfo) {
        return XMLUtils.findNode(xMLModel.getXMLDocument(), n, positionInfo);
    }

    public static XMLNode findNode(XMLDocument xMLDocument, int n, PositionInfo positionInfo) {
        boolean bl = false;
        XMLNode xMLNode = xMLDocument;
        PositionInfo positionInfo2 = positionInfo;
        if (positionInfo2 == null) {
            positionInfo2 = new PositionInfo();
        }
        block0: while (xMLNode != null && (bl || xMLNode.contains(n) == 0)) {
            XMLElement xMLElement;
            bl = false;
            positionInfo2.node = xMLNode;
            positionInfo2.nodeType = xMLNode.getNodeType();
            if (xMLNode.getNodeType() == 1) {
                XMLElement xMLElement2 = (XMLElement)xMLNode;
                INodeRegion iNodeRegion = xMLElement2.getStartTagRegion();
                if (iNodeRegion != null && iNodeRegion.contains(n) == 0) {
                    positionInfo2.nodeType = 100;
                    break;
                }
                iNodeRegion = xMLElement2.getEndTagRegion();
                if (iNodeRegion != null && iNodeRegion.contains(n) == 0) {
                    positionInfo2.nodeType = 101;
                    break;
                }
            }
            positionInfo2.index = 0;
            positionInfo2.nodeType = 3;
            int n2 = xMLNode.getChildrenCount();
            int n3 = n2 - 1;
            if (n3 < 0) break;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            XMLNode[] xMLNodeArray = xMLNode.getChildren();
            while (n6 <= n3) {
                positionInfo2.index = n5 = n6 + n3 >> 1;
                n4 = xMLNodeArray[n5].contains(n);
                if (n4 == 0) {
                    xMLNode = xMLNodeArray[n5];
                    if (xMLNode.getNodeType() == 1) {
                        bl = true;
                        positionInfo2.enter(n5);
                        break;
                    }
                    positionInfo2.node = xMLNode;
                    positionInfo2.nodeType = xMLNode.getNodeType();
                    break block0;
                }
                if (n4 < 0) {
                    n3 = n5 - 1;
                    continue;
                }
                positionInfo2.index = n6 = n5 + 1;
            }
            if (bl) continue;
            n5 = -1;
            if (n4 < 0 && n3 >= 0 && n3 < n2) {
                if (xMLNodeArray[n3].getNodeType() == 1) {
                    n5 = n3;
                }
            } else if (n4 > 0 && n2 > 0 && xMLNodeArray[n2 - 1].getNodeType() == 1) {
                n5 = n2 - 1;
            }
            if (n5 != -1 && !(xMLElement = (XMLElement)xMLNodeArray[n5]).isEmptyTag() && xMLElement.getEndTagRegion() == null && xMLElement.getStartTagRegion().getStart() <= n) {
                xMLNode = xMLElement;
                bl = true;
                positionInfo2.enter(n5);
            }
            if (bl) continue;
            break;
        }
        return positionInfo2.node;
    }

    public static String getSchemaLocation(XMLNode xMLNode, String string) {
        String string2;
        if (xMLNode != null) {
            if (xMLNode.getNodeType() == 0) {
                xMLNode = ((XMLDocument)xMLNode).getDocumentElement();
            } else if (xMLNode.getNodeType() != 1) {
                xMLNode = xMLNode.getParent();
            }
        }
        String string3 = string2 = string == null ? XMLConstants.XSI_NONAMESPACESCHEMALOCATION : XMLConstants.XSI_SCHEMALOCATION;
        while (xMLNode != null && xMLNode.getNodeType() == 1) {
            XMLElement xMLElement = (XMLElement)xMLNode;
            XMLAttr[] xMLAttrArray = xMLElement.getAttrs();
            for (int i = 0; i < xMLElement.getAttrCount(); ++i) {
                String string4 = xMLAttrArray[i].getName();
                if (string4 == null || string4.length() <= 5 || string4.charAt(3) != ':' || !string4.startsWith("xsi") || !(string4 = string4.substring(4)).equals(string2)) continue;
                if (string == null) {
                    return xMLAttrArray[i].getValue();
                }
                String string5 = xMLAttrArray[i].getValue();
                if (string5 == null) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string5, " \n\t\r");
                while (stringTokenizer.hasMoreTokens()) {
                    String string6 = stringTokenizer.nextToken();
                    if (!stringTokenizer.hasMoreTokens()) {
                        return null;
                    }
                    if (string.equals(string6)) {
                        return stringTokenizer.nextToken();
                    }
                    stringTokenizer.nextToken();
                }
            }
            xMLNode = xMLNode.getParent();
        }
        return null;
    }
}

