/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xml;

import com.spket.xml.INodeRegion;
import com.spket.xml.XMLDocument;

public abstract class XMLNode {
    public static final short UNKNOWN_NODE = -1;
    public static final short DOCUMENT_NODE = 0;
    public static final short ELEMENT_NODE = 1;
    public static final short ATTRIBUTE_NODE = 2;
    public static final short TEXT_NODE = 3;
    public static final short CDATA_NODE = 4;
    public static final short COMMENT_NODE = 5;
    public static final short DOCUMENT_TYPE_NODE = 6;
    public static final short PROCESSING_INSTRUCTION_NODE = 7;
    public static final short IN_START_TAG = 100;
    public static final short IN_END_TAG = 101;
    protected static final XMLNode[] EMPTY_NODES = new XMLNode[0];
    protected XMLNode fParent;
    protected INodeRegion fRegion;

    public void dispose() {
        this.fParent = null;
        this.fRegion = null;
    }

    public abstract String getName();

    public String getLocalName() {
        return null;
    }

    public String getNamespace() {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public abstract short getNodeType();

    public XMLDocument getDocument() {
        return this.fParent == null ? null : this.fParent.getDocument();
    }

    public int contains(int n) {
        INodeRegion iNodeRegion = this.getRegion();
        return iNodeRegion == null ? 1 : iNodeRegion.contains(n);
    }

    public XMLNode getParent() {
        return this.fParent;
    }

    public int getChildrenCount() {
        return 0;
    }

    public XMLNode[] getChildren() {
        return EMPTY_NODES;
    }

    public XMLNode[] getChildNodes() {
        return EMPTY_NODES;
    }

    public void appendChild(XMLNode xMLNode) {
        throw new UnsupportedOperationException("XMLNode.appendChild");
    }

    public void insertChild(int n, XMLNode xMLNode) {
        throw new UnsupportedOperationException("XMLNode.insertChild");
    }

    public XMLNode removeChild(int n) {
        throw new UnsupportedOperationException("XMLNode.removeChild");
    }

    public XMLNode removeChild(XMLNode xMLNode) {
        throw new UnsupportedOperationException("XMLNode.removeChild");
    }

    public XMLNode replaceChild(int n, XMLNode xMLNode) {
        throw new UnsupportedOperationException("XMLNode.replaceChild");
    }

    public XMLNode replaceChild(XMLNode xMLNode, XMLNode xMLNode2) {
        throw new UnsupportedOperationException("XMLNode.replaceChild");
    }

    public INodeRegion getRegion() {
        return this.fRegion;
    }

    public void setRegion(INodeRegion iNodeRegion) {
        this.fRegion = iNodeRegion;
    }

    protected boolean isSame(XMLNode xMLNode) {
        if (xMLNode.getNodeType() != this.getNodeType()) {
            return false;
        }
        return this.getRegion().equals(xMLNode.getRegion());
    }
}

