/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xml;

import com.spket.buffer.IBuffer;
import com.spket.buffer.IBufferReader;
import com.spket.util.StringUtils;
import com.spket.xml.INodeRegion;
import com.spket.xml.NamespaceContextImpl;
import com.spket.xml.NodeRegion;
import com.spket.xml.XMLAttr;
import com.spket.xml.XMLCDATA;
import com.spket.xml.XMLComment;
import com.spket.xml.XMLConstants;
import com.spket.xml.XMLDocType;
import com.spket.xml.XMLDocument;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLNode;
import com.spket.xml.XMLProblem;
import com.spket.xml.XMLProcInst;
import com.spket.xml.XMLUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.util.ShadowedSymbolTable;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;

public class XMLModelParser {
    public static final int STATE_START_OF_MARKUP = 1;
    public static final int STATE_COMMENT = 2;
    public static final int STATE_PI = 3;
    public static final int STATE_DOCTYPE = 4;
    public static final int STATE_ROOT_ELEMENT = 6;
    public static final int STATE_CONTENT = 7;
    public static final int STATE_REFERENCE = 8;
    public static final int STATE_END_OF_INPUT = 13;
    public static final int STATE_TERMINATED = 14;
    public static final int STATE_CDATA = 15;
    public static final int STATE_TEXT_DECL = 16;
    private static final char[] XML = "<?xml".toCharArray();
    private static final char[] CDATA = "[CDATA[".toCharArray();
    private static final char[] DOCTYPE = "DOCTYPE".toCharArray();
    private static final char[] COMMENT = "--".toCharArray();
    private static final char[] PUBLIC = "PUBLIC".toCharArray();
    private static final char[] SYSTEM = "SYSTEM".toCharArray();
    protected XMLNode fCurrentNode;
    protected XMLDocument fDocument;
    protected int fScannerState;
    protected int fEndPosition;
    protected boolean fStandalone;
    protected boolean skipDoctypeScan;
    protected SymbolTable refSymbolTable;
    protected SymbolTable fSymbolTable;
    protected QName fQName;
    protected List fProblems;
    protected char[] fNameBuffer;
    protected IBufferReader fScanner;
    protected NamespaceContext fNamespaceContext;

    public XMLModelParser() {
        this(null);
    }

    public XMLModelParser(SymbolTable symbolTable) {
        this.refSymbolTable = symbolTable;
        this.fQName = new QName();
        this.fProblems = new ArrayList();
        this.fNameBuffer = new char[256];
        this.fNamespaceContext = new NamespaceContextImpl();
    }

    public XMLDocument getDocument() {
        return this.fDocument;
    }

    public List getProblems() {
        return this.fProblems;
    }

    public void parse(IBuffer iBuffer) {
        this.parse(iBuffer, null, 0, iBuffer.getLength());
    }

    public void parse(IBuffer iBuffer, XMLNode xMLNode, int n, int n2) {
        this.reset();
        this.fEndPosition = n2;
        this.fScannerState = 7;
        this.fDocument = new XMLDocument();
        this.fCurrentNode = this.fDocument;
        this.fDocument.setBuffer(iBuffer);
        this.fScanner = iBuffer.createReader(n, iBuffer.getLength() - n);
        if (xMLNode != null) {
            XMLUtils.getNamespaceContext(xMLNode, this.fSymbolTable, this.fNamespaceContext);
        }
        this.parse();
    }

    public void reset() {
        this.fDocument = null;
        this.fCurrentNode = null;
        this.fStandalone = false;
        this.skipDoctypeScan = false;
        this.fNamespaceContext.reset();
        if (this.fProblems.size() > 0) {
            this.fProblems.clear();
        }
        this.fSymbolTable = this.refSymbolTable == null ? new SymbolTable() : new ShadowedSymbolTable(this.refSymbolTable);
    }

    public void dispose() {
        if (this.fProblems != null) {
            this.fProblems.clear();
            this.fProblems = null;
        }
        if (this.fNamespaceContext != null) {
            this.fNamespaceContext.reset();
            this.fNamespaceContext = null;
        }
        this.fDocument = null;
        this.fCurrentNode = null;
        this.fSymbolTable = null;
        this.refSymbolTable = null;
        this.fNameBuffer = null;
    }

    protected void parse() {
        Object object;
        NodeRegion nodeRegion;
        int n;
        XMLNode xMLNode;
        if (this.getOffset() == 0 && this.fScanner.skip(XML)) {
            xMLNode = new XMLProcInst();
            n = this.getOffset();
            nodeRegion = new NodeRegion(n - 5, 5);
            xMLNode.setRegion(nodeRegion);
            this.fCurrentNode.appendChild(xMLNode);
            if (XMLUtils.isValidNameChar(this.fScanner.peek())) {
                object = this.scanPI();
                ((XMLProcInst)xMLNode).setName("xml" + (String)object);
            } else {
                this.scanXMLDecl(nodeRegion.getStart());
                ((XMLProcInst)xMLNode).setName("xml");
            }
            nodeRegion.adjustLength(this.getOffset() - n);
        }
        do {
            switch (this.fScannerState) {
                case 7: {
                    int n2 = this.scanContent();
                    if (n2 == 60) {
                        this.fScannerState = 1;
                        break;
                    }
                    if (n2 != -1) break;
                    return;
                }
                case 1: {
                    XMLNode xMLNode2;
                    if (this.fScanner.skip('!')) {
                        n = this.getOffset() - 2;
                        if (this.fScanner.skip('-')) {
                            if (this.fScanner.skip('-')) {
                                this.fScannerState = 2;
                                break;
                            }
                        } else {
                            if (this.fScanner.skip(CDATA)) {
                                this.fScannerState = 15;
                                break;
                            }
                            if (!this.skipDoctypeScan && this.fScanner.skip(DOCTYPE)) {
                                this.skipDoctypeScan = true;
                                this.scanDoctypeDecl(n);
                                this.fScannerState = 7;
                                break;
                            }
                        }
                        this.handleProblem(n, this.getOffset() - n, "Invalid");
                        this.fScannerState = 7;
                        break;
                    }
                    if (this.fScanner.skip('?')) {
                        this.fScannerState = 3;
                        break;
                    }
                    if (this.fScanner.skip('/')) {
                        n = this.getOffset() - 2;
                        if (this.scanQName(this.fQName)) {
                            XMLElement xMLElement;
                            this.skipSpaces();
                            nodeRegion = new NodeRegion(n, this.getOffset() - n);
                            n = this.getOffset();
                            this.fScannerState = 7;
                            switch (this.fScanner.read()) {
                                case 62: {
                                    nodeRegion.adjustLength(this.getOffset() - n);
                                    break;
                                }
                                case 60: {
                                    this.handleProblem(nodeRegion.getStart(), this.fQName.rawname.length() + 2, "Missing '>'");
                                    this.fScannerState = 1;
                                    break;
                                }
                                default: {
                                    this.handleProblem(nodeRegion.getStart(), this.fQName.rawname.length() + 2, "Missing '>'");
                                }
                            }
                            int n3 = 0;
                            boolean bl = false;
                            String string = this.fQName.prefix != null ? this.fQName.prefix : XMLConstants.EMPTY_STRING;
                            String string2 = this.fNamespaceContext.getURI(string);
                            for (xMLNode2 = this.fCurrentNode; xMLNode2 != null && xMLNode2.getNodeType() == 1; xMLNode2 = xMLNode2.getParent()) {
                                ++n3;
                                if (!StringUtils.equals((Object)this.fQName.rawname, (Object)xMLNode2.getName()) || !StringUtils.equals((Object)string2, (Object)xMLNode2.getNamespace())) continue;
                                bl = true;
                                xMLElement = (XMLElement)xMLNode2;
                                xMLElement.setEndTagRegion(nodeRegion);
                                this.fCurrentNode = xMLElement.getParent();
                                do {
                                    this.fNamespaceContext.popContext();
                                } while (--n3 > 0);
                                break;
                            }
                            if (bl) break;
                            xMLElement = new XMLElement();
                            xMLElement.setName(this.fQName.rawname);
                            xMLElement.setNamespace(string2);
                            xMLElement.setEndTagRegion(nodeRegion);
                            this.fCurrentNode.appendChild(xMLElement);
                            this.skipDoctypeScan = true;
                            break;
                        }
                        this.handleProblem(n, 2, "Missing tag name");
                        this.fScannerState = 7;
                        break;
                    }
                    if (XMLUtils.isValidNameStartChar(this.fScanner.peek())) {
                        this.skipDoctypeScan = true;
                        xMLNode = new XMLElement();
                        n = this.getOffset();
                        nodeRegion = new NodeRegion(n - 1, 1);
                        ((XMLElement)xMLNode).setStartTagRegion(nodeRegion);
                        this.fCurrentNode.appendChild(xMLNode);
                        this.fCurrentNode = xMLNode;
                        this.scanStartElement();
                        nodeRegion.adjustLength(this.getOffset() - n);
                        if (((XMLElement)xMLNode).isEmptyTag()) {
                            this.fCurrentNode = xMLNode.getParent();
                        }
                        this.fScannerState = 7;
                        break;
                    }
                    this.handleProblem(this.getOffset() - 1, 1, "Invalid character '<'");
                    this.fScannerState = 7;
                    break;
                }
                case 2: {
                    n = this.getOffset();
                    nodeRegion = new NodeRegion(n - 4, 4);
                    xMLNode = new XMLComment();
                    xMLNode.setRegion(nodeRegion);
                    this.fCurrentNode.appendChild(xMLNode);
                    this.scanComment();
                    nodeRegion.adjustLength(this.getOffset() - n);
                    this.fScannerState = 7;
                    break;
                }
                case 15: {
                    object = new XMLCDATA();
                    n = this.getOffset();
                    nodeRegion = new NodeRegion(n - 9, 9);
                    ((XMLNode)object).setRegion(nodeRegion);
                    this.fCurrentNode.appendChild((XMLNode)object);
                    ((XMLCDATA)object).setClosed(this.scanCDATA());
                    nodeRegion.adjustLength(this.getOffset() - n);
                    this.fScannerState = 7;
                    break;
                }
                case 3: {
                    XMLNode xMLNode2 = new XMLProcInst();
                    n = this.getOffset();
                    nodeRegion = new NodeRegion(n - 2, 2);
                    xMLNode2.setRegion(nodeRegion);
                    this.fCurrentNode.appendChild(xMLNode2);
                    ((XMLProcInst)xMLNode2).setName(this.scanPI());
                    nodeRegion.adjustLength(this.getOffset() - n);
                    this.fScannerState = 7;
                }
            }
        } while (this.fScannerState != 7 || this.getOffset() < this.fEndPosition);
    }

    protected int getOffset() {
        return this.fScanner.getOffset();
    }

    protected void handleProblem(INodeRegion iNodeRegion, String string) {
        this.handleProblem(iNodeRegion.getStart(), iNodeRegion.getLength(), string);
    }

    protected void handleProblem(int n, int n2, String string) {
        if (n2 > 0) {
            this.fProblems.add(new XMLProblem(string, 1, n, n2, -1));
        }
    }

    protected void scanComment() {
        int n;
        int n2 = this.getOffset();
        int n3 = -1;
        int n4 = -1;
        do {
            if ((n = this.fScanner.read()) == 62 && n3 == 45 && n4 == 45) {
                return;
            }
            n4 = n3;
            n3 = n;
        } while (n != -1);
        this.handleProblem(n2 - 4, 4, "Comment is not closed");
    }

    protected boolean scanCDATA() {
        int n;
        int n2 = -1;
        int n3 = -1;
        int n4 = this.getOffset();
        do {
            if ((n = this.fScanner.read()) == 62 && n2 == 93 && n3 == 93) {
                return true;
            }
            n3 = n2;
            n2 = n;
        } while (n != -1);
        this.handleProblem(n4 - 9, 9, "CDATA is not closed");
        return false;
    }

    protected String scanName() {
        int n = 0;
        int n2 = this.fScanner.peek();
        if (XMLUtils.isValidNameStartChar(n2)) {
            this.fScanner.read();
            this.fNameBuffer[n++] = (char)n2;
            while (XMLUtils.isValidNameChar(n2 = this.fScanner.peek())) {
                this.fScanner.read();
                if (n == this.fNameBuffer.length) {
                    char[] cArray = new char[n << 1];
                    System.arraycopy(this.fNameBuffer, 0, cArray, 0, n);
                    this.fNameBuffer = cArray;
                }
                this.fNameBuffer[n++] = (char)n2;
            }
        }
        if (n > 0) {
            return this.fSymbolTable.addSymbol(this.fNameBuffer, 0, n);
        }
        return null;
    }

    protected boolean scanQName(QName qName) {
        Object object;
        int n = 0;
        int n2 = this.fScanner.peek();
        int n3 = -1;
        if (XMLUtils.isValidNameStartChar(n2)) {
            this.fScanner.read();
            this.fNameBuffer[n++] = (char)n2;
            while (XMLUtils.isValidNameChar(n2 = this.fScanner.peek())) {
                if (n2 == 58) {
                    if (n3 != -1) break;
                    n3 = n;
                }
                this.fScanner.read();
                if (n == this.fNameBuffer.length) {
                    object = new char[n << 1];
                    System.arraycopy(this.fNameBuffer, 0, object, 0, n);
                    this.fNameBuffer = (char[])object;
                }
                this.fNameBuffer[n++] = (char)n2;
            }
        }
        if (n > 0) {
            object = null;
            String string = null;
            String string2 = this.fSymbolTable.addSymbol(this.fNameBuffer, 0, n);
            if (n3 != -1) {
                int n4 = n3;
                object = this.fSymbolTable.addSymbol(this.fNameBuffer, 0, n4);
                int n5 = n - n4 - 1;
                int n6 = n3 + 1;
                string = this.fSymbolTable.addSymbol(this.fNameBuffer, n6, n5);
            } else {
                string = string2;
            }
            qName.setValues(object, string, string2, null);
            return true;
        }
        return false;
    }

    protected String scanPI() {
        int n;
        String string = this.scanName();
        int n2 = -1;
        while ((n = this.fScanner.read()) != 62 || n2 != 63) {
            n2 = n;
            if (n != -1) continue;
        }
        return string;
    }

    protected int scanContent() {
        int n;
        int n2 = this.getOffset();
        do {
            n = this.fScanner.read();
            ++n2;
            if (n != 60) continue;
            if (n2 < this.fEndPosition) break;
            this.fScanner.unread();
            break;
        } while (n != -1);
        if (n2 >= this.fEndPosition) {
            return -1;
        }
        return n;
    }

    protected boolean skipSpaces() {
        int n = this.fScanner.read();
        if (XMLUtils.isSpace(n)) {
            while ((n = this.fScanner.read()) != -1) {
                if (XMLUtils.isSpace(n)) continue;
                this.fScanner.unread();
                break;
            }
            return true;
        }
        if (n != -1) {
            this.fScanner.unread();
        }
        return false;
    }

    protected String scanLiteral() {
        int n = this.fScanner.peek();
        if (n == 39 || n == 34) {
            int n2;
            this.fScanner.read();
            StringBuffer stringBuffer = new StringBuffer();
            while ((n2 = this.fScanner.read()) != n && n2 != 60 && n2 != -1) {
                stringBuffer.append((char)n2);
            }
            if (stringBuffer.length() > 0) {
                return stringBuffer.toString();
            }
        }
        return null;
    }

    protected void scanXMLDecl(int n) {
        this.skipSpaces();
        int n2 = this.fScanner.peek();
        while (n2 != -1 && n2 != 63) {
            String string = this.scanName();
            if (string != null) {
                this.skipSpaces();
                if (this.fScanner.skip('=')) {
                    this.skipSpaces();
                    String string2 = this.scanLiteral();
                    if ("version".equals(string)) {
                        this.fDocument.setVersion(string2);
                    } else if ("encoding".equals(string)) {
                        this.fDocument.setEncoding(string2);
                    } else if ("standalone".equals(string) && "yes".equals(string2)) {
                        this.fStandalone = true;
                    }
                }
                this.skipSpaces();
            } else {
                while ((n2 = this.fScanner.peek()) != -1 && !XMLUtils.isValidNameStartChar(n2)) {
                    this.fScanner.read();
                }
            }
            n2 = this.fScanner.peek();
        }
        if (this.fScanner.skip('?')) {
            if (!this.fScanner.skip('>')) {
                this.handleProblem(n, this.getOffset() - n, "missing '>'");
            }
        } else {
            this.handleProblem(n, this.getOffset() - n, "missing '>'");
        }
    }

    protected void scanExternalID(XMLDocType xMLDocType) {
        String string = null;
        String string2 = null;
        int n = this.getOffset();
        if (this.fScanner.skip(PUBLIC)) {
            if (!this.skipSpaces()) {
                this.handleProblem(n, this.getOffset() - n, "Missing space");
            }
            if ((string2 = this.scanLiteral()) == null) {
                this.handleProblem(n, this.getOffset() - n, "Missing public id");
            } else {
                if (!this.skipSpaces()) {
                    this.handleProblem(this.getOffset() - 1, 1, "Missing space");
                }
                string = this.scanLiteral();
            }
        } else if (this.fScanner.skip(SYSTEM)) {
            if (!this.skipSpaces()) {
                this.handleProblem(n, this.getOffset() - n, "Missing space");
            }
            string = this.scanLiteral();
        }
        if (xMLDocType != null) {
            xMLDocType.setPublicId(string2);
            xMLDocType.setSystemId(string);
        }
    }

    protected String getValue(INodeRegion iNodeRegion, int n) {
        if (iNodeRegion != null) {
            String string;
            int n2;
            int n3 = iNodeRegion.getStart() + n;
            int n4 = iNodeRegion.getEnd() + n;
            if ((n2 = this.fScanner.get(n3++)) == this.fScanner.get(n4 - 1)) {
                --n4;
            }
            return (string = this.fScanner.get(n3, n4 - n3)) == null ? XMLConstants.EMPTY_STRING : string;
        }
        return XMLConstants.EMPTY_STRING;
    }

    protected boolean scanAttribute(int n) {
        int n2;
        int n3 = this.getOffset();
        this.scanQName(this.fQName);
        XMLElement xMLElement = (XMLElement)this.fCurrentNode;
        NodeRegion nodeRegion = new NodeRegion(n3 - n, this.getOffset() - n3);
        XMLAttr xMLAttr = new XMLAttr();
        xMLAttr.setName(this.fQName.rawname);
        xMLAttr.setNameRegion(nodeRegion);
        xMLElement.appendAttribute(xMLAttr);
        this.skipSpaces();
        if (!this.fScanner.skip('=')) {
            this.handleProblem(n3, this.getOffset() - n3, "Missing '='");
            return true;
        }
        xMLAttr.setEqualOffset(this.getOffset() - n);
        this.skipSpaces();
        int n4 = this.fScanner.peek();
        if (n4 != 39 && n4 != 34) {
            this.handleProblem(n3, this.getOffset() - n3, "Missing quote");
            return true;
        }
        this.fScanner.read();
        n3 = this.getOffset();
        nodeRegion = new NodeRegion(n3 - n - 1, 1);
        xMLAttr.setValueRegion(nodeRegion);
        boolean bl = true;
        while ((n2 = this.fScanner.read()) != n4) {
            if (n2 == 60) {
                this.handleProblem(n3, this.getOffset() - n3, "Missing closing quote");
                bl = false;
                this.fScanner.unread();
                break;
            }
            if (n2 != -1) continue;
            this.handleProblem(n3, this.getOffset() - n3, "Missing closing quote");
            bl = false;
            break;
        }
        nodeRegion.adjustLength(this.getOffset() - n3);
        if (nodeRegion.getLength() > 0) {
            if (XMLConstants.PREFIX_XMLNS.equals(this.fQName.rawname)) {
                String string = this.getValue(nodeRegion, n);
                this.fNamespaceContext.declarePrefix(XMLConstants.EMPTY_STRING, string.length() != 0 ? string : null);
            } else {
                String string;
                String string2 = string = this.fQName.prefix != null ? this.fQName.prefix : XMLConstants.EMPTY_STRING;
                if (XMLConstants.PREFIX_XMLNS.equals(string)) {
                    String string3 = this.fQName.localpart;
                    String string4 = this.getValue(nodeRegion, n);
                    if (XMLConstants.PREFIX_XMLNS.equals(string3)) {
                        this.handleProblem(this.getOffset(), string3.length(), "Cannot have \"" + string3 + "\" as prefix.");
                    }
                    if (XMLConstants.NS_XMLNS.equals(string4)) {
                        // empty if block
                    }
                    if (XMLConstants.PREFIX_XML.equals(string3) ? !XMLConstants.NS_XML.equals(string4) : XMLConstants.NS_XML.equals(string4)) {
                        // empty if block
                    }
                    string = XMLConstants.PREFIX_XMLNS.equals(string3) ? XMLConstants.EMPTY_STRING : string3;
                    this.fNamespaceContext.declarePrefix(string, string4.length() != 0 ? string4 : null);
                }
            }
        }
        return bl;
    }

    protected void scanStartElement() {
        Object object;
        int n;
        boolean bl = false;
        XMLElement xMLElement = (XMLElement)this.fCurrentNode;
        this.scanQName(this.fQName);
        xMLElement.setName(this.fQName.rawname);
        this.fNamespaceContext.pushContext();
        int n2 = xMLElement.getStartTagRegion().getStart();
        int n3 = -1;
        boolean bl2 = false;
        do {
            if (!bl) {
                this.skipSpaces();
                n3 = this.fScanner.peek();
            }
            bl = false;
            if (n3 == 62) {
                bl2 = true;
                this.fScanner.read();
                break;
            }
            if (n3 == 47) {
                this.fScanner.read();
                if (this.fScanner.skip('>')) {
                    bl2 = true;
                    xMLElement.setEmptyTag(true);
                    break;
                }
                this.handleProblem(this.getOffset() - 1, 1, "Invalid character '/'");
                continue;
            }
            if (n3 == 60) break;
            if (XMLUtils.isValidNameStartChar(n3)) {
                if (this.scanAttribute(n2)) continue;
                break;
            }
            n = this.getOffset();
            do {
                this.fScanner.read();
                n3 = this.fScanner.peek();
                if (n3 != 60 && n3 != 47 && n3 != 62 && !XMLUtils.isValidNameStartChar(n3)) continue;
                bl = true;
                break;
            } while (n3 != -1);
            this.handleProblem(n, this.getOffset() - n, "Invalid");
        } while (n3 != -1);
        n = xMLElement.getAttrCount();
        if (n > 0) {
            object = xMLElement.getAttrs();
            for (int i = 0; i < n; ++i) {
                XMLAttr xMLAttr = object[i];
                String string = xMLAttr.getPrefix();
                if (string == null) continue;
                xMLAttr.setNamespace(this.fNamespaceContext.getURI(string));
            }
        }
        if ((object = xMLElement.getPrefix()) == null) {
            object = XMLConstants.EMPTY_STRING;
        }
        xMLElement.setNamespace(this.fNamespaceContext.getURI((String)object));
        if (xMLElement.isEmptyTag()) {
            this.fNamespaceContext.popContext();
        }
        if (!bl2) {
            this.handleProblem(xMLElement.getStartTagRegion().getStart(), xMLElement.getName().length() + 1, "Missing '>'");
        }
    }

    protected void scanDecl(boolean bl) {
        int n = -1;
        while (true) {
            int n2 = this.fScanner.read();
            switch (n2) {
                case -1: {
                    return;
                }
                case 62: {
                    if (n != -1) break;
                    return;
                }
                case 34: 
                case 39: {
                    if (n == n2) {
                        n = -1;
                        break;
                    }
                    if (n != -1) break;
                    n = n2;
                    break;
                }
                case 60: {
                    if (bl) {
                        if (n != -1) break;
                        this.fScanner.unread();
                        return;
                    }
                    this.fScanner.unread();
                    return;
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected void scanDoctypeDecl(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CASE]], but top level block is 6[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

