/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xml;

import com.spket.xml.XMLNode;

public abstract class ParentNode
extends XMLNode {
    protected int fChildrenCount;
    protected XMLNode[] fChildren = EMPTY_NODES;

    public void dispose() {
        if (this.fChildrenCount > 0) {
            for (int i = 0; i < this.fChildrenCount; ++i) {
                this.fChildren[i].dispose();
            }
            this.fChildrenCount = 0;
            this.fChildren = EMPTY_NODES;
        }
        super.dispose();
    }

    public int getChildrenCount() {
        return this.fChildrenCount;
    }

    public XMLNode[] getChildren() {
        return this.fChildren;
    }

    public XMLNode[] getChildNodes() {
        if (this.fChildrenCount == this.fChildren.length) {
            return this.fChildren;
        }
        XMLNode[] xMLNodeArray = new XMLNode[this.fChildrenCount];
        System.arraycopy(this.fChildren, 0, xMLNodeArray, 0, this.fChildrenCount);
        return xMLNodeArray;
    }

    public void appendChild(XMLNode xMLNode) {
        if (this.fChildrenCount == this.fChildren.length) {
            XMLNode[] xMLNodeArray = new XMLNode[this.fChildrenCount * 3 / 2 + 1];
            System.arraycopy(this.fChildren, 0, xMLNodeArray, 0, this.fChildrenCount);
            this.fChildren = xMLNodeArray;
        }
        this.fChildren[this.fChildrenCount] = xMLNode;
        xMLNode.fParent = this;
        ++this.fChildrenCount;
    }

    public void insertChild(int n, XMLNode xMLNode) {
        if (n < 0 || n > this.fChildrenCount) {
            return;
        }
        if (n == this.fChildrenCount) {
            this.appendChild(xMLNode);
        } else {
            if (this.fChildrenCount == this.fChildren.length) {
                XMLNode[] xMLNodeArray = new XMLNode[this.fChildrenCount + 2];
                System.arraycopy(this.fChildren, 0, xMLNodeArray, 0, this.fChildrenCount);
                this.fChildren = xMLNodeArray;
            }
            System.arraycopy(this.fChildren, n, this.fChildren, n + 1, this.fChildrenCount - n);
            this.fChildren[n] = xMLNode;
            xMLNode.fParent = this;
            ++this.fChildrenCount;
        }
    }

    public XMLNode removeChild(int n) {
        if (n < 0 || n >= this.fChildrenCount) {
            return null;
        }
        XMLNode xMLNode = this.fChildren[n];
        int n2 = this.fChildrenCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.fChildren, n + 1, this.fChildren, n, n2);
        }
        this.fChildren[--this.fChildrenCount] = null;
        xMLNode.fParent = null;
        return xMLNode;
    }

    public XMLNode removeChild(XMLNode xMLNode) {
        for (int i = 0; i < this.fChildrenCount; ++i) {
            if (this.fChildren[i] != xMLNode) continue;
            return this.removeChild(i);
        }
        return null;
    }

    public XMLNode replaceChild(XMLNode xMLNode, XMLNode xMLNode2) {
        if (xMLNode == null) {
            return null;
        }
        if (xMLNode2 == null) {
            return this.removeChild(xMLNode);
        }
        for (int i = 0; i < this.fChildrenCount; ++i) {
            if (this.fChildren[i] != xMLNode) continue;
            return this.replaceChild(i, xMLNode2);
        }
        return null;
    }

    public XMLNode replaceChild(int n, XMLNode xMLNode) {
        if (n < 0 || n >= this.fChildrenCount) {
            return null;
        }
        if (xMLNode == null) {
            return this.removeChild(n);
        }
        XMLNode xMLNode2 = this.fChildren[n];
        xMLNode2.fParent = null;
        this.fChildren[n] = xMLNode;
        xMLNode.fParent = this;
        return xMLNode2;
    }

    protected void reset() {
        this.fChildrenCount = 0;
    }

    protected void shrink() {
        if (this.fChildrenCount > 0) {
            int n = this.fChildren.length - this.fChildrenCount;
            if (n * 3 > this.fChildrenCount) {
                XMLNode[] xMLNodeArray = this.fChildren;
                this.fChildren = new XMLNode[this.fChildrenCount];
                System.arraycopy(xMLNodeArray, 0, this.fChildren, 0, this.fChildrenCount);
            } else {
                for (int i = this.fChildrenCount; i < this.fChildren.length; ++i) {
                    this.fChildren[i] = null;
                }
            }
        } else {
            this.fChildren = EMPTY_NODES;
        }
    }
}

