/*
 * Decompiled with CFR 0.152.
 */
package com.spket.widget;

import com.spket.util.IntTable;
import com.spket.widget.CItem;
import com.spket.widget.IOwnerDraw;
import org.eclipse.swt.graphics.GC;

public class ListItem
extends CItem {
    public static final int D_OWNER_DRAW = 1;
    public static final int D_USER = 10;
    public static final int S_CATEGORY = 1;
    public static final int S_EXPANDED = 2;
    public static final int S_BOLD = 4;
    public static final int S_READONLY = 8;
    protected static final ListItem[] EMPTY_ITEMS = new ListItem[0];
    private int fSize;
    private int fLevel;
    private ListItem[] fItems = EMPTY_ITEMS;
    private IntTable fTexts;
    private IntTable fDatas;
    private ListItem fParent;

    public static ListItem[] appendItem(ListItem[] listItemArray, ListItem listItem, int n) {
        if (listItemArray == null) {
            listItemArray = new ListItem[]{listItem};
        } else {
            if (listItemArray.length <= n) {
                ListItem[] listItemArray2 = new ListItem[listItemArray.length + 1];
                System.arraycopy(listItemArray, 0, listItemArray2, 0, n);
                listItemArray = listItemArray2;
            }
            listItemArray[n] = listItem;
        }
        return listItemArray;
    }

    public ListItem() {
    }

    public ListItem(String string) {
        super(string);
    }

    public ListItem getParent() {
        return this.fParent;
    }

    public ListItem[] getItems() {
        if (this.fSize > 0) {
            ListItem[] listItemArray = new ListItem[this.fSize];
            System.arraycopy(this.fItems, 0, listItemArray, 0, this.fSize);
            return listItemArray;
        }
        return EMPTY_ITEMS;
    }

    public ListItem getItem(int n) {
        if (n >= 0 && n < this.fSize) {
            return this.fItems[n];
        }
        return null;
    }

    public void addItem(ListItem listItem) {
        this.fItems = ListItem.appendItem(this.fItems, listItem, this.fSize);
        ++this.fSize;
        listItem.fParent = this;
    }

    public void addItems(ListItem[] listItemArray) {
        if (listItemArray != null && listItemArray.length > 0) {
            this.ensureCapacity(this.fSize + listItemArray.length);
            System.arraycopy(listItemArray, 0, this.fItems, this.fSize, listItemArray.length);
            this.fSize += listItemArray.length;
            for (int i = 0; i < listItemArray.length; ++i) {
                listItemArray[i].fParent = this;
            }
        }
    }

    public void ensureCapacity(int n) {
        if (n > this.fItems.length) {
            ListItem[] listItemArray = new ListItem[n];
            if (this.fSize > 0) {
                System.arraycopy(this.fItems, 0, listItemArray, 0, this.fSize);
            }
            this.fItems = listItemArray;
        }
    }

    public void removeAll() {
        for (int i = 0; i < this.fSize; ++i) {
            this.fItems[i].fParent = null;
        }
        this.fSize = 0;
        this.fItems = EMPTY_ITEMS;
    }

    public boolean isCategory() {
        return (this.type & 1) != 0;
    }

    public boolean isExpanded() {
        return (this.type & 2) != 0;
    }

    public void setExpanded(boolean bl) {
        this.setFlag(2, bl);
    }

    public void setCategory(boolean bl) {
        this.setFlag(1, bl);
    }

    public boolean isOwnerDraw() {
        return this.getData(1) instanceof IOwnerDraw;
    }

    public boolean isBold() {
        return (this.type & 4) != 0;
    }

    public void setBold(boolean bl) {
        this.setFlag(4, bl);
    }

    public boolean isReadOnly() {
        return (this.type & 8) != 0;
    }

    public void setReadOnly(boolean bl) {
        this.setFlag(8, bl);
    }

    public int getItemCount() {
        return this.fSize;
    }

    public int getExpandedItemCount() {
        if (this.fSize == 0) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.fSize; ++i) {
            ++n;
            if (!this.fItems[i].isExpanded()) continue;
            n += this.fItems[i].getExpandedItemCount();
        }
        return n;
    }

    public String getText(int n) {
        if (n == 0) {
            return this.getText();
        }
        if (this.fTexts != null) {
            return (String)this.fTexts.get(n);
        }
        return null;
    }

    public void setText(int n, String string) {
        if (n == 0) {
            this.setText(string);
        } else {
            if (this.fTexts == null) {
                this.fTexts = new IntTable(1);
            }
            this.fTexts.set(n, (Object)string);
        }
    }

    public Object getData(int n) {
        if (n == 0) {
            return this.getData();
        }
        return this.fDatas == null ? null : this.fDatas.get(n);
    }

    public void setData(int n, Object object) {
        if (n == 0) {
            this.setData(object);
        } else if (this.fDatas == null) {
            if (object != null) {
                this.fDatas = new IntTable(2);
                this.fDatas.set(n, object);
            }
        } else {
            this.fDatas.set(n, object);
        }
    }

    protected void draw(GC gC, int n, int n2, int n3, int n4) {
        Object object = this.getData(1);
        if (object instanceof IOwnerDraw) {
            ((IOwnerDraw)object).draw(gC, this.getData(), n, n2, n3, n4);
        }
    }

    protected int getWidth() {
        Object object = this.getData(1);
        if (object instanceof IOwnerDraw) {
            return ((IOwnerDraw)object).getWidth();
        }
        return 0;
    }

    public int getLevel() {
        return this.fLevel;
    }

    protected void setLevel(int n) {
        this.fLevel = n;
    }

    protected final void setFlag(int n, boolean bl) {
        this.type = bl ? (this.type |= n) : (this.type &= ~n);
    }

    public int fill(CItem[] cItemArray, int n, int n2) {
        int n3 = n;
        for (int i = 0; i < this.fSize; ++i) {
            ListItem listItem = this.fItems[i];
            cItemArray[n3++] = listItem;
            if (listItem.isCategory()) {
                listItem.setLevel(0);
            } else {
                listItem.setLevel(n2);
            }
            if (!listItem.isExpanded()) continue;
            n3 += listItem.fill(cItemArray, n3, listItem.getLevel() + 1);
        }
        return n3 - n;
    }
}

