/*
 * Decompiled with CFR 0.152.
 */
package com.spket.widget;

public class HSB {
    private static double EPSILON = 1.0E-6;
    private double hue;
    private double saturation;
    private double brightness;

    public static HSB convert(int n) {
        return HSB.convert(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
    }

    public static HSB convert(int n, int n2, int n3) {
        double d = (double)n / 255.0;
        double d2 = (double)n2 / 255.0;
        double d3 = (double)n3 / 255.0;
        double d4 = Math.max(d, Math.max(d2, d3));
        double d5 = Math.min(d, Math.min(d2, d3));
        double d6 = d4 - d5;
        double d7 = 0.0;
        double d8 = 0.0;
        if (d6 > EPSILON || d6 < -EPSILON) {
            if (d4 == d && d2 >= d3) {
                d8 = 60.0 * (d2 - d3) / d6;
            } else if (d4 == d && d2 < d3) {
                d8 = 60.0 * (d2 - d3) / d6 + 360.0;
            } else if (d4 == d2) {
                d8 = 60.0 * (d3 - d) / d6 + 120.0;
            } else if (d4 == d3) {
                d8 = 60.0 * (d - d2) / d6 + 240.0;
            }
            d7 = d4 == 0.0 ? 0.0 : 1.0 - d5 / d4;
        }
        return new HSB(d8, d7, d4);
    }

    public HSB(double d, double d2, double d3) {
        this.setHue(d);
        this.setSaturation(d2);
        this.setBrightness(d3);
    }

    public double getHue() {
        return this.hue;
    }

    public void setHue(double d) {
        this.hue = d > 360.0 ? 360.0 : (d < 0.0 ? 0.0 : d);
    }

    public double getSaturation() {
        return this.saturation;
    }

    public void setSaturation(double d) {
        this.saturation = d > 1.0 ? 1.0 : (d < 0.0 ? 0.0 : d);
    }

    public double getBrightness() {
        return this.brightness;
    }

    public void setBrightness(double d) {
        this.brightness = d > 1.0 ? 1.0 : (d < 0.0 ? 0.0 : d);
    }

    public int rgb() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.saturation == 0.0) {
            d2 = d3 = this.brightness;
            d = d3;
        } else {
            double d4 = this.hue / 60.0;
            int n = (int)Math.floor(d4);
            double d5 = d4 - (double)n;
            double d6 = this.brightness * (1.0 - this.saturation);
            double d7 = this.brightness * (1.0 - this.saturation * d5);
            double d8 = this.brightness * (1.0 - this.saturation * (1.0 - d5));
            switch (n) {
                case 0: {
                    d = this.brightness;
                    d2 = d8;
                    d3 = d6;
                    break;
                }
                case 1: {
                    d = d7;
                    d2 = this.brightness;
                    d3 = d6;
                    break;
                }
                case 2: {
                    d = d6;
                    d2 = this.brightness;
                    d3 = d8;
                    break;
                }
                case 3: {
                    d = d6;
                    d2 = d7;
                    d3 = this.brightness;
                    break;
                }
                case 4: {
                    d = d8;
                    d2 = d6;
                    d3 = this.brightness;
                    break;
                }
                case 5: {
                    d = this.brightness;
                    d2 = d6;
                    d3 = d7;
                }
            }
        }
        return HSB.clip(d * 255.0) << 16 | HSB.clip(d2 * 255.0) << 8 | HSB.clip(d3 * 255.0);
    }

    protected static int clip(double d) {
        int n = (int)d;
        return n > 255 ? 255 : (n < 0 ? 0 : n);
    }
}

