/*
 * Decompiled with CFR 0.152.
 */
package com.spket.widget;

import com.spket.widget.CItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.CPopup;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public abstract class CList
extends CPopup {
    protected static final int F_LAYOUTED = 1;
    protected static final int F_MOUSE_DOWN = 2;
    protected static final int F_SHOW_TOOLTIP = 4;
    protected static final int FLAG_SHIFT = 3;
    protected static final int GAP = 3;
    protected static final CItem[] EMPTY_ITEM = new CItem[0];
    protected CItem[] fItems = EMPTY_ITEM;
    protected int fItemCount = 0;
    protected int fColumnCount = this.getMinimumColumns();
    protected int fSelectedIndex = -1;
    protected int fMouseOverIndex = -1;
    private int flags;
    protected Color fBorderColor = this.getDisplay().getSystemColor(10);
    protected Color fBgColor = this.getDisplay().getSystemColor(20);
    protected Color fSelectionColor = this.getDisplay().getSystemColor(29);
    protected Color fSelectionDarkColor = this.getDisplay().getSystemColor(26);

    public CList(Composite composite, int n) {
        super(composite, n | 0x40000 | 0x100000);
        this.installListeners();
    }

    public void ensureCapacity(int n) {
        if (n > this.fItems.length) {
            CItem[] cItemArray = new CItem[n];
            if (this.fItemCount > 0) {
                System.arraycopy(this.fItems, 0, cItemArray, 0, this.fItemCount);
            }
            this.fItems = cItemArray;
        }
    }

    protected void addItem(CItem cItem) {
        this.setFlag(1, false);
        if (this.fItemCount >= this.fItems.length) {
            int n = this.fItems.length;
            CItem[] cItemArray = new CItem[n + this.getGrowSize()];
            System.arraycopy(this.fItems, 0, cItemArray, 0, n);
            this.fItems = cItemArray;
        }
        this.fItems[this.fItemCount] = cItem;
        ++this.fItemCount;
    }

    public CItem getItem(int n) {
        if (n >= 0 && n < this.fItemCount) {
            return this.fItems[n];
        }
        return null;
    }

    public void setShowToolTip(boolean bl) {
        this.setFlag(4, bl);
    }

    protected String calcToolTipText(int n) {
        return null;
    }

    protected int getGrowSize() {
        return 2;
    }

    protected void installListeners() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 5: {
                        CList.this.onMouseMove(event.x, event.y);
                        break;
                    }
                    case 3: {
                        CList.this.onMouseDown(event.x, event.y);
                        break;
                    }
                    case 4: {
                        CList.this.onMouseUp(event.x, event.y);
                        break;
                    }
                    case 7: {
                        CList.this.onMouseExit(event.x, event.y);
                        break;
                    }
                    case 9: {
                        CList.this.onPaint(event);
                        break;
                    }
                    case 11: {
                        CList.this.onResize(event);
                        break;
                    }
                    case 31: {
                        event.doit = CList.this.onTraverse(event.detail, event.keyCode);
                        break;
                    }
                    case 12: {
                        CList.this.onDispose();
                    }
                }
            }
        };
        int[] nArray = new int[]{9, 5, 3, 4, 7, 11, 31, 12};
        for (int i = 0; i < nArray.length; ++i) {
            this.addListener(nArray[i], listener);
        }
    }

    protected void onDispose() {
        this.fBorderColor = null;
        this.fBgColor = null;
        this.fSelectionColor = null;
        this.fSelectionDarkColor = null;
    }

    protected void onMouseDown(int n, int n2) {
        this.setFlag(2, true);
        int n3 = this.getIndexAtPoint(n, n2);
        if (n3 != -1) {
            int n4 = this.fMouseOverIndex;
            this.fMouseOverIndex = n3;
            if (n4 != n3 && n4 != -1) {
                this.redraw(n4);
            }
            if (this.fMouseOverIndex != -1) {
                this.redraw(this.fMouseOverIndex);
            }
        }
    }

    protected void onMouseUp(int n, int n2) {
        this.setFlag(2, false);
        int n3 = this.getIndexAtPoint(n, n2);
        if (n3 != -1) {
            this.setSelection(n3, true);
        }
    }

    protected void onMouseMove(int n, int n2) {
        int n3 = this.getIndexAtPoint(n, n2);
        if (n3 != this.fMouseOverIndex) {
            int n4 = this.fMouseOverIndex;
            this.fMouseOverIndex = n3;
            if (n4 != -1) {
                this.redraw(n4);
            }
            if (this.fMouseOverIndex != -1) {
                this.redraw(this.fMouseOverIndex);
            }
            if (this.getFlag(4)) {
                this.setToolTipText(this.calcToolTipText(this.fMouseOverIndex));
            }
        }
    }

    protected void onMouseExit(int n, int n2) {
        if (this.fMouseOverIndex != -1) {
            if (this.getFlag(4)) {
                this.setToolTipText(null);
            }
            int n3 = this.fMouseOverIndex;
            this.fMouseOverIndex = -1;
            this.redraw(n3);
        }
    }

    protected void onPaint(Event event) {
        this.layout(false);
        GC gC = event.gc;
        Rectangle rectangle = gC.getClipping();
        this.paintBackground(gC, rectangle);
        this.paintContentBackground(gC, rectangle);
        this.paintContent(gC, rectangle);
        this.paintContentBorder(gC, rectangle);
        this.paintBorder(gC, rectangle);
    }

    protected void paintBackground(GC gC, Rectangle rectangle) {
        gC.setBackground(this.fBgColor);
        gC.fillRectangle(rectangle);
    }

    protected void paintContent(GC gC, Rectangle rectangle) {
        for (int i = 0; i < this.fItemCount; ++i) {
            if (!rectangle.intersects(this.getBounds(i))) continue;
            this.drawItem(gC, i);
        }
    }

    protected void paintContentBackground(GC gC, Rectangle rectangle) {
        Rectangle rectangle2;
        if (this.fMouseOverIndex != -1 && !this.isSeparator(this.fMouseOverIndex) && (rectangle2 = this.getBounds(this.fMouseOverIndex)).intersects(rectangle)) {
            if (this.getFlag(2)) {
                gC.setBackground(this.fSelectionDarkColor);
            } else {
                gC.setBackground(this.fSelectionColor);
            }
            gC.fillRectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
    }

    protected void paintContentBorder(GC gC, Rectangle rectangle) {
        Rectangle rectangle2;
        if (this.fSelectedIndex != -1 && !this.isSeparator(this.fSelectedIndex) && (rectangle2 = this.getBounds(this.fSelectedIndex)).intersects(rectangle)) {
            gC.setForeground(this.fBorderColor);
            gC.drawRectangle(rectangle2.x, rectangle2.y, rectangle2.width - 1, rectangle2.height - 1);
        }
        if (this.fMouseOverIndex != -1 && this.fMouseOverIndex != this.fSelectedIndex && !this.isSeparator(this.fMouseOverIndex) && (rectangle2 = this.getBounds(this.fMouseOverIndex)).intersects(rectangle)) {
            gC.setForeground(this.fBorderColor);
            gC.drawRectangle(rectangle2.x, rectangle2.y, rectangle2.width - 1, rectangle2.height - 1);
        }
    }

    protected void paintBorder(GC gC, Rectangle rectangle) {
        Rectangle rectangle2;
        if ((this.getStyle() & 0x800000) != 0 && rectangle.intersects(rectangle2 = this.getClientArea())) {
            gC.setForeground(this.getDisplay().getSystemColor(18));
            gC.drawRectangle(rectangle2.x, rectangle2.y, rectangle2.width - 1, rectangle2.height - 1);
        }
    }

    public void layout(boolean bl) {
        if (this.needLayout() || bl) {
            this.doLayout();
            this.setFlag(1, true);
        }
    }

    public void setLayout(Layout layout) {
    }

    protected boolean needLayout() {
        return !this.getFlag(1);
    }

    protected abstract void doLayout();

    protected void onResize(Event event) {
        this.setFlag(1, false);
        this.redraw();
    }

    protected boolean onTraverse(int n, int n2) {
        switch (n) {
            case 4: {
                int n3 = this.getTraverseIndex(this.fMouseOverIndex, n, n2);
                if (n3 == -1) break;
                this.setSelection(n3, true);
                return false;
            }
            case 8: 
            case 16: 
            case 32: 
            case 64: 
            case 256: 
            case 512: {
                int n4 = this.getTraverseIndex(this.fMouseOverIndex, n, n2);
                if (n4 == -1 || n4 == this.fMouseOverIndex) break;
                if (this.getFlag(4) && this.getToolTipText() != null) {
                    this.setToolTipText(null);
                }
                int n5 = this.fMouseOverIndex;
                this.fMouseOverIndex = n4;
                if (n5 != -1) {
                    this.redraw(n5);
                }
                if (this.fMouseOverIndex == -1) break;
                this.redraw(this.fMouseOverIndex);
            }
        }
        return true;
    }

    public int getColumnCount() {
        return this.fColumnCount;
    }

    public void setColumnCount(int n) {
        if (this.fColumnCount == n) {
            return;
        }
        this.fColumnCount = n < this.getMinimumColumns() ? this.getMinimumColumns() : n;
        this.setFlag(1, false);
        this.redraw();
    }

    protected int getTraverseIndex(int n, int n2, int n3) {
        boolean bl = false;
        int n4 = n;
        block0 : switch (n2) {
            case 4: {
                if (n4 >= 0 && n4 < this.fItemCount && !this.skipTraverse(n4)) break;
                n4 = -1;
                break;
            }
            case 8: 
            case 32: 
            case 256: {
                int n5;
                if (n4 == -1) {
                    n4 = this.fSelectedIndex;
                }
                if (n4 == -1) {
                    bl = true;
                    n4 = this.fItemCount;
                } else {
                    n5 = this.getColumnCount();
                    if (n3 == 0x1000001 && this.isNormal(this.getItem(n4))) {
                        for (int i = 0; i < n5 && --n4 >= 0 && this.isNormal(this.getItem(n4)); ++i) {
                        }
                    } else {
                        --n4;
                    }
                    if (n4 < 0) {
                        bl = true;
                        n4 = this.fItemCount - 1;
                    }
                }
                if (32 == n2) {
                    n5 = n4;
                    while (this.skipTraverse(n4)) {
                        if (--n4 < 0) {
                            n4 = this.fItemCount - 1;
                        }
                        if (n5 != n4) continue;
                        return -1;
                    }
                    break;
                }
                n5 = n4;
                do {
                    if (bl) {
                        if (!this.skipTraverse(n4)) {
                            break block0;
                        }
                    } else if (this.skipTraverse(n4)) {
                        bl = true;
                    }
                    if (--n4 >= 0) continue;
                    n4 = this.fItemCount - 1;
                } while (n5 != n4);
                return -1;
            }
            case 16: 
            case 64: 
            case 512: {
                int n6;
                if (n4 == -1) {
                    n4 = this.fSelectedIndex;
                }
                if (n4 == -1) {
                    n4 = 0;
                    bl = true;
                } else {
                    n6 = this.getColumnCount();
                    if (n3 == 0x1000002 && this.isNormal(this.getItem(n4))) {
                        for (int i = 0; i < n6 && ++n4 < this.fItemCount && this.isNormal(this.getItem(n4)); ++i) {
                        }
                    } else {
                        ++n4;
                    }
                    if (n4 >= this.fItemCount) {
                        n4 = 0;
                        bl = true;
                    }
                }
                if (64 == n2) {
                    n6 = n4;
                    while (this.skipTraverse(n4)) {
                        if (++n4 >= this.fItemCount) {
                            n4 = 0;
                        }
                        if (n6 != n4) continue;
                        return -1;
                    }
                    break;
                }
                n6 = n4;
                do {
                    if (bl) {
                        if (!this.skipTraverse(n4)) {
                            break block0;
                        }
                    } else if (this.skipTraverse(n4)) {
                        bl = true;
                    }
                    if (++n4 < this.fItemCount) continue;
                    n4 = 0;
                } while (n6 != n4);
                return -1;
            }
        }
        return n4;
    }

    protected boolean getFlag(int n) {
        return (this.flags & n) != 0;
    }

    protected void setFlag(int n, boolean bl) {
        this.flags = bl ? (this.flags |= n) : (this.flags &= ~n);
    }

    protected boolean isNormal(int n) {
        return this.isNormal(this.getItem(n));
    }

    protected boolean isNormal(CItem cItem) {
        return true;
    }

    protected boolean isSeparator(int n) {
        return this.isSeparator(this.getItem(n));
    }

    protected boolean isSeparator(CItem cItem) {
        return !this.isNormal(cItem);
    }

    protected boolean skipTraverse(int n) {
        CItem cItem = this.getItem(n);
        return cItem == null || this.isSeparator(cItem);
    }

    protected Rectangle getBounds(int n) {
        return this.fItems[n].bounds;
    }

    protected int getIndexAtPoint(int n, int n2) {
        int n3 = -1;
        for (int i = 0; i < this.fItemCount; ++i) {
            Rectangle rectangle = this.getBounds(i);
            if (rectangle.x > n && rectangle.y > n2) break;
            if (!rectangle.contains(n, n2)) continue;
            n3 = i;
            break;
        }
        return n3;
    }

    protected void drawSeparator(GC gC, int n, int n2, int n3, int n4) {
        Color color = gC.getForeground();
        gC.setForeground(this.getDisplay().getSystemColor(20));
        gC.drawLine(n + 1, n2 - 1, n + n3 - 1, n2 - 1);
        gC.setForeground(this.getDisplay().getSystemColor(18));
        gC.drawLine(n, n2, n + n3 - 2, n2);
        gC.setForeground(color);
    }

    public CItem getSelection() {
        return this.getItem(this.fSelectedIndex);
    }

    protected boolean setSelection(int n) {
        this.checkWidget();
        CItem cItem = this.getItem(n);
        if (cItem != null && this.isSeparator(cItem)) {
            return false;
        }
        if (this.fSelectedIndex != n) {
            int n2 = this.fSelectedIndex;
            this.fSelectedIndex = n >= 0 && n < this.fItemCount ? n : -1;
            if (n2 != -1) {
                this.redraw(n2);
            }
            if (this.fSelectedIndex != -1) {
                this.redraw(this.fSelectedIndex);
            }
        }
        return true;
    }

    protected void setSelection(int n, boolean bl) {
        if (this.setSelection(n) && bl) {
            Event event = new Event();
            event.data = this.getItem(n);
            this.notifyListeners(13, event);
        }
    }

    protected Object onSelectionChanged(Event event) {
        if (event.data instanceof CItem) {
            return ((CItem)event.data).fData;
        }
        return null;
    }

    protected void redraw(int n) {
        CItem cItem = this.getItem(n);
        if (cItem != null) {
            Rectangle rectangle = this.getBounds(n);
            if (rectangle != null) {
                this.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
            } else {
                this.redraw();
            }
        }
    }

    protected abstract int getMinimumColumns();

    protected abstract void drawItem(GC var1, int var2);
}

