/*
 * Decompiled with CFR 0.152.
 */
package com.spket.widget;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;

public class BorderLayout
extends Layout {
    public static final int CENTER = 0;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int SASH_WIDTH = 3;
    public static final int DRAG_MINIMUM = 20;
    protected Composite fHost;
    protected Control fMaxControl = null;
    protected int fType;
    protected Control[] fControls = new Control[5];
    protected Sash[] fSashes = new Sash[5];
    protected int[] fWeights = new int[5];
    protected Listener fSashListener = new Listener(){

        public void handleEvent(Event event) {
            BorderLayout.this.onDragSash(event);
        }
    };
    protected Listener fControlListener = new Listener(){

        public void handleEvent(Event event) {
            BorderLayout.this.onDispose(event);
        }
    };

    public BorderLayout() {
        this(256);
    }

    public BorderLayout(int n) {
        this.fType = n;
    }

    public void attach(Composite composite) {
        if (this.fHost == composite) {
            return;
        }
        if (this.fHost != null) {
            this.detach();
        }
        this.fHost = composite;
        for (int i = 0; i < this.fWeights.length; ++i) {
            this.fWeights[i] = -1;
        }
        if (this.fHost != null) {
            this.fHost.setLayout((Layout)this);
        }
    }

    public void detach() {
        int n;
        if (this.fHost == null) {
            return;
        }
        if (this.fHost.getLayout() == this) {
            this.fHost.setLayout(null);
        }
        for (n = 0; n < this.fControls.length; ++n) {
            Control control = this.fControls[n];
            if (control != null && !control.isDisposed()) {
                control.removeListener(12, this.fControlListener);
            }
            this.fControls[n] = null;
        }
        for (n = 0; n < this.fSashes.length; ++n) {
            if (this.fSashes[n] == null) continue;
            this.fSashes[n].dispose();
            this.fSashes[n] = null;
        }
        this.fHost = null;
    }

    public void addLayoutControl(Control control, int n) {
        this.addLayoutControl(control, n, -1);
    }

    public void addLayoutControl(Control control, int n, int n2) {
        if (control == null) {
            SWT.error((int)4);
        }
        if (control.getParent() != this.fHost) {
            SWT.error((int)32);
        }
        if (n < 0 || n > 4) {
            SWT.error((int)6);
        }
        if (this.fControls[n] == control) {
            return;
        }
        this.removeLayoutControl(control);
        this.fControls[n] = control;
        control.addListener(12, this.fControlListener);
        if (n != 0) {
            int n3 = 256;
            if (n == 3 || n == 4) {
                n3 = 512;
            }
            this.fWeights[n] = n2;
            if (this.fSashes[n] == null) {
                this.fSashes[n] = new Sash(this.fHost, n3);
                this.fSashes[n].addListener(13, this.fSashListener);
            }
        }
    }

    public void setMaximizedControl(Control control) {
        if (control == this.fMaxControl) {
            return;
        }
        if (this.fHost == null) {
            SWT.error((int)32);
        }
        if (control != null && control.getParent() != this.fHost) {
            SWT.error((int)32);
        }
        this.fMaxControl = control;
        this.fHost.layout();
    }

    public void removeLayoutControl(Control control) {
        for (int i = 0; i < this.fControls.length; ++i) {
            if (this.fControls[i] != control) continue;
            if (!control.isDisposed()) {
                control.removeListener(12, this.fControlListener);
            }
            this.fControls[i] = null;
            if (i == 0) break;
            this.fSashes[i].dispose();
            this.fSashes[i] = null;
            break;
        }
    }

    protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
        Point point;
        if (composite != this.fHost) {
            SWT.error((int)32);
        }
        int n3 = 0;
        int n4 = 0;
        if (this.fControls[1] != null) {
            point = this.fControls[1].computeSize(-1, this.fWeights[1], bl);
            n4 += Math.max(point.y, 20) + 3;
        }
        if (this.fControls[2] != null) {
            point = this.fControls[2].computeSize(-1, this.fWeights[2], bl);
            n4 += Math.max(point.y, 20) + 3;
        }
        if (this.fControls[3] != null) {
            point = this.fControls[3].computeSize(this.fWeights[3], -1, bl);
            n3 += Math.max(point.x, 20) + 3;
        }
        if (this.fControls[4] != null) {
            point = this.fControls[4].computeSize(this.fWeights[4], -1, bl);
            n3 += Math.max(point.x, 20) + 3;
        }
        if (this.fControls[0] != null) {
            point = this.fControls[0].computeSize(-1, -1, bl);
            n3 += point.x;
            n4 += point.y;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        return new Point(n3, n4);
    }

    protected void layout(Composite composite, boolean bl) {
        if (composite != this.fHost) {
            SWT.error((int)32);
        }
        if (this.fMaxControl != null) {
            if (this.fMaxControl.isVisible()) {
                int n;
                Rectangle rectangle = composite.getClientArea();
                for (n = 0; n < this.fControls.length; ++n) {
                    Control control = this.fControls[n];
                    if (this.fMaxControl == control) {
                        if ((control.getStyle() & 0x800000) != 0) {
                            ++rectangle.x;
                            ++rectangle.y;
                            rectangle.width -= 2;
                            rectangle.height -= 2;
                            if (rectangle.width < 0) {
                                rectangle.width = 0;
                            }
                            if (rectangle.height < 0) {
                                rectangle.height = 0;
                            }
                        }
                        control.setBounds(rectangle);
                        continue;
                    }
                    if (control == null) continue;
                    control.setSize(0, 0);
                }
                for (n = 0; n < this.fSashes.length; ++n) {
                    if (this.fSashes[n] == null) continue;
                    this.fSashes[n].setSize(0, 0);
                }
                return;
            }
            this.fMaxControl = null;
        }
        if (this.fType == 256) {
            this.layoutHorizontal(composite, bl);
        } else {
            this.layoutVertical(composite, bl);
        }
    }

    protected void layoutHorizontal(Composite composite, boolean bl) {
        Rectangle rectangle = composite.getClientArea();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        this.layoutControl(rectangle, 1);
        this.layoutControl(rectangle, 2);
        this.layoutControl(rectangle, 3);
        this.layoutControl(rectangle, 4);
        this.layoutControl(rectangle, 0);
    }

    protected void layoutVertical(Composite composite, boolean bl) {
        Rectangle rectangle = composite.getClientArea();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        this.layoutControl(rectangle, 3);
        this.layoutControl(rectangle, 4);
        this.layoutControl(rectangle, 1);
        this.layoutControl(rectangle, 2);
        this.layoutControl(rectangle, 0);
    }

    protected void layoutControl(Rectangle rectangle, int n) {
        Control control = this.fControls[n];
        if (control == null) {
            return;
        }
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        int n9 = n5;
        if (n != 0) {
            if (this.fWeights[n] == -1) {
                Point point = control.computeSize(n4, this.fWeights[n], true);
                this.fWeights[n] = Math.max(point.y, 20);
            }
            if (n == 1 || n == 2) {
                n9 = this.fWeights[n];
                n5 = n9 + 3;
                if (n == 1) {
                    this.fSashes[n].setBounds(n6, n7 + n9, n8, 3);
                    rectangle.y += n5;
                } else {
                    if ((n7 += rectangle.height - n9) < 0) {
                        n7 = 0;
                    }
                    this.fSashes[n].setBounds(n6, n7 - 3, n8, 3);
                }
            } else {
                n8 = this.fWeights[n];
                n4 = n8 + 3;
                if (n == 3) {
                    this.fSashes[n].setBounds(n6 + n8, n7, 3, n9);
                    rectangle.x += n4;
                } else {
                    if ((n6 += rectangle.width - n8) < 0) {
                        n6 = 0;
                    }
                    this.fSashes[n].setBounds(n6 - 3, n7, 3, n9);
                }
            }
        }
        if ((control.getStyle() & 0x800000) != 0) {
            ++n6;
            ++n7;
            n9 -= 2;
            if ((n8 -= 2) < 0) {
                n8 = 0;
            }
            if (n9 < 0) {
                n9 = 0;
            }
        }
        control.setBounds(n6, n7, n8, n9);
        if (!control.isVisible()) {
            n4 = 0;
            n5 = 0;
            if (n != 0) {
                this.fSashes[n].setBounds(0, 0, 0, 0);
            }
        }
        if (n == 1 || n == 2) {
            rectangle.height -= n5;
        } else {
            rectangle.width -= n4;
        }
    }

    protected void onDispose(Event event) {
        this.removeLayoutControl((Control)event.widget);
    }

    protected void doZoom(Event event) {
        Control control = (Control)event.widget;
        this.setMaximizedControl(control == this.fMaxControl ? null : control);
    }

    protected void onDragSash(Event event) {
        int n;
        Sash sash = (Sash)event.widget;
        if (event.detail == 1) {
            Rectangle rectangle = this.fHost.getClientArea();
            int n2 = sash.getStyle();
            if ((n2 & 0x200) != 0) {
                int n3 = 20;
                int n4 = rectangle.width - 20;
                if (sash == this.fSashes[3]) {
                    if (this.fSashes[4] != null) {
                        n4 = this.fSashes[4].getBounds().x - 20;
                    }
                } else if (this.fSashes[3] != null) {
                    Rectangle rectangle2 = this.fSashes[3].getBounds();
                    n3 = rectangle2.x + rectangle2.width + 20;
                }
                event.x = Math.min(Math.max(n3, event.x), n4);
            } else {
                int n5 = 20;
                int n6 = rectangle.height - 20;
                if (sash == this.fSashes[1]) {
                    if (this.fSashes[2] != null) {
                        n6 = this.fSashes[2].getBounds().y - 20;
                    }
                } else if (this.fSashes[1] != null) {
                    Rectangle rectangle3 = this.fSashes[1].getBounds();
                    n5 = rectangle3.y + rectangle3.height + 20;
                }
                event.y = Math.min(Math.max(n5, event.y), n6);
            }
            return;
        }
        int n7 = -1;
        for (n = 0; n < this.fSashes.length; ++n) {
            if (sash != this.fSashes[n]) continue;
            n7 = n;
            break;
        }
        if (n7 != -1) {
            Rectangle rectangle = sash.getBounds();
            switch (n7) {
                case 1: {
                    n = event.y - rectangle.y;
                    int n8 = n7;
                    this.fWeights[n8] = this.fWeights[n8] + n;
                    break;
                }
                case 2: {
                    n = event.y - rectangle.y;
                    int n9 = n7;
                    this.fWeights[n9] = this.fWeights[n9] - n;
                    break;
                }
                case 3: {
                    n = event.x - rectangle.x;
                    int n10 = n7;
                    this.fWeights[n10] = this.fWeights[n10] + n;
                    break;
                }
                case 4: {
                    n = event.x - rectangle.x;
                    int n11 = n7;
                    this.fWeights[n11] = this.fWeights[n11] - n;
                }
            }
            this.fHost.layout();
        }
    }
}

