/*
 * Decompiled with CFR 0.152.
 */
package com.spket.as.internal.compiler.problem;

import com.spket.as.core.compiler.IProblem;
import com.spket.as.internal.compiler.problem.ProblemSeverities;
import com.spket.as.internal.compiler.util.Messages;
import com.spket.as.internal.compiler.util.Util;

public class DefaultProblem
implements ProblemSeverities,
IProblem {
    private char[] fileName;
    private int id;
    private int startPosition;
    private int endPosition;
    private int line;
    private int severity;
    private String[] arguments;
    private String message;

    public DefaultProblem(char[] cArray, String string, int n, String[] stringArray, int n2, int n3, int n4, int n5) {
        this.fileName = cArray;
        this.message = string;
        this.id = n;
        this.arguments = stringArray;
        this.severity = n2;
        this.startPosition = n3;
        this.endPosition = n4;
        this.line = n5;
    }

    public String errorReportSource(char[] cArray) {
        int n;
        int n2;
        char c;
        int n3;
        if (this.startPosition > this.endPosition || this.startPosition < 0 && this.endPosition < 0) {
            return Messages.problem_noSourceInformation;
        }
        StringBuffer stringBuffer = new StringBuffer(" ");
        stringBuffer.append(Messages.bind(Messages.problem_atLine, String.valueOf(this.line)));
        stringBuffer.append(Util.LINE_SEPARATOR).append("\t");
        int n4 = cArray.length;
        int n5 = n3 = this.startPosition >= n4 ? n4 - 1 : this.startPosition;
        while (n3 > 0 && (c = cArray[n3 - 1]) != '\n' && c != '\r') {
            --n3;
        }
        int n6 = n2 = this.endPosition >= n4 ? n4 - 1 : this.endPosition;
        while (n2 + 1 < n4 && (c = cArray[n2 + 1]) != '\r' && c != '\n') {
            ++n2;
        }
        while ((c = cArray[n3]) == ' ' || c == '\t') {
            ++n3;
        }
        stringBuffer.append(cArray, n3, n2 - n3 + 1);
        stringBuffer.append(Util.LINE_SEPARATOR).append("\t");
        for (n = n3; n < this.startPosition; ++n) {
            stringBuffer.append(cArray[n] == '\t' ? (char)'\t' : ' ');
        }
        for (n = this.startPosition; n <= (this.endPosition >= n4 ? n4 - 1 : this.endPosition); ++n) {
            stringBuffer.append('^');
        }
        return stringBuffer.toString();
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public int getID() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public char[] getOriginatingFileName() {
        return this.fileName;
    }

    public int getSourceEnd() {
        return this.endPosition;
    }

    public int getSourceLineNumber() {
        return this.line;
    }

    public int getSourceStart() {
        return this.startPosition;
    }

    public boolean isError() {
        return (this.severity & 1) != 0;
    }

    public boolean isWarning() {
        return (this.severity & 1) == 0;
    }

    public void setOriginatingFileName(char[] cArray) {
        this.fileName = cArray;
    }

    public void setSourceEnd(int n) {
        this.endPosition = n;
    }

    public void setSourceLineNumber(int n) {
        this.line = n;
    }

    public void setSourceStart(int n) {
        this.startPosition = n;
    }

    public String toString() {
        String string = "Pb(" + (this.id & 0xFFFFFF) + ") ";
        if (this.message != null) {
            string = string + this.message;
        } else if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                string = string + " " + this.arguments[i];
            }
        }
        return string;
    }
}

