/*
 * Decompiled with CFR 0.152.
 */
package com.spket.as.internal.compiler.ast;

import com.spket.as.internal.compiler.ASTVisitor;
import com.spket.as.internal.compiler.ast.ASTNode;
import com.spket.as.internal.compiler.ast.EmptyStatement;
import com.spket.as.internal.compiler.ast.Expression;
import com.spket.as.internal.compiler.ast.Statement;
import com.spket.as.internal.compiler.lookup.BlockScope;
import com.spket.as.internal.compiler.lookup.Frame;

public class ForStatement
extends Statement {
    public ASTNode[] initializations;
    public Expression[] conditions;
    public Expression[] increments;
    public Statement action;
    public BlockScope frame;

    public ForStatement(ASTNode[] aSTNodeArray, Expression[] expressionArray, Expression[] expressionArray2, Statement statement, boolean bl, int n, int n2) {
        this.sourceStart = n;
        this.sourceEnd = n2;
        this.initializations = aSTNodeArray;
        this.conditions = expressionArray;
        this.increments = expressionArray2;
        this.action = statement;
        if (statement instanceof EmptyStatement) {
            statement.bits |= 1;
        }
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        int n2;
        ForStatement.printIndent(n, stringBuffer).append("for (");
        if (this.initializations != null) {
            for (n2 = 0; n2 < this.initializations.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.initializations[n2].print(0, stringBuffer);
            }
        }
        stringBuffer.append("; ");
        if (this.conditions != null) {
            for (n2 = 0; n2 < this.conditions.length; ++n2) {
                this.conditions[n2].printExpression(0, stringBuffer);
            }
        }
        stringBuffer.append("; ");
        if (this.increments != null) {
            for (n2 = 0; n2 < this.increments.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.increments[n2].print(0, stringBuffer);
            }
        }
        stringBuffer.append(") ");
        if (this.action == null) {
            stringBuffer.append(';');
        } else {
            stringBuffer.append('\n');
            this.action.printStatement(n + 1, stringBuffer);
        }
        return stringBuffer.append(';');
    }

    public void traverse(ASTVisitor aSTVisitor, Frame frame) {
        if (aSTVisitor.visit(this, frame)) {
            int n;
            if (this.initializations != null) {
                for (n = 0; n < this.initializations.length; ++n) {
                    this.initializations[n].traverse(aSTVisitor, this.frame);
                }
            }
            if (this.conditions != null) {
                for (n = 0; n < this.conditions.length; ++n) {
                    this.conditions[n].traverse(aSTVisitor, this.frame);
                }
            }
            if (this.increments != null) {
                for (n = 0; n < this.increments.length; ++n) {
                    this.increments[n].traverse(aSTVisitor, this.frame);
                }
            }
            if (this.action != null) {
                this.action.traverse(aSTVisitor, this.frame);
            }
        }
        aSTVisitor.endVisit(this, frame);
    }
}

