/*
 * Decompiled with CFR 0.152.
 */
package com.a7soft.examxml;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ExamXMLErrorHandler
implements ErrorHandler {
    private static PrintStream err;
    private static String fileName;
    private static ExamXMLErrorHandler handler;
    private static boolean implicit;

    static void setLogFile(String logFileName, boolean force) {
        if (force || implicit) {
            err = null;
            fileName = logFileName;
            if (force) {
                implicit = fileName == null;
            }
        }
    }

    static ExamXMLErrorHandler getInstance() {
        if (handler == null) {
            handler = new ExamXMLErrorHandler();
        }
        return handler;
    }

    static void printError(Exception e) {
        ExamXMLErrorHandler.openLog();
        e.printStackTrace(err);
    }

    private static void openLog() {
        if (err == null) {
            err = System.err;
            if (fileName != null) {
                try {
                    err = new PrintStream(fileName);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private ExamXMLErrorHandler() {
    }

    public void warning(SAXParseException ex) {
        this.printMessage("[Warning] ", ex);
    }

    public void error(SAXParseException ex) {
        this.printMessage("[Error] ", ex);
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        this.printMessage("[Fatal Error] ", ex);
    }

    private void printMessage(String header, SAXParseException ex) {
        ExamXMLErrorHandler.openLog();
        StringBuffer str = new StringBuffer(header);
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            str.append(systemId);
        }
        str.append(':');
        str.append(ex.getLineNumber());
        str.append(':');
        str.append(ex.getColumnNumber());
        str.append(':');
        str.append(ex.getMessage());
        err.println(str);
    }

    static {
        implicit = true;
    }
}

