/*

  Copyright (C) 2004-2005 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.jndi.mirror;

import javax.naming.CompoundName;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import java.util.Properties;


/**
 * Default <code>NameParser</code> implementation.
 */
public class MirrorNameParser implements NameParser {
    /**
     * Stores syntax properties.
     */
    private static final Properties syntax = new Properties();

    static {
        syntax.put("jndi.syntax.direction", "left_to_right");
        syntax.put("jndi.syntax.separator", ".");
        syntax.put("jndi.syntax.ignorecase", "false");
        syntax.put("jndi.syntax.escape", "\\");
        syntax.put("jndi.syntax.beginquote", "'");
    }

    /**
     * Creates <code>MirrorNameParser</code> object.
     */
    public MirrorNameParser() {}

    /**
     * Parses a name into its components.
     *
     * @param name The non-<code>null</code> string name to parse
     * @return A non-<code>null</code> parsed form of the name using the naming convention of this parser.
     * @throws NamingException If a naming exception was encountered.
     */
    public Name parse(String name) throws NamingException {
        return new CompoundName(name, syntax);
    }
}
