/*

  Copyright (C) 2004-2005 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.jndi.mirror.samples;

import javax.naming.Context;
import javax.naming.InitialContext;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Hashtable;


/**
 * Shows how to perform basic operations on the context.
 */
public class BasicOperationsSample {
    /**
     * Performs basic operations on the context.
     *
     * @param args
     */
    public static void main(String[] args) {
        try {
            Hashtable environment = new Hashtable();
            environment.put(Context.INITIAL_CONTEXT_FACTORY, "com.smardec.jndi.mirror.MirrorInitialCtxFactory");
            Context mirrorCtx = new InitialContext(environment);
            Context a = mirrorCtx.createSubcontext("a");
            Context b = a.createSubcontext("b");
            Context c = b.createSubcontext("c");
            c.bind("date", new Date());
            System.out.println("Date: " + mirrorCtx.lookup("a.b.c.date"));

            if (args.length > 0 && "binary".equals(args[0])) {
                // Binary serialized form, works on any JDK version
                System.out.println("Saving to file 'basic.dat'");
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream("basic.dat"));
                objectOutputStream.writeObject(mirrorCtx.lookup(""));
                objectOutputStream.close();
            } else {
                System.out.println("Saving to file 'basic.xml'");
                // XML serialized form, JDK1.4 or higher is required
                FileOutputStream fileOutputStream = new FileOutputStream("basic.xml");
                fileOutputStream.write(mirrorCtx.lookup("").toString().getBytes());
                fileOutputStream.close();
            }

            mirrorCtx.close();

            if (args.length > 0 && "binary".equals(args[0])) {
                System.out.println("Loading file 'basic.dat'");
                Context loadedContext = CopySaveLoadSample.loadContextFromFile("basic.dat");
                System.out.println("Loaded date: " + loadedContext.lookup("a.b.c.date"));
                loadedContext.close();
            } else {
                System.out.println("Loading file 'basic.xml'");
                Context loadedContext = CopySaveLoadSample.loadContextFromFile("basic.xml");
                System.out.println("Loaded date: " + loadedContext.lookup("a.b.c.date"));
                loadedContext.close();
            }
        } catch (Exception e) {
            e.printStackTrace();
        } catch (NoClassDefFoundError error) {
            System.out.println("JDK1.4 or higher is required for XML serialization\n" +
                    "Use 'binary' command line parameter");
        }
    }
}
