/*
 * Decompiled with CFR 0.152.
 */
package com.smardec.jndi.mirror;

import com.smardec.jndi.mirror.AbstractNamingEnumeration;
import com.smardec.jndi.mirror.MirrorNameParser;
import java.beans.XMLEncoder;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.spi.NamingManager;

public class MirrorCtx
implements Context,
Cloneable,
Serializable {
    private static final NameParser nameParser = new MirrorNameParser();
    private Hashtable environment = null;
    private Hashtable bindings = new Hashtable();
    private MirrorCtx parent = null;
    private String name = null;

    MirrorCtx(Hashtable environment) {
        if (environment != null) {
            this.environment = (Hashtable)environment.clone();
        }
    }

    private MirrorCtx(MirrorCtx parent, String name, Hashtable environment) {
        this(environment);
        this.parent = parent;
        this.name = name;
    }

    public Object clone() throws CloneNotSupportedException {
        MirrorCtx clone = new MirrorCtx(this.parent, this.name, this.environment);
        clone.bindings = (Hashtable)this.bindings.clone();
        return clone;
    }

    private Name getParsedName(Name name) throws NamingException {
        if (name instanceof CompositeName) {
            if (name.size() > 1) {
                throw new InvalidNameException("Cannot handle all components");
            }
            return nameParser.parse(name.get(0));
        }
        return name;
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.environment == null) {
            this.environment = new Hashtable();
        }
        return this.environment.put(propName, propVal);
    }

    public void bind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Name cannot be empty");
        }
        Name parsedName = this.getParsedName(name);
        String firstName = parsedName.get(0);
        Object firstBinding = this.bindings.get(firstName);
        if (parsedName.size() == 1) {
            if (firstBinding != null) {
                throw new NameAlreadyBoundException("Name already bound");
            }
            this.bindings.put(firstName, NamingManager.getStateToBind(obj, new CompositeName(firstName), this, this.environment));
        } else {
            if (!(firstBinding instanceof Context)) {
                throw new NameNotFoundException(firstName + " is not a context name");
            }
            ((Context)firstBinding).bind(parsedName.getSuffix(1), obj);
        }
    }

    public void bind(String name, Object obj) throws NamingException {
        this.bind(new CompositeName(name), obj);
    }

    public void close() throws NamingException {
        this.bindings.clear();
        this.environment = null;
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = ((Name)prefix.clone()).addAll(name);
        return new CompositeName(result.toString());
    }

    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(new CompositeName(name), new CompositeName(prefix)).toString();
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Name cannot be empty");
        }
        Name parsedName = this.getParsedName(name);
        String firstName = parsedName.get(0);
        Object firstBinding = this.bindings.get(firstName);
        if (parsedName.size() == 1) {
            if (firstBinding != null) {
                throw new NameAlreadyBoundException("Name already bound");
            }
            MirrorCtx subcontext = new MirrorCtx(this, firstName, this.environment);
            this.bindings.put(firstName, subcontext);
            return subcontext;
        }
        if (!(firstBinding instanceof Context)) {
            throw new NameNotFoundException(firstName + " is not a context name");
        }
        return ((Context)firstBinding).createSubcontext(parsedName.getSuffix(1));
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(new CompositeName(name));
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Name cannot be empty");
        }
        Name parsedName = this.getParsedName(name);
        String firstName = parsedName.get(0);
        Object firstBinding = this.bindings.get(firstName);
        if (parsedName.size() == 1) {
            if (firstBinding == null) {
                return;
            }
            if (!(firstBinding instanceof Context)) {
                throw new NotContextException(firstName + " is not a context name");
            }
            if (((Context)firstBinding).list("").hasMore()) {
                throw new ContextNotEmptyException(firstName + " should be empty");
            }
            this.bindings.remove(firstName);
        } else {
            if (!(firstBinding instanceof Context)) {
                throw new NameNotFoundException(firstName + " is not a context name");
            }
            ((Context)firstBinding).destroySubcontext(parsedName.getSuffix(1));
        }
    }

    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(new CompositeName(name));
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.environment == null) {
            return new Hashtable();
        }
        return (Hashtable)this.environment.clone();
    }

    public String getNameInNamespace() throws NamingException {
        if (this.parent == null) {
            return "";
        }
        Name fullName = nameParser.parse("");
        MirrorCtx parentIter = this;
        while (parentIter != null && parentIter.name != null) {
            fullName.add(0, parentIter.name);
            parentIter = parentIter.parent;
        }
        return fullName.toString();
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return nameParser;
    }

    public NameParser getNameParser(String name) throws NamingException {
        return this.getNameParser(new CompositeName(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new NamesEnumeration(this.bindings.keys());
        }
        Object binding = this.lookup(name);
        if (binding instanceof Context) {
            return ((Context)binding).list("");
        }
        throw new NotContextException(name + " is not a context and cannot be listed");
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(new CompositeName(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new BindingsEnumeration(this.bindings.keys());
        }
        Object binding = this.lookup(name);
        if (binding instanceof Context) {
            return ((Context)binding).listBindings("");
        }
        throw new NotContextException(name + " is not a context and cannot be listed");
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(new CompositeName(name));
    }

    public Object lookup(Name name) throws NamingException {
        if (name.isEmpty()) {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                return null;
            }
        }
        Name parsedName = this.getParsedName(name);
        String firstName = parsedName.get(0);
        Object firstBinding = this.bindings.get(firstName);
        if (parsedName.size() == 1) {
            if (firstBinding == null) {
                throw new NameNotFoundException(name + " not found");
            }
            try {
                return NamingManager.getObjectInstance(firstBinding, new CompositeName(firstName), this, this.environment);
            }
            catch (Exception e) {
                NamingException namingException = new NamingException("NamingManager.getObjectInstance returned error");
                namingException.setRootCause(e);
                throw namingException;
            }
        }
        if (!(firstBinding instanceof Context)) {
            throw new NameNotFoundException(firstName + " is not a context name");
        }
        return ((Context)firstBinding).lookup(parsedName.getSuffix(1));
    }

    public Object lookup(String name) throws NamingException {
        return this.lookup(new CompositeName(name));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(new CompositeName(name));
    }

    public void rebind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Name cannot be empty");
        }
        Name parsedName = this.getParsedName(name);
        String firstName = parsedName.get(0);
        if (parsedName.size() == 1) {
            this.bindings.put(firstName, NamingManager.getStateToBind(obj, new CompositeName(firstName), this, this.environment));
        } else {
            Object firstBinding = this.bindings.get(firstName);
            if (!(firstBinding instanceof Context)) {
                throw new NameNotFoundException(firstName + " is not a context name");
            }
            ((Context)firstBinding).rebind(parsedName.getSuffix(1), obj);
        }
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(new CompositeName(name), obj);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.environment == null) {
            return null;
        }
        return this.environment.remove(propName);
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        if (oldName.isEmpty() || newName.isEmpty()) {
            throw new InvalidNameException("Name cannot be empty");
        }
        Name oldParsedName = this.getParsedName(oldName);
        Name newParsedName = this.getParsedName(newName);
        if (oldParsedName.size() != newParsedName.size()) {
            throw new NamingException("Names should belong to the same context");
        }
        String oldFirstName = oldParsedName.get(0);
        String newFirstName = newParsedName.get(0);
        if (oldParsedName.size() == 1) {
            if (this.bindings.get(newFirstName) != null) {
                throw new NameAlreadyBoundException("New name already bound");
            }
            Object oldBinding = this.bindings.remove(oldFirstName);
            if (oldBinding == null) {
                throw new NameNotFoundException("Old name is not bound");
            }
            this.bindings.put(newFirstName, oldBinding);
        } else {
            if (!oldFirstName.equals(newFirstName)) {
                throw new NamingException("Names should belong to the same context");
            }
            Object oldFirstBinding = this.bindings.get(oldFirstName);
            if (!(oldFirstBinding instanceof Context)) {
                throw new NameNotFoundException(oldFirstName + " is not a context name");
            }
            ((Context)oldFirstBinding).rename(oldParsedName.getSuffix(1), newParsedName.getSuffix(1));
        }
    }

    public void rename(String oldName, String newName) throws NamingException {
        this.rename(new CompositeName(oldName), new CompositeName(newName));
    }

    public void unbind(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Name cannot be empty");
        }
        Name parsedName = this.getParsedName(name);
        String firstName = parsedName.get(0);
        if (parsedName.size() == 1) {
            this.bindings.remove(firstName);
        } else {
            Object firstBinding = this.bindings.get(firstName);
            if (!(firstBinding instanceof Context)) {
                throw new NameNotFoundException(firstName + " is not a context name");
            }
            ((Context)firstBinding).unbind(parsedName.getSuffix(1));
        }
    }

    public void unbind(String name) throws NamingException {
        this.unbind(new CompositeName(name));
    }

    public MirrorCtx() {
    }

    public Hashtable getBindings() {
        return this.bindings;
    }

    public void setBindings(Hashtable bindings) {
        this.bindings = bindings;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MirrorCtx getParent() {
        return this.parent;
    }

    public void setParent(MirrorCtx parent) {
        this.parent = parent;
    }

    public String toString() {
        ByteArrayOutputStream output = new ByteArrayOutputStream(4096);
        XMLEncoder xmlEncoder = new XMLEncoder(output);
        xmlEncoder.writeObject(this);
        xmlEncoder.close();
        return new String(output.toByteArray());
    }

    class BindingsEnumeration
    extends AbstractNamingEnumeration {
        public BindingsEnumeration(Enumeration enumeration) {
            this.originalEnumeration = enumeration;
        }

        public Object next() throws NamingException {
            String name = (String)this.originalEnumeration.nextElement();
            Object binding = MirrorCtx.this.bindings.get(name);
            try {
                binding = NamingManager.getObjectInstance(binding, new CompositeName(name), MirrorCtx.this, MirrorCtx.this.environment);
            }
            catch (Exception e) {
                NamingException namingException = new NamingException("getObjectInstance failed");
                namingException.setRootCause(e);
                throw namingException;
            }
            return new Binding(name, binding);
        }
    }

    class NamesEnumeration
    extends AbstractNamingEnumeration {
        public NamesEnumeration(Enumeration enumeration) {
            this.originalEnumeration = enumeration;
        }

        public Object next() throws NamingException {
            String name = (String)this.originalEnumeration.nextElement();
            String className = MirrorCtx.this.bindings.get(name).getClass().getName();
            return new NameClassPair(name, className);
        }
    }
}

