program SendMessage;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  BTQueue in '..\..\source\BTQueue.pas',
  BTCommAdapterIndy in '..\..\source\BTCommAdapterIndy.pas',
  BTJMSInterfaces in '..\..\source\BTJMSInterfaces.pas',
  BTConnectionFactory in '..\..\source\BTConnectionFactory.pas';

var
  Conn: IConnection;
  Session: ISession;
  P: IMessageProducer;
  Destination: IQueue;
  Message: ITextMessage;

begin
  with TBTConnectionFactory.Create('user', 'password', 'url') do
  begin
    Conn := CreateConnection;
    Conn.Start;
    Session := Conn.CreateSession;
    Destination := Session.GetQueue('subject');
    P := Session.CreateProducer(Destination);
    Message := Session.CreateTextMessage('a');
    P.Send(Message);
    Conn.Stop;
    ReadLn;
  end;


end.

