/*

  Copyright (C) 2003-2005 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.asc.outlookpanel.renderers;

import com.smardec.asc.outlookpanel.OutlookScrollButtonRenderer;

import javax.swing.*;
import java.awt.*;


/**
 * Default <code>OutlookScrollButtonRenderer</code> implementation.
 */
public class DefaultOutlookScrollButtonRenderer extends JButton implements OutlookScrollButtonRenderer {
    private ImageIcon imageIconMouseOver;
    private ImageIcon imageIconMouseOut;

    /**
     * Constructs <code>DefaultOutlookButtonRenderer</code> object.
     */
    public DefaultOutlookScrollButtonRenderer(ImageIcon imageIconMouseOver, ImageIcon imageIconMouseOut) {
        this.imageIconMouseOver = imageIconMouseOver;
        this.imageIconMouseOut = imageIconMouseOut;
        setOpaque(true);
        setFocusPainted(false);
        setBorderPainted(false);
        setBorder(BorderFactory.createEmptyBorder());
        setText("");
    }

    /**
     * Returns the component whose paint() method will render the specified button.
     *
     * @param jOutlookButton the button we're painting
     * @param mouseOver      indicates that the mouse is over the tab header
     * @param mousePressed   indicates that the mouse is pressed on the tab header
     * @return the component whose paint() method will render the specified button.
     */
    public Component getOutlookButtonRendererComponent(JButton jOutlookButton, boolean mouseOver, boolean mousePressed) {
        setSize(jOutlookButton.getSize());
        if (mouseOver)
            setIcon(imageIconMouseOver);
        else
            setIcon(imageIconMouseOut);
        setBackground(new Color(getBackground().getRGB(), false));
        return this;
    }
}
