/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

class CharacterSetUTFE
extends CharacterSet
implements CharacterRepConstants {
    static final int MAXBYTEPERCHAR = 4;
    static int[][] utf8m2utfe;
    static byte[][] utfe2utf8m;

    static {
        int[][] nArrayArray = new int[16][];
        int[] nArray = new int[16];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 55;
        nArray[5] = 45;
        nArray[6] = 46;
        nArray[7] = 47;
        nArray[8] = 22;
        nArray[9] = 5;
        nArray[10] = 21;
        nArray[11] = 11;
        nArray[12] = 12;
        nArray[13] = 13;
        nArray[14] = 14;
        nArray[15] = 15;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31};
        nArrayArray[2] = new int[]{64, 90, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97};
        nArrayArray[3] = new int[]{-16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111};
        nArrayArray[4] = new int[]{124, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42};
        nArrayArray[5] = new int[]{-41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, -83, -32, -67, 95, 109};
        nArrayArray[6] = new int[]{121, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106};
        nArrayArray[7] = new int[]{-105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, -64, 79, -48, -95, 7};
        nArrayArray[8] = new int[]{32, 33, 34, 35, 36, 37, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27};
        nArrayArray[9] = new int[]{48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1};
        nArrayArray[10] = new int[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 81, 82, 83, 84, 85, 86};
        nArrayArray[11] = new int[]{87, 88, 89, 98, 99, 100, 101, 102, 103, 104, 105, 106, 112, 113, 114, 115};
        nArrayArray[12] = new int[]{116, 117, 118, 119, 120, -128, -118, -117, -116, -115, -114, -113, -112, -102, -101, -100};
        nArrayArray[13] = new int[]{-99, -98, -97, -96, -86, -85, -84, -82, -81, -80, -79, -78, -77, -76, -75, -74};
        nArrayArray[14] = new int[]{-73, -72, -71, -70, -69, -68, -66, -65, -54, -53, -52, -51, -50, -49, -38, -37};
        nArrayArray[15] = new int[]{-36, -35, -34, -33, -31, -22, -21, -20, -19, -18, -17, -6, -5, -4, -3, -2};
        utf8m2utfe = nArrayArray;
        byte[][] byArrayArray = new byte[16][];
        byte[] byArray = new byte[16];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = -100;
        byArray[5] = 9;
        byArray[6] = -122;
        byArray[7] = 127;
        byArray[8] = -105;
        byArray[9] = -115;
        byArray[10] = -114;
        byArray[11] = 11;
        byArray[12] = 12;
        byArray[13] = 13;
        byArray[14] = 14;
        byArray[15] = 15;
        byArrayArray[0] = byArray;
        byArrayArray[1] = new byte[]{16, 17, 18, 19, -99, 10, 8, -121, 24, 25, -110, -113, 28, 29, 30, 31};
        byArrayArray[2] = new byte[]{-128, -127, -126, -125, -124, -123, 23, 27, -120, -119, -118, -117, -116, 5, 6, 7};
        byArrayArray[3] = new byte[]{-112, -111, 22, -109, -108, -107, -106, 4, -104, -103, -102, -101, 20, 21, -98, 26};
        byArrayArray[4] = new byte[]{32, -96, -95, -94, -93, -92, -91, -90, -89, -88, -87, 46, 60, 40, 43, 124};
        byArrayArray[5] = new byte[]{38, -86, -85, -84, -83, -82, -81, -80, -79, -78, 33, 36, 42, 41, 59, 94};
        byArrayArray[6] = new byte[]{45, 47, -77, -76, -75, -74, -73, -72, -71, -70, -69, 44, 37, 95, 62, 63};
        byArrayArray[7] = new byte[]{-68, -67, -66, -65, -64, -63, -62, -61, -60, 96, 58, 35, 64, 39, 61, 34};
        byArrayArray[8] = new byte[]{-59, 97, 98, 99, 100, 101, 102, 103, 104, 105, -58, -57, -56, -55, -54, -53};
        byArrayArray[9] = new byte[]{-52, 106, 107, 108, 109, 110, 111, 112, 113, 114, -51, -50, -49, -48, -47, -46};
        byArrayArray[10] = new byte[]{-45, 126, 115, 116, 117, 118, 119, 120, 121, 122, -44, -43, -42, 88, -41, -40};
        byArrayArray[11] = new byte[]{-39, -38, -37, -36, -35, -34, -33, -32, -31, -30, -29, -28, -27, 93, -26, -25};
        byArrayArray[12] = new byte[]{123, 65, 66, 67, 68, 69, 70, 71, 72, 73, -24, -23, -22, -21, -20, -19};
        byArrayArray[13] = new byte[]{13, 74, 75, 76, 77, 78, 79, 80, 81, 82, -18, -17, -16, -15, -14, -13};
        byArrayArray[14] = new byte[]{92, -12, 83, 84, 85, 86, 87, 88, 89, 90, -11, -10, -9, -8, -7, -6};
        byArrayArray[15] = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, -5, -4, -3, -2, -1, -97};
        utfe2utf8m = byArrayArray;
    }

    CharacterSetUTFE(int n2) {
        super(n2);
        this.rep = 3;
    }

    public byte[] convert(String string) throws SQLException {
        int n2 = string.length() * 4;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = string.length();
        int n5 = 0;
        while (n5 < n4) {
            int n6;
            char c2 = string.charAt(n5);
            if (c2 > '\uffff') {
                CharacterSet.failCharacterConversion(this);
            }
            if (c2 <= '\u001f') {
                n6 = c2 | 0x80;
                byArray[n3++] = (byte)utf8m2utfe[this.high(n6)][this.low(n6)];
            } else if (c2 <= '\u007f') {
                byArray[n3++] = (byte)utf8m2utfe[this.high(c2)][this.low(c2)];
            } else if (c2 <= '\u03ff') {
                n6 = (c2 & 0x3E0) >> 5 | 0xC0;
                byArray[n3++] = (byte)utf8m2utfe[this.high(n6)][this.low(n6)];
                n6 = c2 & 0x1F | 0xA0;
                byArray[n3++] = (byte)utf8m2utfe[this.high(n6)][this.low(n6)];
            } else if (c2 <= '\u3fff') {
                n6 = (c2 & 0x3C00) >> 10 | 0xE0;
                byArray[n3++] = (byte)utf8m2utfe[this.high(n6)][this.low(n6)];
                n6 = (c2 & 0x3E0) >> 5 | 0xA0;
                byArray[n3++] = (byte)utf8m2utfe[this.high(n6)][this.low(n6)];
                n6 = c2 & 0x1F | 0xA0;
                byArray[n3++] = (byte)utf8m2utfe[this.high(n6)][this.low(n6)];
            } else {
                n6 = (c2 & 0x8000) >> 15 | 0xF0;
                byArray[n3++] = (byte)utf8m2utfe[this.high(n6)][this.low(n6)];
                n6 = (c2 & 0x7C00) >> 10 | 0xA0;
                byArray[n3++] = (byte)utf8m2utfe[this.high(n6)][this.low(n6)];
                n6 = (c2 & 0x3E0) >> 5 | 0xA0;
                byArray[n3++] = (byte)utf8m2utfe[this.high(n6)][this.low(n6)];
                n6 = c2 & 0x1F | 0xA0;
                byArray[n3++] = (byte)utf8m2utfe[this.high(n6)][this.low(n6)];
            }
            ++n5;
        }
        if (n3 < n2) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            return byArray2;
        }
        return byArray;
    }

    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n2, int n3) throws SQLException {
        byte[] byArray2;
        if (characterSet.rep == 3) {
            byArray2 = CharacterSet.useOrCopy(byArray, n2, n3);
        } else {
            String string = characterSet.toString(byArray, n2, n3);
            byArray2 = this.convert(string);
        }
        return byArray2;
    }

    public byte[] convertWithReplacement(String string) {
        byte[] byArray;
        try {
            byArray = this.convert(string);
        }
        catch (SQLException sQLException) {
            byArray = new byte[]{63, 63, 63};
        }
        return byArray;
    }

    int decode(CharacterWalker characterWalker) throws SQLException {
        byte[] byArray = characterWalker.bytes;
        int n2 = characterWalker.next;
        int n3 = characterWalker.end;
        int n4 = 0;
        if (n2 >= n3) {
            CharacterSet.failUTFConversion();
        }
        byte by = utfe2utf8m[this.high(byArray[n2])][this.low(byArray[n2++])];
        switch (by >> 4 & 0xF) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n4 = by & 0x7F;
                break;
            }
            case 8: 
            case 9: {
                n4 = by & 0x1F;
                break;
            }
            case 12: 
            case 13: {
                by = (byte)(by & 0x1F);
                byte by2 = utfe2utf8m[this.high(byArray[n2])][this.low(byArray[n2++])];
                if ((by2 >> 5 & 7) != 5) {
                    CharacterSet.failCharacterConversion(this);
                }
                n4 = by << 5 | by2 & 0x1F;
                break;
            }
            case 14: {
                byte by3;
                by = (byte)(by & 0xF);
                byte by4 = utfe2utf8m[this.high(byArray[n2])][this.low(byArray[n2++])];
                if ((by4 >> 5 & 7) != 5) {
                    CharacterSet.failCharacterConversion(this);
                }
                if (((by3 = utfe2utf8m[this.high(byArray[n2])][this.low(byArray[n2++])]) >> 5 & 7) != 5) {
                    CharacterSet.failCharacterConversion(this);
                }
                n4 = by << 10 | (by4 & 0x1F) << 5 | by3 & 0x1F;
                break;
            }
            case 15: {
                byte by5;
                byte by6;
                by = (byte)(by & 1);
                byte by7 = utfe2utf8m[this.high(byArray[n2])][this.low(byArray[n2++])];
                if ((by7 >> 5 & 7) != 5) {
                    CharacterSet.failCharacterConversion(this);
                }
                if (((by6 = utfe2utf8m[this.high(byArray[n2])][this.low(byArray[n2++])]) >> 5 & 7) != 5) {
                    CharacterSet.failCharacterConversion(this);
                }
                if (((by5 = utfe2utf8m[this.high(byArray[n2])][this.low(byArray[n2++])]) >> 5 & 7) != 5) {
                    CharacterSet.failCharacterConversion(this);
                }
                n4 = by << 15 | (by7 & 0x1F) << 10 | (by6 & 0x1F) << 5 | by5 & 0x1F;
                break;
            }
            default: {
                CharacterSet.failCharacterConversion(this);
            }
        }
        characterWalker.next = n2;
        return n4;
    }

    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        if (n2 > 65535) {
            CharacterSet.failUTFConversion();
        } else {
            char[] cArray = new char[]{(char)n2};
            if (n2 > 65535) {
                CharacterSet.failCharacterConversion(this);
            }
            if (n2 <= 31) {
                CharacterSet.need(characterBuffer, 1);
                int n3 = n2 | 0x80;
                characterBuffer.bytes[characterBuffer.next++] = (byte)utf8m2utfe[this.high(n3)][this.low(n3)];
            } else if (n2 <= 127) {
                CharacterSet.need(characterBuffer, 1);
                characterBuffer.bytes[characterBuffer.next++] = (byte)utf8m2utfe[this.high(n2)][this.low(n2)];
            } else if (n2 <= 1023) {
                CharacterSet.need(characterBuffer, 2);
                int n4 = (n2 & 0x3E0) >> 5 | 0xC0;
                characterBuffer.bytes[characterBuffer.next++] = (byte)utf8m2utfe[this.high(n4)][this.low(n4)];
                n4 = n2 & 0x1F | 0xA0;
                characterBuffer.bytes[characterBuffer.next++] = (byte)utf8m2utfe[this.high(n4)][this.low(n4)];
            } else if (n2 <= 16383) {
                CharacterSet.need(characterBuffer, 3);
                int n5 = (n2 & 0x3C00) >> 10 | 0xE0;
                characterBuffer.bytes[characterBuffer.next++] = (byte)utf8m2utfe[this.high(n5)][this.low(n5)];
                n5 = (n2 & 0x3E0) >> 5 | 0xA0;
                characterBuffer.bytes[characterBuffer.next++] = (byte)utf8m2utfe[this.high(n5)][this.low(n5)];
                n5 = n2 & 0x1F | 0xA0;
                characterBuffer.bytes[characterBuffer.next++] = (byte)utf8m2utfe[this.high(n5)][this.low(n5)];
            } else {
                CharacterSet.need(characterBuffer, 4);
                int n6 = (n2 & 0x8000) >> 15 | 0xF0;
                characterBuffer.bytes[characterBuffer.next++] = (byte)utf8m2utfe[this.high(n6)][this.low(n6)];
                n6 = (n2 & 0x7C00) >> 10 | 0xA0;
                characterBuffer.bytes[characterBuffer.next++] = (byte)utf8m2utfe[this.high(n6)][this.low(n6)];
                n6 = (n2 & 0x3E0) >> 5 | 0xA0;
                characterBuffer.bytes[characterBuffer.next++] = (byte)utf8m2utfe[this.high(n6)][this.low(n6)];
                n6 = n2 & 0x1F | 0xA0;
                characterBuffer.bytes[characterBuffer.next++] = (byte)utf8m2utfe[this.high(n6)][this.low(n6)];
            }
        }
    }

    private int high(int n2) {
        return n2 >> 4 & 0xF;
    }

    public boolean isConvertibleFrom(CharacterSet characterSet) {
        boolean bl = characterSet.rep <= 1024;
        return bl;
    }

    public boolean isLossyFrom(CharacterSet characterSet) {
        return characterSet.isUnicode() ^ true;
    }

    public boolean isUnicode() {
        return true;
    }

    private int low(int n2) {
        return n2 & 0xF;
    }

    public String toString(byte[] byArray, int n2, int n3) throws SQLException {
        return this.toStringWithReplacement(byArray, n2, n3);
    }

    public String toStringWithReplacement(byte[] byArray, int n2, int n3) {
        char[] cArray = new char[n3];
        int n4 = n2;
        int n5 = n2 + n3;
        int n6 = 0;
        try {
            while (n4 < n5) {
                byte by = utfe2utf8m[this.high(byArray[n4])][this.low(byArray[n4++])];
                switch (by >> 4 & 0xF) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        cArray[n6++] = (char)(by & 0x7F);
                        break;
                    }
                    case 8: 
                    case 9: {
                        cArray[n6++] = (char)(by & 0x1F);
                        break;
                    }
                    case 12: 
                    case 13: {
                        by = (byte)(by & 0x1F);
                        byte by2 = utfe2utf8m[this.high(byArray[n4])][this.low(byArray[n4++])];
                        if ((by2 >> 5 & 7) != 5) {
                            CharacterSet.failCharacterConversion(this);
                        }
                        cArray[n6++] = (char)(by << 5 | by2 & 0x1F);
                        break;
                    }
                    case 14: {
                        byte by3;
                        by = (byte)(by & 0xF);
                        byte by2 = utfe2utf8m[this.high(byArray[n4])][this.low(byArray[n4++])];
                        if ((by2 >> 5 & 7) != 5) {
                            CharacterSet.failCharacterConversion(this);
                        }
                        if (((by3 = utfe2utf8m[this.high(byArray[n4])][this.low(byArray[n4++])]) >> 5 & 7) != 5) {
                            CharacterSet.failCharacterConversion(this);
                        }
                        cArray[n6++] = (char)(by << 10 | (by2 & 0x1F) << 5 | by3 & 0x1F);
                        break;
                    }
                    case 15: {
                        byte by4;
                        byte by3;
                        by = (byte)(by & 1);
                        byte by2 = utfe2utf8m[this.high(byArray[n4])][this.low(byArray[n4++])];
                        if ((by2 >> 5 & 7) != 5) {
                            CharacterSet.failCharacterConversion(this);
                        }
                        if (((by3 = utfe2utf8m[this.high(byArray[n4])][this.low(byArray[n4++])]) >> 5 & 7) != 5) {
                            CharacterSet.failCharacterConversion(this);
                        }
                        if (((by4 = utfe2utf8m[this.high(byArray[n4])][this.low(byArray[n4++])]) >> 5 & 7) != 5) {
                            CharacterSet.failCharacterConversion(this);
                        }
                        cArray[n6++] = (char)(by << 15 | (by2 & 0x1F) << 10 | (by3 & 0x1F) << 5 | by4 & 0x1F);
                        break;
                    }
                    default: {
                        CharacterSet.failCharacterConversion(this);
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            cArray = new char[]{'?', '?', '?'};
        }
        return new String(cArray, 0, n6);
    }
}

