/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.BlobDBAccess;
import oracle.sql.DatumWithConnection;

public class BLOB
extends DatumWithConnection
implements Blob {
    public static final int MAX_CHUNK_SIZE = 32768;
    public static final int DURATION_SESSION = 1;
    public static final int DURATION_CALL = 2;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    BlobDBAccess m_dbaccess;
    int m_dbChunkSize;

    protected BLOB() {
    }

    public BLOB(oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        this(oracleConnection, null);
    }

    public BLOB(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray) throws SQLException {
        super(byArray);
        DatumWithConnection.assertNotNull(oracleConnection);
        this.setPhysicalConnectionOf(oracleConnection);
        this.m_dbaccess = this.getPhysicalConnection().createBlobDBAccess();
        this.m_dbChunkSize = -1;
    }

    public long length() throws SQLException {
        return this.getDBAccess().length(this);
    }

    public byte[] getBytes(long l2, int n2) throws SQLException {
        if (n2 < 0 || l2 < 1L) {
            DBError.throwSqlException(68, "getBytes()");
        }
        byte[] byArray = null;
        if (n2 == 0) {
            byArray = new byte[]{};
        } else {
            long l3 = 0L;
            byte[] byArray2 = new byte[n2];
            l3 = this.getBytes(l2, n2, byArray2);
            if (l3 > 0L) {
                if (l3 == (long)n2) {
                    byArray = byArray2;
                } else {
                    byArray = new byte[(int)l3];
                    System.arraycopy(byArray2, 0, byArray, 0, (int)l3);
                }
            }
        }
        return byArray;
    }

    public InputStream getBinaryStream() throws SQLException {
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), 0L);
    }

    public long position(byte[] byArray, long l2) throws SQLException {
        return this.getDBAccess().position(this, byArray, l2);
    }

    public long position(Blob blob, long l2) throws SQLException {
        return this.getDBAccess().position(this, (BLOB)blob, l2);
    }

    public int getBytes(long l2, int n2, byte[] byArray) throws SQLException {
        return this.getDBAccess().getBytes(this, l2, n2, byArray);
    }

    public int putBytes(long l2, byte[] byArray) throws SQLException {
        return this.getDBAccess().putBytes(this, l2, byArray, byArray != null ? byArray.length : 0);
    }

    public int putBytes(long l2, byte[] byArray, int n2) throws SQLException {
        return this.getDBAccess().putBytes(this, l2, byArray, n2);
    }

    public OutputStream getBinaryOutputStream() throws SQLException {
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), 0L);
    }

    public byte[] getLocator() {
        return this.getBytes();
    }

    public void setLocator(byte[] byArray) {
        this.setBytes(byArray);
    }

    public int getChunkSize() throws SQLException {
        if (this.m_dbChunkSize <= 0) {
            this.m_dbChunkSize = this.getDBAccess().getChunkSize(this);
        }
        return this.m_dbChunkSize;
    }

    public int getBufferSize() throws SQLException {
        int n2;
        int n3 = n2 = this.getChunkSize();
        n3 = n2 >= 32768 || n2 <= 0 ? 32768 : 32768 / n2 * n2;
        return n3;
    }

    public static BLOB empty_lob() throws SQLException {
        byte[] byArray = new byte[86];
        byArray[1] = 84;
        byArray[5] = 24;
        BLOB bLOB = new BLOB();
        bLOB.setShareBytes(byArray);
        return bLOB;
    }

    public boolean isEmptyLob() throws SQLException {
        boolean bl = (this.shareBytes()[5] & 0x10) != 0;
        return bl;
    }

    public OutputStream getBinaryOutputStream(long l2) throws SQLException {
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), l2);
    }

    public InputStream getBinaryStream(long l2) throws SQLException {
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), l2);
    }

    public void trim(long l2) throws SQLException {
        if (l2 < 0L) {
            DBError.throwSqlException(68);
        }
        this.getDBAccess().trim(this, l2);
    }

    public static BLOB createTemporary(Connection connection, boolean bl, int n2) throws SQLException {
        if (connection == null || n2 != 1 && n2 != 2) {
            DBError.throwSqlException(68);
        }
        oracle.jdbc.internal.OracleConnection oracleConnection = OracleConnection.physicalConnectionWithin(connection);
        return BLOB.getDBAccess(oracleConnection).createTemporaryBlob(oracleConnection, bl, n2);
    }

    public static void freeTemporary(BLOB bLOB) throws SQLException {
        if (bLOB == null) {
            return;
        }
        bLOB.freeTemporary();
    }

    public static boolean isTemporary(BLOB bLOB) throws SQLException {
        if (bLOB == null) {
            return false;
        }
        return bLOB.isTemporary();
    }

    public void freeTemporary() throws SQLException {
        this.getDBAccess().freeTemporary(this);
    }

    public boolean isTemporary() throws SQLException {
        return this.getDBAccess().isTemporary(this);
    }

    public void open(int n2) throws SQLException {
        this.getDBAccess().open(this, n2);
    }

    public void close() throws SQLException {
        this.getDBAccess().close(this);
    }

    public boolean isOpen() throws SQLException {
        return this.getDBAccess().isOpen(this);
    }

    public int setBytes(long l2, byte[] byArray) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public int setBytes(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public OutputStream setBinaryStream(long l2) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public void truncate(long l2) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public Object toJdbc() throws SQLException {
        return this;
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    public Reader characterStreamValue() throws SQLException {
        BlobDBAccess blobDBAccess = this.getDBAccess();
        this.getInternalConnection();
        return blobDBAccess.newConversionReader(this, 8);
    }

    public InputStream asciiStreamValue() throws SQLException {
        BlobDBAccess blobDBAccess = this.getDBAccess();
        this.getInternalConnection();
        return blobDBAccess.newConversionInputStream(this, 2);
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getBinaryStream();
    }

    public Object makeJdbcArray(int n2) {
        return new BLOB[n2];
    }

    public BlobDBAccess getDBAccess() throws SQLException {
        if (this.m_dbaccess == null) {
            if (this.isEmptyLob()) {
                DBError.throwSqlException(98);
            }
            this.m_dbaccess = this.getInternalConnection().createBlobDBAccess();
        }
        return this.m_dbaccess;
    }

    public static BlobDBAccess getDBAccess(Connection connection) throws SQLException {
        return OracleConnection.physicalConnectionWithin(connection).createBlobDBAccess();
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }

    public OracleConnection getConnection() throws SQLException {
        return super.getConnection();
    }
}

