/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.sql.SQLException;
import oracle.gss.util.NLSCharacter;
import oracle.jdbc.dbaccess.DBConversion;

public class TTCConversion
extends DBConversion {
    private int isServerCSMultiByte;
    private short m_oraVersion;
    private int m_c2sNlsRatio;
    private int m_s2cNlsRatio;
    private int m_sMaxCharSize;

    public TTCConversion(short s2, short s3, short s4, short s5) throws SQLException {
        super(s2, s3, s5);
        this.m_oraVersion = s4;
        this.m_c2sNlsRatio = NLSCharacter.getRatio(s2, s3);
        this.m_s2cNlsRatio = NLSCharacter.getRatio(s3, s2);
        this.m_sMaxCharSize = NLSCharacter.getRatio(s2, 1);
        this.isServerCSMultiByte = NLSCharacter.getRatio(s2, 1);
    }

    public short getOraVersion() {
        return this.m_oraVersion;
    }

    public boolean isServerMultiByte() {
        return this.isServerCSMultiByte != 1;
    }

    public int getNLSRATIO() {
        return this.m_c2sNlsRatio;
    }

    public int getServer2ClientNlsRatio() {
        return this.m_s2cNlsRatio;
    }

    public int getMaxCharSize() {
        return this.m_sMaxCharSize;
    }

    public static short findAccessCharSet(short n2, short s2) {
        int n3 = 0;
        switch (n2) {
            case 1: 
            case 31: 
            case 873: {
                n3 = n2;
                break;
            }
            default: {
                n3 = s2 >= 8030 ? 871 : 870;
            }
        }
        return (short)n3;
    }

    public byte[] StringToNetworkRep(String string) throws SQLException {
        return this.StringToCharBytes(string);
    }
}

