/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import javax.sql.PooledConnection;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.pool.OracleConnectionCacheImpl;
import oracle.jdbc.pool.OraclePooledConnection;

public class OracleConnectionCacheTimeOutThread
extends Thread {
    private OracleConnectionCacheImpl m_occi = null;

    OracleConnectionCacheTimeOutThread(OracleConnectionCacheImpl oracleConnectionCacheImpl) throws SQLException {
        this.m_occi = oracleConnectionCacheImpl;
    }

    public void run() {
        long l2 = 0L;
        long l3 = 0L;
        boolean bl = true;
        try {
            while (bl) {
                l2 = this.m_occi.getCacheTimeToLiveTimeout();
                if (l2 > 0L) {
                    this.runTimeToLiveTimeOut(l2);
                }
                if ((l3 = this.m_occi.getCacheInactivityTimeout()) > 0L) {
                    this.runInactivityTimeOut(l3);
                }
                Thread.sleep(this.m_occi.getThreadWakeUpInterval() * 1000L);
                if (this.m_occi.m_cache != null && (l2 > 0L || l3 > 0L)) continue;
                bl = false;
            }
        }
        catch (SQLException sQLException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void runTimeToLiveTimeOut(long l2) throws SQLException {
        long l3 = 0L;
        long l4 = 0L;
        int n2 = 0;
        PooledConnection pooledConnection = null;
        n2 = this.m_occi.getActiveSize();
        if (n2 > 0) {
            Enumeration enumeration = this.m_occi.m_activeCache.keys();
            while (enumeration.hasMoreElements()) {
                pooledConnection = (PooledConnection)enumeration.nextElement();
                Connection connection = ((OraclePooledConnection)pooledConnection).getLogicalHandle();
                if (connection != null) {
                    l4 = ((OracleConnection)connection).getStartTime();
                }
                if ((l3 = System.currentTimeMillis()) - l4 <= l2 * 1000L) continue;
                try {
                    ((OracleConnection)connection).cancel();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                connection.close();
            }
        }
    }

    public void runInactivityTimeOut(long l2) throws SQLException {
        long l3 = 0L;
        long l4 = 0L;
        PooledConnection pooledConnection = null;
        Enumeration enumeration = this.m_occi.m_cache.elements();
        while (enumeration.hasMoreElements()) {
            pooledConnection = (PooledConnection)enumeration.nextElement();
            l3 = ((OraclePooledConnection)pooledConnection).getLastAccessedTime();
            l4 = System.currentTimeMillis();
            if (l4 - l3 <= l2 * 1000L) continue;
            this.m_occi.closeSingleConnection(pooledConnection);
        }
    }
}

