/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.DATE;
import oracle.sql.Datum;

public class OracleTypeDATE
extends OracleType
implements Serializable {
    static final long serialVersionUID = -5858803341118747965L;

    public OracleTypeDATE() {
    }

    public OracleTypeDATE(int n2) {
        super(n2);
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        DATE dATE = null;
        if (object != null) {
            try {
                dATE = object instanceof DATE ? (DATE)object : new DATE(object);
            }
            catch (SQLException sQLException) {
                DBError.check_error(59, object);
            }
        }
        return dATE;
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof char[][]) {
                char[][] cArray = (char[][])object;
                int n3 = (int)(n2 == -1 ? (long)cArray.length : Math.min((long)cArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n3];
                int n4 = 0;
                while (n4 < n3) {
                    datumArray[n4] = this.toDatum(new String(cArray[(int)l2 + n4 - 1]), oracleConnection);
                    ++n4;
                }
            } else {
                if (object instanceof Object[]) {
                    return super.toDatumArray(object, oracleConnection, l2, n2);
                }
                DBError.check_error(59, object);
            }
        }
        return datumArray;
    }

    public int getTypeCode() {
        return 91;
    }

    public int getSizeLDS(byte[] byArray) {
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size(byArray, 11);
            this.align_for_lds = Util.FDO_get_align(byArray, 11);
        }
        return this.size_for_lds;
    }

    public int getAlignLDS(byte[] byArray) {
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size(byArray, 11);
            this.align_for_lds = Util.FDO_get_align(byArray, 11);
        }
        return this.align_for_lds;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n2, int n3, Map map) throws SQLException {
        switch (n2) {
            case 1: {
                if (unpickleContext.is_null(this.null_offset)) {
                    return null;
                }
                unpickleContext.skip_to(unpickleContext.m_ldsOffsets[this.lds_offset]);
                break;
            }
            case 2: {
                if ((unpickleContext.read_byte() & 1) == 1) {
                    unpickleContext.skip_bytes(8);
                    return null;
                }
            }
            case 3: {
                break;
            }
            default: {
                DBError.throwSqlException(1, "format=" + n2);
            }
        }
        if (n3 == 9) {
            unpickleContext.skip_bytes(8);
            return null;
        }
        byte[] byArray = unpickleContext.image();
        int n4 = unpickleContext.absolute_offset();
        byte[] byArray2 = new byte[7];
        int n5 = unpickleContext.m_bigEndian ? (byArray[n4] & 0xFF) * 256 + (byArray[n4 + 1] & 0xFF) : (byArray[n4 + 1] & 0xFF) * 256 + (byArray[n4] & 0xFF);
        if (n5 < 0) {
            byArray2[0] = (byte)(100 - -n5 / 100);
            byArray2[1] = (byte)(100 - -n5 % 100);
        } else {
            byArray2[0] = (byte)(n5 / 100 + 100);
            byArray2[1] = (byte)(n5 % 100 + 100);
        }
        byArray2[2] = byArray[n4 + 2];
        byArray2[3] = byArray[n4 + 3];
        byArray2[4] = (byte)(byArray[n4 + 4] + 1);
        byArray2[5] = (byte)(byArray[n4 + 5] + 1);
        byArray2[6] = (byte)(byArray[n4 + 6] + 1);
        unpickleContext.skip_bytes(8);
        return this.toObject(byArray2, n3, map);
    }

    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        if (n2 == 1) {
            return new DATE(byArray);
        }
        if (n2 == 2) {
            return DATE.toTimestamp(byArray);
        }
        if (n2 == 3) {
            return byArray;
        }
        DBError.throwSqlException(59, byArray);
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }
}

