/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.ScrollableResultSet;
import oracle.jdbc.driver.SensitiveScrollableResultSet;
import oracle.jdbc.driver.UpdatableResultSet;

class ResultSetUtil {
    static final int[][] s_allRsetTypes = new int[][]{{0, 0}, {1003, 1007}, {1003, 1008}, {1004, 1007}, {1004, 1008}, {1005, 1007}, {1005, 1008}};

    ResultSetUtil() {
    }

    static OracleResultSet createScrollResultSet(ScrollRsetStatement scrollRsetStatement, OracleResultSet oracleResultSet, int n2) throws SQLException {
        switch (n2) {
            case 1: {
                return oracleResultSet;
            }
            case 2: {
                return new UpdatableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, ResultSetUtil.getScrollType(n2), ResultSetUtil.getUpdateConcurrency(n2));
            }
            case 3: {
                return new ScrollableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, ResultSetUtil.getScrollType(n2), ResultSetUtil.getUpdateConcurrency(n2));
            }
            case 4: {
                ScrollableResultSet scrollableResultSet = new ScrollableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, ResultSetUtil.getScrollType(n2), ResultSetUtil.getUpdateConcurrency(n2));
                return new UpdatableResultSet(scrollRsetStatement, scrollableResultSet, ResultSetUtil.getScrollType(n2), ResultSetUtil.getUpdateConcurrency(n2));
            }
            case 5: {
                return new SensitiveScrollableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, ResultSetUtil.getScrollType(n2), ResultSetUtil.getUpdateConcurrency(n2));
            }
            case 6: {
                SensitiveScrollableResultSet sensitiveScrollableResultSet = new SensitiveScrollableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, ResultSetUtil.getScrollType(n2), ResultSetUtil.getUpdateConcurrency(n2));
                return new UpdatableResultSet(scrollRsetStatement, sensitiveScrollableResultSet, ResultSetUtil.getScrollType(n2), ResultSetUtil.getUpdateConcurrency(n2));
            }
        }
        DBError.check_error(23, null);
        return null;
    }

    static String addIdentifierToSql(String string) throws SQLException {
        String string2 = string.toLowerCase();
        int n2 = string2.indexOf("select");
        if (n2 == -1) {
            DBError.throwSqlException(88);
        }
        return "select rowid," + string.substring(n2 + "select".length());
    }

    static String removeForUpdate(String string) throws SQLException {
        String string2 = string.toLowerCase();
        String string3 = string;
        int n2 = string3.length();
        int n3 = 0;
        char c2 = '\u0000';
        int n4 = 0;
        String string4 = null;
        n3 = string2.lastIndexOf("for");
        if (n3 > 0) {
            n4 = n3 + 3;
            while (string3.charAt(n4) != '\uffffffff') {
                c2 = string3.charAt(n4);
                if (c2 != ' ') break;
                ++n4;
            }
            string4 = string3.substring(n4, n4 + 6);
            if (n4 < n2 - 5 && string4.equalsIgnoreCase("update")) {
                string3 = string3.substring(0, n3);
                return string3;
            }
            return string;
        }
        return string;
    }

    static int getScrollType(int n2) {
        return s_allRsetTypes[n2][0];
    }

    static int getUpdateConcurrency(int n2) {
        return s_allRsetTypes[n2][1];
    }

    static int getRsetTypeCode(int n2, int n3) throws SQLException {
        int n4 = 0;
        while (n4 < s_allRsetTypes.length) {
            if (s_allRsetTypes[n4][0] == n2 && s_allRsetTypes[n4][1] == n3) {
                return n4;
            }
            ++n4;
        }
        DBError.throwSqlException(68);
        return 0;
    }

    public static boolean needIdentifier(int n2) throws SQLException {
        return n2 != 1 && n2 != 3;
    }

    public static boolean needIdentifier(int n2, int n3) throws SQLException {
        return ResultSetUtil.needIdentifier(ResultSetUtil.getRsetTypeCode(n2, n3));
    }

    public static boolean needCache(int n2) throws SQLException {
        return n2 >= 3;
    }

    public static boolean needCache(int n2, int n3) throws SQLException {
        return ResultSetUtil.needCache(ResultSetUtil.getRsetTypeCode(n2, n3));
    }

    public static boolean supportRefreshRow(int n2) throws SQLException {
        return n2 >= 4;
    }

    public static boolean supportRefreshRow(int n2, int n3) throws SQLException {
        return ResultSetUtil.supportRefreshRow(ResultSetUtil.getRsetTypeCode(n2, n3));
    }
}

