/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class OracleResultSetImpl
extends BaseResultSet {
    OracleConnection connection;
    OracleStatement statement;
    boolean closed;
    boolean explicitly_closed;
    private boolean m_emptyRset;

    OracleResultSetImpl(OracleConnection oracleConnection, OracleStatement oracleStatement) throws SQLException {
        this.connection = oracleConnection;
        this.statement = oracleStatement;
        this.close_statement_on_close = false;
        this.closed = false;
        this.explicitly_closed = false;
        this.m_emptyRset = false;
    }

    public synchronized void close() throws SQLException {
        this.internal_close();
        if (this.close_statement_on_close) {
            try {
                this.statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.explicitly_closed = true;
    }

    public synchronized boolean wasNull() throws SQLException {
        return this.statement.wasNullValue();
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        if (this.explicitly_closed) {
            DBError.check_error(10, "getMetaData");
        }
        if (this.statement.closed) {
            DBError.check_error(9, "getMetaData");
        }
        return new OracleResultSetMetaData(this.connection, this.statement);
    }

    public synchronized Statement getStatement() throws SQLException {
        return this.statement;
    }

    public synchronized boolean next() throws SQLException {
        if (this.explicitly_closed) {
            DBError.check_error(10, "next");
        }
        if (this.statement.connection == null || this.statement.connection.closed) {
            DBError.check_error(8, "next");
        }
        if (this.statement.closed) {
            DBError.check_error(9, "next");
        }
        if (this.closed) {
            return false;
        }
        ++this.statement.current_row;
        ++this.statement.total_rows_visited;
        if (this.statement.max_rows != 0 && this.statement.total_rows_visited > this.statement.max_rows) {
            this.internal_close();
            return false;
        }
        if (this.statement.current_row >= this.statement.valid_rows) {
            try {
                if (this.statement.got_last_batch) {
                    this.internal_close();
                    return false;
                }
                this.statement.check_row_prefetch_changed();
                this.prepare_for_new_row();
                this.statement.connection.needLine();
                this.statement.valid_rows = this.connection.db_access.fetch(this.statement.dbstmt, this.statement.defines, this.statement.row_prefetch);
                this.statement.fetchedFirstColumns();
                if (this.statement.valid_rows == 0) {
                    this.internal_close();
                    return false;
                }
                this.statement.current_row = 0;
                this.statement.checkValidRowsStatus();
                return true;
            }
            catch (IOException iOException) {
                DBError.check_error(iOException);
            }
        }
        return true;
    }

    public boolean isBeforeFirst() throws SQLException {
        return !this.isEmptyResultSet() && this.statement.current_row == -1 && !this.closed;
    }

    public boolean isAfterLast() throws SQLException {
        return !this.isEmptyResultSet() && this.closed;
    }

    public boolean isFirst() throws SQLException {
        return this.getRow() == 1;
    }

    public boolean isLast() throws SQLException {
        DBError.throwSqlException(75, "isLast");
        return false;
    }

    public int getRow() throws SQLException {
        return this.statement.total_rows_visited;
    }

    public synchronized String getString(int n2) throws SQLException {
        return this.statement.getStringValue(true, n2);
    }

    public synchronized boolean getBoolean(int n2) throws SQLException {
        return this.statement.getBooleanValue(true, n2);
    }

    public synchronized byte getByte(int n2) throws SQLException {
        return this.statement.getByteValue(true, n2);
    }

    public synchronized short getShort(int n2) throws SQLException {
        return this.statement.getShortValue(true, n2);
    }

    public synchronized int getInt(int n2) throws SQLException {
        return this.statement.getIntValue(true, n2);
    }

    public synchronized long getLong(int n2) throws SQLException {
        return this.statement.getLongValue(true, n2);
    }

    public synchronized float getFloat(int n2) throws SQLException {
        return this.statement.getFloatValue(true, n2);
    }

    public synchronized double getDouble(int n2) throws SQLException {
        return this.statement.getDoubleValue(true, n2);
    }

    public synchronized BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        return this.statement.getBigDecimalValue(true, n2, n3);
    }

    public synchronized byte[] getBytes(int n2) throws SQLException {
        return this.statement.getBytesValue(true, n2);
    }

    public synchronized Date getDate(int n2) throws SQLException {
        return this.statement.getDateValue(true, n2);
    }

    public synchronized Time getTime(int n2) throws SQLException {
        return this.statement.getTimeValue(true, n2);
    }

    public synchronized Timestamp getTimestamp(int n2) throws SQLException {
        return this.statement.getTimestampValue(true, n2);
    }

    public synchronized InputStream getAsciiStream(int n2) throws SQLException {
        return this.statement.getAsciiStreamValue(true, n2);
    }

    public synchronized InputStream getUnicodeStream(int n2) throws SQLException {
        return this.statement.getUnicodeStreamValue(true, n2);
    }

    public synchronized InputStream getBinaryStream(int n2) throws SQLException {
        return this.statement.getBinaryStreamValue(true, n2);
    }

    public synchronized Object getObject(int n2) throws SQLException {
        return this.statement.getObjectValue(true, n2);
    }

    public synchronized ResultSet getCursor(int n2) throws SQLException {
        return this.statement.getCursorValue(true, n2);
    }

    public synchronized Datum getOracleObject(int n2) throws SQLException {
        return this.statement.getOracleObjectValue(true, n2);
    }

    public synchronized ROWID getROWID(int n2) throws SQLException {
        return this.statement.getROWIDValue(true, n2);
    }

    public synchronized NUMBER getNUMBER(int n2) throws SQLException {
        return this.statement.getNUMBERValue(true, n2);
    }

    public synchronized DATE getDATE(int n2) throws SQLException {
        return this.statement.getDATEValue(true, n2);
    }

    public synchronized ARRAY getARRAY(int n2) throws SQLException {
        return this.statement.getARRAYValue(true, n2);
    }

    public synchronized STRUCT getSTRUCT(int n2) throws SQLException {
        return this.statement.getSTRUCTValue(true, n2);
    }

    public synchronized OPAQUE getOPAQUE(int n2) throws SQLException {
        return this.statement.getOPAQUEValue(true, n2);
    }

    public synchronized REF getREF(int n2) throws SQLException {
        return this.statement.getREFValue(true, n2);
    }

    public synchronized CHAR getCHAR(int n2) throws SQLException {
        return this.statement.getCHARValue(true, n2);
    }

    public synchronized RAW getRAW(int n2) throws SQLException {
        return this.statement.getRAWValue(true, n2);
    }

    public synchronized BLOB getBLOB(int n2) throws SQLException {
        return this.statement.getBLOBValue(true, n2);
    }

    public synchronized CLOB getCLOB(int n2) throws SQLException {
        return this.statement.getCLOBValue(true, n2);
    }

    public synchronized BFILE getBFILE(int n2) throws SQLException {
        return this.statement.getBFILEValue(true, n2);
    }

    public synchronized BFILE getBfile(int n2) throws SQLException {
        return this.getBFILE(n2);
    }

    public synchronized CustomDatum getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        return this.statement.getCustomDatumValue(true, n2, customDatumFactory);
    }

    public synchronized ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        return this.statement.getORADataValue(true, n2, oRADataFactory);
    }

    public synchronized Object getObject(int n2, Map map) throws SQLException {
        return this.statement.getObjectValue(true, n2, map);
    }

    public synchronized Ref getRef(int n2) throws SQLException {
        return this.getREF(n2);
    }

    public synchronized Blob getBlob(int n2) throws SQLException {
        return this.getBLOB(n2);
    }

    public synchronized Clob getClob(int n2) throws SQLException {
        return this.getCLOB(n2);
    }

    public synchronized Array getArray(int n2) throws SQLException {
        return this.getARRAY(n2);
    }

    public synchronized Reader getCharacterStream(int n2) throws SQLException {
        return this.statement.getCharacterStreamValue(true, n2);
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        return this.statement.getBigDecimalValue(true, n2, 0);
    }

    public Date getDate(int n2, Calendar calendar) throws SQLException {
        return this.statement.getDateValue(true, n2, calendar);
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        return this.statement.getTimeValue(true, n2, calendar);
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        return this.statement.getTimestampValue(true, n2, calendar);
    }

    public INTERVALYM getINTERVALYM(int n2) throws SQLException {
        return this.statement.getINTERVALYMValue(true, n2);
    }

    public TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        return this.statement.getTIMESTAMPValue(true, n2);
    }

    public TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        return this.statement.getTIMESTAMPTZValue(true, n2);
    }

    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        return this.statement.getTIMESTAMPLTZValue(true, n2);
    }

    public void setFetchSize(int n2) throws SQLException {
        this.statement.setPrefetchInternal(n2, false, false);
    }

    public int getFetchSize() throws SQLException {
        return this.statement.getPrefetchInternal(false);
    }

    void internal_close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.statement.got_last_batch && this.statement.valid_rows == 0) {
            this.m_emptyRset = true;
        }
        try {
            this.statement.connection.needLine();
            this.statement.connection.db_access.closeQuery(this.statement.dbstmt);
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.statement.end_of_result_set();
    }

    void prepare_for_new_row() throws SQLException {
        if (this.statement.streams != null) {
            try {
                this.statement.streams.close();
            }
            catch (IOException iOException) {
                DBError.check_error(iOException);
            }
        }
        this.clearWarnings();
    }

    public synchronized int findColumn(String string) throws SQLException {
        return this.statement.get_column_index(string);
    }

    boolean isEmptyResultSet() {
        return this.m_emptyRset || !this.m_emptyRset && this.statement.got_last_batch && this.statement.valid_rows == 0;
    }

    int getValidRows() {
        return this.statement.valid_rows;
    }
}

