/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dbaccess;

import java.sql.SQLException;
import java.util.Vector;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBItem;

public class DBData {
    private boolean m_dynamic = false;
    private DBItem[] m_items = null;
    private Vector m_vector = null;

    public DBData(int n2) {
        this.m_dynamic = false;
        this.m_items = new DBItem[n2];
    }

    public void setItem(int n2, DBItem dBItem) throws SQLException {
        if (this.m_dynamic) {
            DBError.throwSqlException(89);
        }
        this.checkItemNumber(n2);
        this.m_items[n2] = dBItem;
    }

    public DBData() {
        this.m_dynamic = true;
        this.m_vector = new Vector();
    }

    public int addItem(DBItem dBItem) throws SQLException {
        if (!this.m_dynamic) {
            DBError.throwSqlException(89);
        }
        this.m_vector.addElement(dBItem);
        return this.m_vector.size();
    }

    public void removeFirstItem() throws SQLException {
        if (!this.m_dynamic) {
            DBError.throwSqlException(89);
        }
        this.m_vector.removeElementAt(0);
    }

    public final boolean isDynamic() {
        return this.m_dynamic;
    }

    public final void clearItems() {
        if (this.m_dynamic) {
            if (this.m_vector != null) {
                this.m_vector.removeAllElements();
            }
        } else if (this.m_items != null) {
            int n2 = 0;
            while (n2 < this.m_items.length) {
                this.m_items[n2] = null;
                ++n2;
            }
        }
    }

    public final void cleanup() {
        this.clearItems();
        this.m_vector = null;
        this.m_items = null;
    }

    public int getNItems() {
        return this.m_dynamic ? this.m_vector.size() : this.m_items.length;
    }

    public DBItem getItem(int n2) throws SQLException {
        DBItem dBItem = null;
        if (this.m_dynamic) {
            if (n2 < 0) {
                DBError.throwSqlException(46);
            } else {
                dBItem = n2 >= this.getNItems() ? null : (DBItem)this.m_vector.elementAt(n2);
            }
        } else {
            this.checkItemNumber(n2);
            dBItem = this.m_items[n2];
        }
        return dBItem;
    }

    private void checkItemNumber(int n2) throws SQLException {
        if (n2 < 0 || n2 >= this.getNItems()) {
            DBError.throwSqlException(46);
        }
    }

    public void clearItem(int n2) {
        if (this.m_dynamic && this.m_vector != null && n2 < this.m_vector.size()) {
            this.m_vector.removeElementAt(n2);
        }
        if (this.m_items == null && n2 >= this.m_items.length) {
            return;
        }
        this.m_items[n2] = null;
    }
}

