/*
 * Decompiled with CFR 0.152.
 */
package oracle.gss.util.CharConvBuilder;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.StreamTokenizer;
import oracle.gss.util.CharConvBuilder.TokenParser;

public class CharDataParser
extends TokenParser {
    private static final boolean DEBUG = false;
    static final int DEFAULT_UCS_REPLACEMENT = 65533;
    String m_charSetName = null;
    int m_charSetId = 0;
    int m_oraCharReplacement = 0;
    int m_defaultMultibyteReplacementChar = 0;
    boolean m_haveExtraUnicodeMapping = false;

    CharDataParser() {
    }

    CharDataParser(FileInputStream fileInputStream) throws IOException {
        this();
        int n2;
        StreamTokenizer streamTokenizer = TokenParser.getTokenizer(fileInputStream);
        boolean bl = false;
        int n3 = 0;
        String string = "";
        int n4 = 1;
        while ((n2 = streamTokenizer.nextToken()) != -1 && !bl) {
            block0 : switch (n3) {
                case 0: 
                case 2: {
                    if (n2 == -3 || n2 == 34) {
                        string = String.valueOf(string) + streamTokenizer.sval;
                        n3 = 1;
                        n4 = 1;
                        break;
                    }
                    n3 = TokenParser.processSyntaxError(streamTokenizer, n4);
                    string = "";
                    break;
                }
                case 1: {
                    switch (n2) {
                        case 95: {
                            string = String.valueOf(string) + (char)n2;
                            n3 = 2;
                            break block0;
                        }
                        case 61: {
                            n3 = 3;
                            break block0;
                        }
                        case -3: {
                            TokenParser.skipToEndOfDelimiter(streamTokenizer, n4);
                            n3 = 0;
                            string = "";
                            break block0;
                        }
                    }
                    n3 = TokenParser.processSyntaxError(streamTokenizer, n4);
                    string = "";
                    break;
                }
                case 3: {
                    switch (n2) {
                        case -3: 
                        case 34: {
                            if (string.compareTo("name") == 0) {
                                this.m_charSetName = streamTokenizer.sval;
                                bl = this.checkAllData();
                            }
                            TokenParser.skipToEol(streamTokenizer);
                            n3 = 0;
                            string = "";
                            break block0;
                        }
                        case -2: {
                            int n5 = (int)streamTokenizer.nval;
                            if (string.compareTo("id") == 0) {
                                this.m_charSetId = n5;
                                bl = this.checkAllData();
                            } else if (string.compareTo("default_replacement_char") == 0) {
                                this.m_oraCharReplacement = n5 == 0 ? TokenParser.getInteger(streamTokenizer) : n5;
                                bl = this.checkAllData();
                            } else if (string.compareTo("default_multibyte_replacement_char") == 0) {
                                this.m_defaultMultibyteReplacementChar = n5 == 0 ? TokenParser.getInteger(streamTokenizer) : n5;
                                bl = this.checkAllData();
                            }
                            TokenParser.skipToEol(streamTokenizer);
                            n3 = 0;
                            string = "";
                            break block0;
                        }
                        case 123: {
                            if (string.compareTo("replacement_chars") == 0) {
                                this.m_haveExtraUnicodeMapping = true;
                            }
                            n4 = 2;
                            TokenParser.skipToEndOfDelimiter(streamTokenizer, n4);
                            n3 = 0;
                            string = "";
                            break block0;
                        }
                    }
                    n3 = TokenParser.processSyntaxError(streamTokenizer, n4);
                    string = "";
                    break;
                }
                default: {
                    n3 = TokenParser.processSyntaxError(streamTokenizer, n4);
                    string = "";
                    break;
                }
            }
        }
    }

    boolean checkAllData() {
        return this.m_charSetName != null && this.m_charSetId != 0 && this.m_oraCharReplacement != 0 && this.m_defaultMultibyteReplacementChar != 0 && this.m_haveExtraUnicodeMapping;
    }

    int get2ByteOraCharReplacement() {
        if (this.m_defaultMultibyteReplacementChar == 0) {
            return this.m_oraCharReplacement;
        }
        return this.m_defaultMultibyteReplacementChar;
    }

    int getCharSetId() {
        return this.m_charSetId;
    }

    String getCharSetIdHex() {
        return Integer.toHexString(this.m_charSetId);
    }

    String getCharSetName() {
        return this.m_charSetName;
    }

    int getOraCharReplacement() {
        return this.m_oraCharReplacement;
    }

    int getUcsReplacement() {
        return 65533;
    }

    boolean haveExtraUnicodeMapping() {
        return this.m_haveExtraUnicodeMapping;
    }
}

