/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import unity.functions.Expression;
import unity.functions.Function;
import unity.relational.Attribute;
import unity.relational.Relation;
import unity.relational.Tuple;

public class F_Abs
extends Function {
    private Expression expr;

    public F_Abs(Expression e) {
        this.expr = e;
        this.returnType = this.expr.getReturnType();
    }

    public Object evaluate(Tuple t) {
        Object val = this.expr.evaluate(t);
        if (val == null) {
            return null;
        }
        if (val instanceof Double) {
            return new Double(Math.abs((Double)val));
        }
        if (val instanceof Float) {
            return new Float(Math.abs(((Float)val).floatValue()));
        }
        if (val instanceof Integer) {
            return new Integer(Math.abs((Integer)val));
        }
        return null;
    }

    public int getReturnType() {
        return this.returnType;
    }

    public static int[] getParamListTypes() {
        return new int[]{Attribute.TYPE_DOUBLE};
    }

    public static String getFunctionName() {
        return "ABS";
    }

    public String toString(Relation relation) {
        return "ABS(" + this.expr.toString(relation) + ")";
    }
}

