/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.planner;

import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.parser.ExpressionType;
import com.edb.gridsql.planner.ExecutionPlanPreparedHandler;
import com.edb.gridsql.planner.ExecutionStep;
import com.edb.gridsql.planner.Leaf;
import com.edb.gridsql.planner.NodeUsage;
import com.edb.gridsql.planner.QueryPlan;
import com.edb.gridsql.planner.StepDetail;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionPlan {
    public static final boolean TRANSFORM_PROJECTIONS = Property.getBoolean("xdb.transformProjections", false);
    protected ExecutionPlan parentExecutionPlan;
    public List<ExecutionStep> stepList;
    public String finalProjString = "";
    public String finalTempTableName = "";
    public List<ExecutionPlan> unionPlanList;
    public List<ExecutionPlan> scalarPlanList;
    public List<ExecutionPlan> relationPlanList;
    public String scalarResult = "null";
    public int scalarPlaceholderNo;
    public boolean combineResults = false;
    public boolean isTopLevelUnion = false;
    public boolean isFinalUnionPart = false;
    public int unionType = 0;
    public List<String> nodeTempTableDropList;
    public List<String> coordTempTableDropList;
    public int correlatedDepth = 0;
    protected boolean isCorrelatedHashable = false;
    private XDBSessionContext client;
    protected ExecutionPlanPreparedHandler anEPParameterHelper;

    public ExecutionPlan(ExecutionPlan executionPlan, QueryPlan queryPlan, HashMap<Integer, NodeUsage> hashMap, List<DBNode> list, boolean bl, XDBSessionContext xDBSessionContext) {
        this(executionPlan, queryPlan, hashMap, list, bl, xDBSessionContext, 0, false);
    }

    public ExecutionPlan(ExecutionPlan executionPlan, QueryPlan queryPlan, HashMap<Integer, NodeUsage> hashMap, List<DBNode> list, boolean bl, XDBSessionContext xDBSessionContext, int n, boolean bl2) {
        Leaf leaf = null;
        this.parentExecutionPlan = executionPlan;
        this.client = xDBSessionContext;
        this.correlatedDepth = n;
        this.isCorrelatedHashable = bl2;
        this.stepList = new ArrayList<ExecutionStep>();
        this.unionPlanList = new ArrayList<ExecutionPlan>();
        this.scalarPlanList = new ArrayList<ExecutionPlan>();
        this.relationPlanList = new ArrayList<ExecutionPlan>();
        this.unionType = queryPlan.unionType;
        if (queryPlan.isUnion) {
            this.buildUnionPlan(queryPlan, hashMap, list);
            return;
        }
        for (QueryPlan queryPlan2 : queryPlan.subplanList) {
            ExecutionPlan executionPlan2 = new ExecutionPlan(this, queryPlan2, hashMap, list, false, xDBSessionContext);
            if (queryPlan2.scalarLeaf != null) {
                executionPlan2.scalarPlaceholderNo = queryPlan2.placeHolderNo;
                this.scalarPlanList.add(executionPlan2);
                continue;
            }
            this.relationPlanList.add(executionPlan2);
        }
        this.finalProjString = queryPlan.finalProjString;
        queryPlan.initLeafIteration();
        Leaf leaf2 = queryPlan.nextLeaf();
        Leaf leaf3 = queryPlan.nextLeaf();
        while (leaf2 != null) {
            Leaf leaf4 = queryPlan.nextLeaf();
            ExecutionStep executionStep = this.createNewStep();
            executionStep.convertFromLeaf(leaf2, leaf3, leaf4, leaf, hashMap, list, bl, queryPlan.planType);
            this.finalTempTableName = leaf2.getTargetTableName();
            if (leaf3 == null && list == null && (queryPlan.isTopLevelPlan || queryPlan.isFinalUnionPart)) {
                this.isFinalUnionPart = queryPlan.isFinalUnionPart;
                if (executionStep.aStepDetail.isProducer && (!leaf2.isCombinerStep() || leaf2.groupByColumns.size() != 0)) {
                    if (this.isFinalUnionPart) {
                        executionStep.aStepDetail.isFinalUnionPart = true;
                        executionStep.aStepDetail.finalUnionPartSortInfo = queryPlan.sortInfo;
                        executionStep.aStepDetail.finalUnionPartIsDistinct = queryPlan.isDistinct;
                    }
                    executionStep.coordStepDetail = null;
                    executionStep.isFinalStep = true;
                    executionStep.aStepDetail.setDestTypeCoordinatorFinal();
                    this.modifyFinalSelectOnNodes(executionStep, queryPlan, TRANSFORM_PROJECTIONS);
                } else {
                    if (this.isFinalUnionPart) {
                        executionStep.coordStepDetail.isFinalUnionPart = true;
                        executionStep.coordStepDetail.finalUnionPartSortInfo = queryPlan.sortInfo;
                        executionStep.coordStepDetail.finalUnionPartIsDistinct = queryPlan.isDistinct;
                    }
                    executionStep.coordStepDetail.isConsumer = false;
                    executionStep.isFinalStep = true;
                    executionStep.coordStepDetail.setDestTypeCoordinatorFinal();
                    executionStep.coordStepDetail.targetSchema = "";
                    executionStep.coordStepDetail.targetTable = "";
                    this.coordTempTableDropList = executionStep.coordStepDetail.dropList;
                    this.modifyFinalSelectOnCoordinator(executionStep, queryPlan, TRANSFORM_PROJECTIONS);
                }
            }
            leaf = leaf2;
            leaf2 = leaf3;
            leaf3 = leaf4;
        }
    }

    private void modifyFinalSelectOnNodes(ExecutionStep executionStep, QueryPlan queryPlan, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("SELECT ");
        if (queryPlan.isDistinct) {
            stringBuilder.append("DISTINCT ");
        }
        executionStep.aStepDetail.queryString = queryPlan.orderByClause.length() > 0 ? (bl ? stringBuilder.append(queryPlan.finalProjString).append(queryPlan.addedFinalProjections).append(" FROM (").append(executionStep.aStepDetail.queryString).append(") as axtmzyx").append(" order by ").append(queryPlan.orderByClause).toString() : stringBuilder.append(queryPlan.finalProjString).append(queryPlan.addedFinalProjections).append(" ").append(executionStep.aStepDetail.nonProjectionSelectPart).append(" order by ").append(queryPlan.orderByClause).toString()) : (bl ? stringBuilder.append(queryPlan.finalProjString).append(" FROM (").append(executionStep.aStepDetail.queryString).append(") as xtmzyx").toString() : stringBuilder.append(queryPlan.finalProjString).append(" ").append(executionStep.aStepDetail.nonProjectionSelectPart).toString());
        this.combineResults = true;
        this.nodeTempTableDropList = executionStep.aStepDetail.dropList;
        this.addLimitAndOffset(executionStep, queryPlan);
        this.addIntoTable(executionStep.aStepDetail, executionStep.aStepDetail, executionStep.nodeUsageTable, queryPlan);
    }

    private void addIntoTable(StepDetail stepDetail, StepDetail stepDetail2, Map<Integer, NodeUsage> map, QueryPlan queryPlan) {
        SysTable sysTable = queryPlan.getIntoTable();
        if (sysTable != null) {
            stepDetail.targetTable = stepDetail2.targetTable;
            stepDetail2.consumerNodeList = stepDetail.consumerNodeList = new ArrayList(sysTable.getPartitionMap().allPartitions().size());
            for (Integer object : sysTable.getPartitionMap().allPartitions()) {
                stepDetail.consumerNodeList.add(object);
                NodeUsage nodeUsage = map.get(object);
                if (nodeUsage == null) {
                    nodeUsage = new NodeUsage(object, false, false);
                    map.put(object, nodeUsage);
                }
                nodeUsage.isConsumer = true;
            }
            stepDetail2.isConsumer = true;
            if (sysTable.getPartitionScheme() == 3) {
                String string = sysTable.getPartitionColumn();
                SysColumn sysColumn = sysTable.getPartitionedColumn();
                if (sysColumn == null) {
                    throw new XDBServerException("Partitioning column not found: " + (String)string);
                }
                stepDetail.setDestTypeHash(string, sysTable.getPartitionMap());
                stepDetail.setHashDataType(new ExpressionType(sysColumn));
            } else {
                stepDetail.setDestTypeBrodcast();
                stepDetail.setPartitionMap(sysTable.getPartitionMap());
            }
        }
    }

    private void addLimitAndOffset(ExecutionStep executionStep, QueryPlan queryPlan) {
        if (executionStep.nodeUsageTable.size() == 1) {
            if (queryPlan.getLimit() > -1L) {
                executionStep.aStepDetail.queryString = executionStep.aStepDetail.queryString + " LIMIT " + queryPlan.getLimit();
            }
            if (queryPlan.getOffset() > -1L) {
                executionStep.aStepDetail.queryString = executionStep.aStepDetail.queryString + " OFFSET " + queryPlan.getOffset();
            }
        } else if (queryPlan.getLimit() > -1L) {
            executionStep.aStepDetail.queryString = queryPlan.getOffset() > -1L ? executionStep.aStepDetail.queryString + " LIMIT " + (queryPlan.getLimit() + queryPlan.getOffset()) : executionStep.aStepDetail.queryString + " LIMIT " + queryPlan.getLimit();
        }
    }

    private void modifyFinalSelectOnCoordinator(ExecutionStep executionStep, QueryPlan queryPlan, boolean bl) {
        String string = "SELECT ";
        if (queryPlan.isDistinct) {
            string = string + "DISTINCT ";
        }
        executionStep.coordStepDetail.queryString = queryPlan.orderByClause.length() > 0 ? (bl ? string + queryPlan.finalProjString + queryPlan.addedFinalProjections + " FROM (" + executionStep.coordStepDetail.queryString + ")" + " order by " + queryPlan.orderByClause : string + queryPlan.finalProjString + " " + executionStep.coordStepDetail.nonProjectionSelectPart + " order by " + queryPlan.orderByClause) : (bl ? string + queryPlan.finalProjString + " FROM (" + executionStep.coordStepDetail.queryString + ") as xtmzyx" : string + queryPlan.finalProjString + " " + executionStep.coordStepDetail.nonProjectionSelectPart);
        if (queryPlan.getLimit() > -1L) {
            executionStep.coordStepDetail.queryString = executionStep.coordStepDetail.queryString + " LIMIT " + queryPlan.getLimit();
        }
        if (queryPlan.getOffset() > -1L) {
            executionStep.coordStepDetail.queryString = executionStep.coordStepDetail.queryString + " OFFSET " + queryPlan.getOffset();
        }
        this.addIntoTable(executionStep.coordStepDetail, executionStep.aStepDetail, executionStep.nodeUsageTable, queryPlan);
    }

    private void buildUnionPlan(QueryPlan queryPlan, HashMap<Integer, NodeUsage> hashMap, List<DBNode> list) {
        this.unionPlanList = new ArrayList<ExecutionPlan>();
        this.nodeTempTableDropList = new ArrayList<String>();
        this.coordTempTableDropList = new ArrayList<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (QueryPlan queryPlan2 : queryPlan.unionSubplanList) {
            Object object;
            if (queryPlan2.orderByClause.length() > 0) {
                object = queryPlan2.getLastLeaf();
                ((Leaf)object).setSelectStatement(((Leaf)object).getSelectStatement() + " order by " + queryPlan2.orderByClause);
            }
            ExecutionPlan executionPlan = new ExecutionPlan(this, queryPlan2, hashMap, list, true, this.client);
            this.unionPlanList.add(executionPlan);
            object = executionPlan.stepList.get(executionPlan.stepList.size() - 1);
            if (((ExecutionStep)object).aStepDetail.isProducer) {
                this.nodeTempTableDropList.addAll(((ExecutionStep)object).aStepDetail.dropList);
            } else if (((ExecutionStep)object).coordStepDetail != null) {
                this.coordTempTableDropList.addAll(((ExecutionStep)object).coordStepDetail.dropList);
            }
            arrayList.add(queryPlan2.finalTableName);
            if (queryPlan2.unionType == 2) {
                if (((ExecutionStep)object).aStepDetail != null) {
                    ((ExecutionStep)object).aStepDetail.unionResultGroup = (short)2;
                }
                if (((ExecutionStep)object).coordStepDetail == null) continue;
                ((ExecutionStep)object).coordStepDetail.unionResultGroup = (short)2;
                continue;
            }
            if (((ExecutionStep)object).aStepDetail != null) {
                ((ExecutionStep)object).aStepDetail.unionResultGroup = 1;
            }
            if (((ExecutionStep)object).coordStepDetail == null) continue;
            ((ExecutionStep)object).coordStepDetail.unionResultGroup = 1;
        }
        this.finalTempTableName = queryPlan.finalTableName;
        this.finalProjString = queryPlan.finalProjString;
        if (!queryPlan.isTopLevelPlan) {
            Leaf leaf = queryPlan.getFirstLeaf();
            ExecutionStep executionStep = this.createNewStep();
            if (this.parentExecutionPlan != null && this.parentExecutionPlan.parentExecutionPlan == null && !this.parentExecutionPlan.unionPlanList.isEmpty()) {
                executionStep.convertFromLeaf(leaf, null, null, null, hashMap, list, false, queryPlan.planType);
                executionStep.aStepDetail.setDestTypeCoordinatorFinal();
                executionStep.isFinalStep = true;
                executionStep.aStepDetail.isFinalUnionPart = true;
                executionStep.aStepDetail.finalUnionPartSortInfo = queryPlan.topQueryPlan.sortInfo;
            } else {
                executionStep.convertFromLeaf(leaf, null, null, null, hashMap, list, true, queryPlan.planType);
            }
            executionStep.aStepDetail.dropList.addAll(arrayList);
        } else {
            this.isTopLevelUnion = true;
        }
    }

    private ExecutionStep createNewStep() {
        ExecutionStep executionStep = new ExecutionStep(this, this.client);
        this.stepList.add(executionStep);
        return executionStep;
    }

    public void correctDestinations() {
        this.correctStepDestinations();
    }

    private ExecutionStep correctStepDestinations() {
        ExecutionStep object = null;
        if (!this.unionPlanList.isEmpty()) {
            this.correctUnionQueryDestinations();
        }
        for (ExecutionPlan object2 : this.scalarPlanList) {
            object2.correctStepDestinations();
        }
        for (ExecutionPlan executionPlan : this.relationPlanList) {
            ExecutionStep executionStep = executionPlan.correctStepDestinations();
            executionStep.correctDestinations(this.stepList.get(0));
        }
        for (ExecutionStep executionStep : this.stepList) {
            if (executionStep.correlatedSubPlan != null) {
                executionStep.correlatedSubPlan.correctStepDestinations();
            }
            if (executionStep.uncorrelatedSubPlanList != null) {
                for (ExecutionPlan executionPlan : executionStep.uncorrelatedSubPlanList) {
                    ExecutionStep executionStep2 = executionPlan.correctStepDestinations();
                    if (executionStep2 == null) continue;
                    executionStep2.correctDestinations(executionStep);
                }
            }
            if (object != null) {
                object.correctDestinations(executionStep);
            }
            object = executionStep;
        }
        return object;
    }

    private void correctUnionQueryDestinations() {
        for (ExecutionPlan executionPlan : this.unionPlanList) {
            executionPlan.correctStepDestinations();
        }
    }

    protected ExecutionPlan getTopParentPlan() {
        if (this.parentExecutionPlan == null) {
            return this;
        }
        return this.parentExecutionPlan.getTopParentPlan();
    }

    public void prepareParameters(int[] nArray) {
        this.anEPParameterHelper = new ExecutionPlanPreparedHandler(this.client, nArray);
        this.anEPParameterHelper.preparePlanParameters(this);
    }

    public void substituteParameterValues(String[] stringArray) {
        this.anEPParameterHelper.substituteParameterValues(stringArray);
    }
}

