/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.ExpressionType;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tuple {
    private XDBSessionContext client;
    private SysTable aSysTable;
    private LinkedHashMap<SysColumn, SqlExpression> mapColumnValueList = new LinkedHashMap();

    public SysTable getaSysTable() {
        return this.aSysTable;
    }

    public Tuple(String string, List<SysColumn> list, List<SqlExpression> list2, XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.aSysTable = xDBSessionContext.getSysDatabase().getSysTable(this.getTableName(string));
        for (int i = 0; i < list2.size(); ++i) {
            SqlExpression sqlExpression = list2.get(i);
            if (sqlExpression.getExprType() == 32 && sqlExpression.getFunctionId() == 106) {
                sqlExpression = this.setValuesOfTuple(list.get(i), list2.get(i));
            }
            if (sqlExpression.getExprType() == 1024) {
                sqlExpression.setExprDataType(sqlExpression.setExpressionResultType(sqlExpression, list.get(i)));
            }
            SysColumn sysColumn = list.get(i);
            if (sqlExpression.getExprDataType() == null) {
                sqlExpression.setExprDataType(new ExpressionType(sysColumn));
            }
            this.mapColumnValueList.put(sysColumn, sqlExpression);
        }
    }

    private SqlExpression setValuesOfTuple(SysColumn sysColumn, SqlExpression sqlExpression) {
        sqlExpression.rebuildExpression();
        sqlExpression.setExprDataType(SqlExpression.setExpressionResultType(sqlExpression, this.client.getSysDatabase()));
        return sqlExpression;
    }

    public String getValue(String string) {
        return this.getValue(this.aSysTable.getSysColumn(string));
    }

    public String getValue(SysColumn sysColumn) {
        SqlExpression sqlExpression = this.getExpression(sysColumn);
        return sqlExpression == null ? null : sqlExpression.rebuildExpression(sqlExpression, sysColumn.getColType()).rebuildString();
    }

    public SqlExpression getExpression(String string) {
        return this.getExpression(this.aSysTable.getSysColumn(string));
    }

    public SqlExpression getExpression(SysColumn sysColumn) {
        SqlExpression sqlExpression = this.mapColumnValueList.get(sysColumn);
        if (sqlExpression == null) {
            try {
                sqlExpression = SqlExpression.createConstantExpression(sysColumn.getDefaultValue(this.client), new ExpressionType(sysColumn));
                this.mapColumnValueList.put(sysColumn, sqlExpression);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sqlExpression;
    }

    public String getTableName(String string) {
        return string;
    }
}

