/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.NodeDBConnectionInfo;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.DropDatabase;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.util.DbGateway;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlDropDatabase
extends ObjectDepthFirst
implements IXDBSql,
IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlDropDatabase.class);
    private XDBSessionContext client;
    private boolean prepared = false;
    private boolean forceDrop = false;
    private String dbName;

    public SqlDropDatabase(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
    }

    @Override
    public boolean isPrepared() {
        return this.prepared;
    }

    @Override
    public Collection<DBNode> getNodeList() {
        return Collections.emptyList();
    }

    @Override
    public long getCost() {
        return 1L;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        List list = Collections.emptyList();
        return new LockSpecification<SysTable>(list, list);
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() throws Exception {
        if (!this.prepared && this.client.getCurrentUser().getLogin().getUserClass() != 0) {
            throw new XDBSecurityException("You are not allowed to drop the database");
        }
        this.prepared = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        if (!this.isPrepared()) {
            this.prepare();
        }
        XDBSessionContext xDBSessionContext = XDBSessionContext.createSession();
        try {
            ExecutionResult executionResult = null;
            try {
                xDBSessionContext.useDB(this.dbName, "A");
                xDBSessionContext.login(this.client.getCurrentUser().getLogin());
                executionResult = xDBSessionContext.dropDatabase();
            }
            catch (Exception exception) {
                if (!this.forceDrop) {
                    throw exception;
                }
                executionResult = ExecutionResult.createSuccessResult(34);
            }
            NodeDBConnectionInfo[] nodeDBConnectionInfoArray = xDBSessionContext.getConnectionInfos(null);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            DbGateway dbGateway = new DbGateway();
            dbGateway.setForce(this.forceDrop);
            dbGateway.dropDbOnNodes(hashMap, nodeDBConnectionInfoArray);
            ExecutionResult executionResult2 = executionResult;
            xDBSessionContext.logout();
            return executionResult2;
        }
        catch (Throwable throwable) {
            xDBSessionContext.logout();
            throw throwable;
        }
    }

    @Override
    public Object visit(DropDatabase dropDatabase, Object object) {
        this.dbName = (String)dropDatabase.f1.accept(new IdentifierHandler(), object);
        this.forceDrop = dropDatabase.f2.present();
        return null;
    }
}

