/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IExecutable;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.ILockCost;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.Command;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.SqlAlterAddCheck;
import com.edb.gridsql.parser.SqlAlterAddColumn;
import com.edb.gridsql.parser.SqlAlterAddForeignKey;
import com.edb.gridsql.parser.SqlAlterAddPrimary;
import com.edb.gridsql.parser.SqlAlterDropColumn;
import com.edb.gridsql.parser.SqlAlterDropConstraint;
import com.edb.gridsql.parser.SqlAlterDropPrimarykey;
import com.edb.gridsql.parser.SqlAlterModifyColumn;
import com.edb.gridsql.parser.SqlAlterOwner;
import com.edb.gridsql.parser.SqlAlterRenameColumn;
import com.edb.gridsql.parser.SqlAlterSetTablespace;
import com.edb.gridsql.parser.core.syntaxtree.AddDef;
import com.edb.gridsql.parser.core.syntaxtree.AlterDefOperation;
import com.edb.gridsql.parser.core.syntaxtree.AlterTable;
import com.edb.gridsql.parser.core.syntaxtree.DropDef;
import com.edb.gridsql.parser.core.syntaxtree.NodeChoice;
import com.edb.gridsql.parser.core.syntaxtree.NodeSequence;
import com.edb.gridsql.parser.core.syntaxtree.OwnerDef;
import com.edb.gridsql.parser.core.syntaxtree.RenameDef;
import com.edb.gridsql.parser.core.syntaxtree.SetTablespace;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.parser.handler.QueryTreeTracker;
import com.edb.gridsql.parser.handler.TableNameHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlAlterTable
extends ObjectDepthFirst
implements IXDBSql,
IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlAlterTable.class);
    private XDBSessionContext client;
    private SysDatabase database;
    private String tableName;
    private SysTable table;
    private Command commandToExecute;
    private List<Object> alterDefs = new LinkedList<Object>();
    private String commonCommand;
    private boolean prepared = false;

    public SqlAlterTable(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.database = xDBSessionContext.getSysDatabase();
        this.commandToExecute = new Command(4, this, new QueryTreeTracker(), xDBSessionContext);
    }

    @Override
    public Object visit(AlterTable alterTable, Object object) {
        Object var3_3 = null;
        alterTable.f0.accept(this, object);
        TableNameHandler tableNameHandler = new TableNameHandler(this.client);
        alterTable.f1.accept(tableNameHandler, object);
        this.tableName = tableNameHandler.getTableName();
        alterTable.f2.accept(this, object);
        alterTable.f3.accept(this, object);
        return var3_3;
    }

    @Override
    public Object visit(SetTablespace setTablespace, Object object) {
        Object var3_3 = null;
        SqlAlterSetTablespace sqlAlterSetTablespace = new SqlAlterSetTablespace(this, this.client);
        this.alterDefs.add(sqlAlterSetTablespace);
        setTablespace.accept(sqlAlterSetTablespace, object);
        return var3_3;
    }

    @Override
    public Object visit(OwnerDef ownerDef, Object object) {
        Object var3_3 = null;
        SqlAlterOwner sqlAlterOwner = new SqlAlterOwner(this, this.client);
        this.alterDefs.add(sqlAlterOwner);
        ownerDef.accept(sqlAlterOwner, object);
        return var3_3;
    }

    @Override
    public Object visit(AddDef addDef, Object object) {
        Object var3_3 = null;
        block0 : switch (addDef.f1.which) {
            case 0: {
                SqlAlterAddColumn sqlAlterAddColumn = new SqlAlterAddColumn(this, this.client);
                this.alterDefs.add(sqlAlterAddColumn);
                addDef.f1.accept(sqlAlterAddColumn, object);
                break;
            }
            case 1: {
                NodeSequence nodeSequence = (NodeSequence)addDef.f1.choice;
                NodeChoice nodeChoice = (NodeChoice)nodeSequence.nodes.elementAt(1);
                switch (nodeChoice.which) {
                    case 0: {
                        SqlAlterAddPrimary sqlAlterAddPrimary = new SqlAlterAddPrimary(this, this.client);
                        this.alterDefs.add(sqlAlterAddPrimary);
                        addDef.f1.accept(sqlAlterAddPrimary, object);
                        break block0;
                    }
                    case 1: {
                        SqlAlterAddForeignKey sqlAlterAddForeignKey = new SqlAlterAddForeignKey(this, this.client);
                        this.alterDefs.add(sqlAlterAddForeignKey);
                        addDef.f1.accept(sqlAlterAddForeignKey, object);
                        break block0;
                    }
                    case 2: {
                        SqlAlterAddCheck sqlAlterAddCheck = new SqlAlterAddCheck(this, this.client);
                        this.alterDefs.add(sqlAlterAddCheck);
                        addDef.f1.accept(sqlAlterAddCheck, object);
                    }
                }
            }
        }
        return var3_3;
    }

    @Override
    public Object visit(DropDef dropDef, Object object) {
        Object var3_3 = null;
        switch (dropDef.f1.which) {
            case 0: {
                SqlAlterDropColumn sqlAlterDropColumn = new SqlAlterDropColumn(this, this.client);
                this.alterDefs.add(sqlAlterDropColumn);
                dropDef.f1.accept(sqlAlterDropColumn, object);
                break;
            }
            case 1: {
                SqlAlterDropConstraint sqlAlterDropConstraint = new SqlAlterDropConstraint(this, this.client);
                this.alterDefs.add(sqlAlterDropConstraint);
                dropDef.f1.accept(sqlAlterDropConstraint, object);
                break;
            }
            case 2: {
                SqlAlterDropPrimarykey sqlAlterDropPrimarykey = new SqlAlterDropPrimarykey(this, this.client);
                this.alterDefs.add(sqlAlterDropPrimarykey);
                dropDef.f1.accept(sqlAlterDropPrimarykey, object);
            }
        }
        return var3_3;
    }

    public void addCommonCommand(String string) {
        this.commonCommand = this.commonCommand == null ? "ALTER TABLE " + IdentifierHandler.quote(this.tableName) + " " + string : this.commonCommand + ", " + string;
    }

    @Override
    public Object visit(AlterDefOperation alterDefOperation, Object object) {
        Object var3_3 = null;
        SqlAlterModifyColumn sqlAlterModifyColumn = new SqlAlterModifyColumn(this, (String)alterDefOperation.f0.accept(new IdentifierHandler(), object), this.client);
        alterDefOperation.f1.accept(sqlAlterModifyColumn, null);
        this.alterDefs.add(sqlAlterModifyColumn);
        return var3_3;
    }

    @Override
    public Object visit(RenameDef renameDef, Object object) {
        Object var3_3 = null;
        SqlAlterRenameColumn sqlAlterRenameColumn = new SqlAlterRenameColumn(this, this.client);
        renameDef.accept(sqlAlterRenameColumn, object);
        this.alterDefs.add(sqlAlterRenameColumn);
        return var3_3;
    }

    @Override
    public Collection<DBNode> getNodeList() {
        HashSet<DBNode> hashSet = new HashSet<DBNode>();
        hashSet.addAll(this.table.getNodeList());
        for (Object object : this.alterDefs) {
            if (!(object instanceof IXDBSql)) continue;
            hashSet.addAll(((IXDBSql)object).getNodeList());
        }
        return hashSet;
    }

    public String getTableName() {
        return this.tableName;
    }

    public SysTable getTable() {
        if (this.table == null) {
            this.table = this.database.getSysTable(this.tableName);
        }
        return this.table;
    }

    @Override
    public long getCost() {
        return 1L;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        Vector vector = new Vector();
        Vector<SysTable> vector2 = new Vector<SysTable>();
        vector2.add(this.table);
        LockSpecification<SysTable> lockSpecification = new LockSpecification<SysTable>(vector, vector2);
        for (Object object : this.alterDefs) {
            if (!(object instanceof ILockCost)) continue;
            lockSpecification.addAll(((ILockCost)object).getLockSpecs());
        }
        return lockSpecification;
    }

    @Override
    public boolean isPrepared() {
        return this.prepared;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() throws Exception {
        this.prepared = true;
        for (Object object : this.alterDefs) {
            if (!(object instanceof IPreparable)) continue;
            ((IPreparable)object).prepare();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        if (this.commonCommand != null) {
            engine.executeOnMultipleNodes(this.commonCommand, this.getNodeList(), this.client);
        }
        for (Object object : this.alterDefs) {
            if (!(object instanceof IExecutable)) continue;
            ((IExecutable)object).execute(engine);
        }
        ExecutionResult executionResult = ExecutionResult.createSuccessResult(2);
        return executionResult;
    }

    public Command getCommandToExecute() {
        return this.commandToExecute;
    }

    public SysDatabase getDatabase() {
        return this.database;
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }
}

