/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.SyncAlterTableDropPrimaryKey;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysIndex;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.parser.SqlAlterTable;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class SqlAlterDropPrimarykey
extends ObjectDepthFirst
implements IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlAlterDropPrimarykey.class);
    private XDBSessionContext client;
    private SqlAlterTable parent;
    private String[] commands;

    public SqlAlterDropPrimarykey(SqlAlterTable sqlAlterTable, XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.parent = sqlAlterTable;
    }

    public boolean isPrepared() {
        return this.commands != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws Exception {
        Vector<String> vector = new Vector<String>();
        SysTable sysTable = this.parent.getTable();
        sysTable.checkPermission(this.client.getCurrentUser(), (short)6);
        List<SysColumn> list = sysTable.getPrimaryKey();
        if (list == null || list.size() == 0) {
            throw new XDBServerException(ErrorMessageRepository.NO_PRIMARY_UNQIUE_INDEX + " ( " + sysTable.getTableName() + " )", 0, ErrorMessageRepository.NO_PRIMARY_UNQIUE_INDEX_CODE);
        }
        SysIndex sysIndex = sysTable.getPrimaryIndex();
        if (sysIndex == null) {
            throw new XDBServerException(ErrorMessageRepository.NO_PRIMARY_UNQIUE_INDEX + " ( " + sysTable.getTableName() + " )", 0, ErrorMessageRepository.NO_PRIMARY_UNQIUE_INDEX_CODE);
        }
        if (sysTable.getPrimaryConstraint().getSysTable() != sysTable) {
            throw new XDBServerException("Can not drop inherited primary key");
        }
        if (sysTable.isIndexReferenced(sysIndex)) {
            throw new XDBServerException(ErrorMessageRepository.PRIMARYKEY_REFRENCED, 0, ErrorMessageRepository.PRIMARYKEY_REFRENCED_CODE);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("table", IdentifierHandler.quote(sysTable.getTableName()));
        hashMap.put("constr_name", IdentifierHandler.quote(sysIndex.idxname));
        String string = ParseCmdLine.substitute(Props.XDB_SQLCOMMAND_ALTERTABLE_DROPPRIMAY, hashMap);
        if (Props.XDB_SQLCOMMAND_ALTERTABLE_DROPPRIMAY_TO_PARENT) {
            this.parent.addCommonCommand(string);
        } else {
            vector.add(string);
        }
        this.commands = vector.toArray(new String[vector.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionResult execute(Engine engine) throws Exception {
        engine.executeDDLOnMultipleNodes(this.commands, this.parent.getNodeList(), (IMetaDataUpdate)new SyncAlterTableDropPrimaryKey(this), this.client);
        ExecutionResult executionResult = null;
        return executionResult;
    }

    public SqlAlterTable getParent() {
        return this.parent;
    }
}

