/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.InvalidExpressionException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.parser.ExprTypeHelper;
import com.edb.gridsql.parser.handler.TypeConstants;
import java.io.Serializable;
import java.util.HashMap;

public class ExpressionType
implements Serializable {
    private static final long serialVersionUID = -2431777809309372782L;
    public static int VARCHAR_MAX = 8000;
    public static int VARCHAR_UNICODE_MAX = 4000;
    public static int VERSION = 2000;
    public static int INTLEN = 22;
    public static int BIGINTLEN = 40;
    public static int DATELEN = 8;
    public static int TIMELEN = 8;
    public static int TIMESTAMPLEN = 26;
    public static int MONTHORDAYNAME = 20;
    public static int MAXCHARLEN = 255;
    public boolean isWithTimeZone;
    public int type;
    public int length = -1;
    public int scale = -1;
    public int precision = -1;
    public static final int BLOB_TYPE = 2004;
    public static final int BOOLEAN_TYPE = 16;
    public static final int CLOB_TYPE = 2005;
    public static final int DOUBLEPRECISION_TYPE = 8;
    public static final int BIT_TYPE = -7;
    public static final int BINARY_TYPE = -2;
    public static final int VARBINARY_TYPE = -3;
    public static final int CHAR_TYPE = 1;
    public static final int VARCHAR_TYPE = 12;
    public static final int SMALLINT_TYPE = 5;
    public static final int INT_TYPE = 4;
    public static final int BIGINT_TYPE = -5;
    public static final int NUMERIC_TYPE = 2;
    public static final int REAL_TYPE = 7;
    public static final int FLOAT_TYPE = 6;
    public static final int DATE_TYPE = 91;
    public static final int TIME_TYPE = 92;
    public static final int DECIMAL_TYPE = 3;
    public static final int TIMESTAMP_TYPE = 93;
    public static final int NULL_TYPE = 0;
    public static final int OTHER_TYPE = 1111;
    public static final int LEN_SERIAL = 10;
    public int LEN_SMALLINT = 10;
    public int LEN_TIMESTAMP = 25;

    public ExpressionType() {
    }

    public ExpressionType(SysColumn sysColumn) {
        this.type = sysColumn.getColType();
        this.length = sysColumn.getColLength();
        this.precision = sysColumn.getColPrecision();
        this.scale = sysColumn.getColScale();
    }

    public static boolean isNumeric(int n) {
        switch (n) {
            case 2004: {
                return false;
            }
            case 16: {
                return false;
            }
            case -7: 
            case -2: {
                return false;
            }
            case 1: {
                return false;
            }
            case 12: {
                return false;
            }
            case 91: {
                return false;
            }
            case 92: {
                return false;
            }
            case 93: {
                return false;
            }
            case 2005: {
                return false;
            }
            case 5: {
                return true;
            }
            case 4: {
                return true;
            }
            case 2: {
                return true;
            }
            case 7: {
                return true;
            }
            case 6: {
                return true;
            }
            case 3: {
                return true;
            }
            case 10: {
                return true;
            }
            case -5: {
                return true;
            }
            case 8: {
                return true;
            }
            case 0: {
                return true;
            }
            case 1111: {
                return false;
            }
        }
        throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + "( " + n + " )", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
    }

    public boolean isNumeric() {
        return ExpressionType.isNumeric(this.type);
    }

    public static boolean isInExactNumeric(int n) {
        return n == 7 || n == 6 || n == 8;
    }

    public boolean isInExactNumeric() {
        return ExpressionType.isInExactNumeric(this.type);
    }

    public boolean isBit() {
        switch (this.type) {
            case -7: 
            case -2: 
            case 0: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public boolean isCharacter() {
        switch (this.type) {
            case 12: {
                return true;
            }
        }
        return false;
    }

    public String getTypeString() {
        String string = "";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("length", new String(this.length + ""));
        hashMap.put("scale", new String(this.scale + ""));
        hashMap.put("precision", new String(this.precision + ""));
        switch (this.type) {
            case -7: {
                string = this.length > 1 ? TypeConstants.BIT_TEMPLATE : "BIT";
                string = ParseCmdLine.substitute(string, hashMap);
                break;
            }
            case -2: {
                string = this.length > 1 ? TypeConstants.BIT_TEMPLATE : "BIT";
                string = ParseCmdLine.substitute(string, hashMap);
                break;
            }
            case -3: {
                string = "VARBIT";
                break;
            }
            case 1: {
                string = TypeConstants.CHAR_TEMPLATE;
                string = ParseCmdLine.substitute(string, hashMap);
                break;
            }
            case 12: {
                string = TypeConstants.VARCHAR_TEMPLATE;
                string = ParseCmdLine.substitute(string, hashMap);
                break;
            }
            case 5: {
                string = TypeConstants.SMALLINT_TEMPLATE;
                string = ParseCmdLine.substitute(string, hashMap);
                break;
            }
            case 4: {
                string = TypeConstants.INTEGER_TEMPLATE;
                string = ParseCmdLine.substitute(string, hashMap);
                break;
            }
            case -5: {
                string = TypeConstants.BIGINTEGER_TEMPLATE;
                string = ParseCmdLine.substitute(string, hashMap);
                break;
            }
            case 3: {
                string = TypeConstants.DECIMAL_TEMPLATE;
                string = ParseCmdLine.substitute(string, hashMap);
                break;
            }
            case 2: {
                string = this.scale != 0 ? TypeConstants.NUMERIC_TEMPLATE : TypeConstants.NUMERIC_TEMPLATE_EDB_EXTENSION;
                string = ParseCmdLine.substitute(string, hashMap);
                break;
            }
            case 7: {
                string = TypeConstants.REAL_TEMPLATE;
                break;
            }
            case 6: {
                string = this.length > 0 ? TypeConstants.FLOAT_TEMPLATE : TypeConstants.FLOAT_TEMPLATE_EDB_EXTENSION;
                string = ParseCmdLine.substitute(string, hashMap);
                break;
            }
            case 91: {
                string = TypeConstants.DATE_TEMPLATE;
                string = ParseCmdLine.substitute(string, hashMap);
                break;
            }
            case 92: {
                string = this.isWithTimeZone ? TypeConstants.TIMEWITHOUTLENGTH_WITH_TIMEZONE_TEMPLATE : TypeConstants.TIME_TEMPLATE;
                string = ParseCmdLine.substitute(string, hashMap);
                break;
            }
            case 93: {
                string = this.isWithTimeZone ? TypeConstants.TIMESTAMPWITHOUTLENGTH_WITH_TIMEZONE_TEMPLATE : TypeConstants.TIMESTAMP_TEMPLATE;
                string = ParseCmdLine.substitute(string, hashMap);
                break;
            }
            case 8: {
                string = TypeConstants.DOUBLE_TEMPLATE;
                string = ParseCmdLine.substitute(string, hashMap);
                break;
            }
            case 16: {
                string = TypeConstants.BOOLEAN_TEMPLATE;
                string = ParseCmdLine.substitute(string, hashMap);
                break;
            }
            case 2005: {
                string = TypeConstants.TEXT_TEMPLATE;
                string = ParseCmdLine.substitute(string, hashMap);
                break;
            }
            case 2004: {
                string = TypeConstants.BLOB_TEMPLATE;
                string = ParseCmdLine.substitute(string, hashMap);
                break;
            }
            case 1111: {
                string = "OTHER ";
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + "( " + this.type + " )", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
            }
        }
        return string;
    }

    public String getLengthString() {
        if (this.length > 0) {
            return "( " + this.length + " )";
        }
        return "";
    }

    public void setExpressionType(int n, int n2, int n3, int n4) {
        this.type = n;
        this.length = n2;
        this.precision = n3;
        this.scale = n4;
    }

    public ExpressionType GetExpressionType(ExprTypeHelper exprTypeHelper) {
        ExpressionType expressionType = this.checkSemanticsAndReturnOutputType(exprTypeHelper);
        return expressionType;
    }

    private ExpressionType checkSemanticsAndReturnOutputType(ExprTypeHelper exprTypeHelper) {
        ExpressionType expressionType = null;
        int n = exprTypeHelper.leftExprType.type;
        int n2 = exprTypeHelper.righExprType.type;
        if (n == 1111 || n2 == 1111) {
            expressionType = this.HandleOther(exprTypeHelper);
            return expressionType;
        }
        if (n == 92 || n2 == 92) {
            expressionType = this.HandleTimeType(exprTypeHelper);
        }
        if (n == 2005 || n2 == 2005) {
            expressionType = this.HandleClobType(exprTypeHelper);
        } else if (n == 2004 || n2 == 2004) {
            expressionType = this.HandleBlobType(exprTypeHelper);
        } else if (n == -7 || n2 == -7) {
            expressionType = this.HandleBitType(exprTypeHelper);
        } else if (n == 16 || n2 == 16) {
            expressionType = this.HandleBooleanType(exprTypeHelper);
        } else if (n == 8 || n2 == 8) {
            expressionType = this.HandleDoublePrecison(exprTypeHelper);
        } else if (n == 1 || n2 == 1) {
            expressionType = this.HandleCharType(exprTypeHelper);
        } else if (n == 12 || n2 == 12) {
            expressionType = this.HandleVarCharType(exprTypeHelper);
        } else if (n == 5 || n2 == 5) {
            expressionType = this.HandleSmallInt(exprTypeHelper);
        } else if (n == 4 || n2 == 4) {
            expressionType = this.HandleInt(exprTypeHelper);
        } else if (n == -5 || n2 == -5) {
            expressionType = this.HandleBigInt(exprTypeHelper);
        } else if (n == 2 || n2 == 2) {
            expressionType = this.HandleNumeric(exprTypeHelper);
        } else if (n == 7 || n2 == 7) {
            expressionType = this.HandleReal(exprTypeHelper);
        } else if (n == 6 || n2 == 6) {
            expressionType = this.HandleFloat(exprTypeHelper);
        } else if (n == 91 || n2 == 91) {
            expressionType = this.HandleDate(exprTypeHelper);
        } else if (n == 3 || n2 == 3) {
            expressionType = this.HandleDecimal(exprTypeHelper);
        } else if (n == 93 || n2 == 93) {
            expressionType = this.HandleTimeStamp(exprTypeHelper);
        }
        if (expressionType == null) {
            throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
        }
        return expressionType;
    }

    private ExpressionType HandleBitType(ExprTypeHelper exprTypeHelper) {
        ExpressionType expressionType = null;
        int n = exprTypeHelper.leftExprType.type;
        int n2 = exprTypeHelper.righExprType.type;
        if (n == 16 || n2 == 16 || n == 2004 || n2 == 2004 || n == 16 || n2 == 16 || n == 2005 || n2 == 2005 || n == 8 || n2 == 8 || n == 1 || n2 == 1 || n == 12 || n2 == 12 || n == 5 || n2 == 5 || n == 4 || n2 == 4 || n == 2 || n2 == 2 || n == 7 || n2 == 7 || n == 6 || n2 == 6 || n == 91 || n2 == 91 || n == 3 || n2 == 3 || n == 93 || n2 == 93) {
            // empty if block
        }
        return expressionType;
    }

    private ExpressionType HandleBlobType(ExprTypeHelper exprTypeHelper) {
        ExpressionType expressionType = new ExpressionType();
        int n = exprTypeHelper.leftExprType.type;
        int n2 = exprTypeHelper.righExprType.type;
        if (n == 2004 || n2 == 2004 || n == 0 || n2 == 0) {
            expressionType.setExpressionType(2004, -1, -1, -1);
        } else {
            if (n == 16 || n2 == 16) {
                throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
            }
            if (n == 2005 || n2 == 2005) {
                throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
            }
            if (n == 8 || n2 == 8) {
                throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
            }
            if (n == 1 || n2 == 1) {
                throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
            }
            if (n == 12 || n2 == 12) {
                throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
            }
            if (n == 5 || n2 == 5) {
                throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
            }
            if (n == 4 || n2 == 4) {
                throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
            }
            if (n == -5 || n2 == -5) {
                throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
            }
            if (n == 2 || n2 == 2) {
                throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
            }
            if (n == 7 || n2 == 7) {
                throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
            }
            if (n == 6 || n2 == 6) {
                throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
            }
            if (n == 91 || n2 == 91) {
                throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
            }
            if (n == 3 || n2 == 3) {
                throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
            }
            if (n == 93 || n2 == 93) {
                throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
            }
        }
        return expressionType;
    }

    private ExpressionType HandleBooleanType(ExprTypeHelper exprTypeHelper) {
        ExpressionType expressionType = new ExpressionType();
        int n = exprTypeHelper.leftExprType.type;
        ExpressionType expressionType2 = n == 16 ? exprTypeHelper.righExprType : exprTypeHelper.leftExprType;
        if (expressionType2.type == 16 || expressionType2.type == 0) {
            expressionType.setExpressionType(16, -1, -1, -1);
        } else {
            if (expressionType2.type == 2005) {
                throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
            }
            if (expressionType2.type == 2005) {
                throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
            }
            if (expressionType2.type == 8) {
                expressionType.setExpressionType(8, expressionType2.length, expressionType2.precision, expressionType2.scale);
            } else {
                if (expressionType2.type == 1) {
                    throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
                }
                if (expressionType2.type == 12) {
                    throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
                }
                if (expressionType2.type == 5 || expressionType2.type == 2 | expressionType2.type == 7 || expressionType2.type == 6 || expressionType2.type == 3 || expressionType2.type == 4 || expressionType2.type == -5) {
                    expressionType.setExpressionType(expressionType2.type, expressionType2.length, expressionType2.precision, expressionType2.scale);
                } else {
                    if (expressionType2.type == 91) {
                        throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
                    }
                    if (expressionType2.type == 93) {
                        throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
                    }
                    if (expressionType2.type == 92) {
                        throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
                    }
                }
            }
        }
        return expressionType;
    }

    private ExpressionType HandleCharType(ExprTypeHelper exprTypeHelper) {
        ExpressionType expressionType;
        ExpressionType expressionType2 = new ExpressionType();
        int n = exprTypeHelper.leftExprType.type;
        String string = exprTypeHelper.Operator;
        ExpressionType expressionType3 = null;
        if (!string.equals("||")) {
            throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
        }
        if (n == 1) {
            expressionType = exprTypeHelper.righExprType;
            expressionType3 = exprTypeHelper.leftExprType;
        } else {
            expressionType = exprTypeHelper.leftExprType;
            expressionType3 = exprTypeHelper.righExprType;
        }
        if (expressionType.type == 1 || expressionType.type == 0) {
            expressionType2.setExpressionType(1, expressionType3.length + expressionType.length, -1, -1);
        } else if (expressionType.type == 12) {
            expressionType2.setExpressionType(12, expressionType3.length + expressionType.length, -1, -1);
        } else if (expressionType.type == 5) {
            this.ConvertSmallIntToCharType(expressionType2, expressionType3);
        } else if (expressionType.type == 4) {
            this.ConvertIntToCharType(expressionType2, expressionType3);
        } else if (expressionType.type == -5) {
            this.ConvertBigIntToCharType(expressionType2, expressionType3);
        } else if (expressionType.type == 7 || expressionType.type == 6) {
            this.ConvertRealToChar(expressionType, expressionType2, expressionType3);
        } else if (expressionType.type == 91) {
            expressionType2.setExpressionType(1, expressionType3.length + 30, -1, -1);
        } else if (expressionType.type == 3 || expressionType.type == 2) {
            this.ConvertNumTypeCharType(expressionType, expressionType2, expressionType3);
        } else if (expressionType.type == 93) {
            expressionType2.setExpressionType(1, expressionType3.length + 30, -1, -1);
        }
        return expressionType2;
    }

    private void ConvertRealToChar(ExpressionType expressionType, ExpressionType expressionType2, ExpressionType expressionType3) {
        if (expressionType.length <= 0) {
            expressionType2.setExpressionType(expressionType3.type, expressionType3.length + 16, -1, -1);
        } else {
            expressionType2.setExpressionType(expressionType3.type, expressionType3.length + expressionType.length, -1, -1);
        }
    }

    private void ConvertNumTypeCharType(ExpressionType expressionType, ExpressionType expressionType2, ExpressionType expressionType3) {
        if (expressionType.length <= 0) {
            expressionType2.setExpressionType(expressionType3.type, expressionType3.length + 5, -1, -1);
        } else {
            expressionType2.setExpressionType(expressionType3.type, expressionType3.length + expressionType.length, -1, -1);
        }
    }

    private ExpressionType HandleVarCharType(ExprTypeHelper exprTypeHelper) {
        ExpressionType expressionType = new ExpressionType();
        int n = exprTypeHelper.leftExprType.type;
        String string = exprTypeHelper.Operator;
        ExpressionType expressionType2 = null;
        ExpressionType expressionType3 = null;
        if (n == 1) {
            expressionType2 = exprTypeHelper.righExprType;
            expressionType3 = exprTypeHelper.leftExprType;
        } else {
            expressionType2 = exprTypeHelper.leftExprType;
            expressionType3 = exprTypeHelper.righExprType;
        }
        if (!string.equals("||")) {
            throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
        }
        if (expressionType2.type == 12 || expressionType2.type == 0) {
            expressionType.setExpressionType(12, expressionType3.length + expressionType2.length, -1, -1);
        } else if (expressionType2.type == 5) {
            this.ConvertSmallIntToCharType(expressionType, expressionType3);
        } else if (expressionType2.type == 4) {
            this.ConvertIntToCharType(expressionType, expressionType3);
        } else if (expressionType2.type == -5) {
            this.ConvertBigIntToCharType(expressionType, expressionType3);
        } else if (expressionType2.type == 2 || expressionType2.type == 3) {
            this.ConvertNumTypeCharType(expressionType2, expressionType, expressionType3);
        } else if (expressionType2.type == 7 || expressionType2.type == 6) {
            this.ConvertRealToChar(expressionType2, expressionType, expressionType3);
        } else if (expressionType2.type == 91) {
            expressionType.setExpressionType(12, expressionType3.length + 30, -1, -1);
        } else if (expressionType2.type == 93) {
            expressionType.setExpressionType(12, expressionType3.length + 30, -1, -1);
        }
        return expressionType;
    }

    public void ConvertSmallIntToCharType(ExpressionType expressionType, ExpressionType expressionType2) {
        expressionType.setExpressionType(expressionType2.type, expressionType2.length + 10, -1, -1);
    }

    public void ConvertIntToCharType(ExpressionType expressionType, ExpressionType expressionType2) {
        expressionType.setExpressionType(expressionType2.type, expressionType2.length + 11, -1, -1);
    }

    public void ConvertBigIntToCharType(ExpressionType expressionType, ExpressionType expressionType2) {
        expressionType.setExpressionType(expressionType2.type, expressionType2.length + 17, -1, -1);
    }

    private ExpressionType HandleTimeStamp(ExprTypeHelper exprTypeHelper) {
        ExpressionType expressionType = new ExpressionType();
        int n = exprTypeHelper.leftExprType.type;
        int n2 = exprTypeHelper.righExprType.type;
        if (n == 93 && n2 == 93 && exprTypeHelper.Operator.equals("-")) {
            expressionType.setExpressionType(1111, 1111, -1, -1);
            return expressionType;
        }
        if (n == 93 || n2 == 93 || n == 0 || n2 == 0) {
            expressionType.setExpressionType(93, TIMESTAMPLEN, -1, -1);
        }
        return expressionType;
    }

    private ExpressionType HandleOther(ExprTypeHelper exprTypeHelper) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(1111, 1111, -1, -1);
        return expressionType;
    }

    private ExpressionType HandleDecimal(ExprTypeHelper exprTypeHelper) {
        ExpressionType expressionType = new ExpressionType();
        int n = exprTypeHelper.leftExprType.type;
        int n2 = exprTypeHelper.righExprType.type;
        String string = exprTypeHelper.Operator;
        ExpressionType expressionType2 = null;
        ExpressionType expressionType3 = null;
        if (string.equals("||")) {
            throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
        }
        if (n == 1) {
            expressionType2 = exprTypeHelper.righExprType;
            expressionType3 = exprTypeHelper.leftExprType;
        } else {
            expressionType2 = exprTypeHelper.leftExprType;
            expressionType3 = exprTypeHelper.righExprType;
        }
        if (expressionType2.type == 3 || expressionType2.type == 0) {
            expressionType = ExpressionType.MergeNumericTypes(expressionType2, expressionType3);
        } else if (n == 93 || n2 == 93) {
            throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
        }
        return expressionType;
    }

    private ExpressionType HandleDate(ExprTypeHelper exprTypeHelper) {
        int n = exprTypeHelper.leftExprType.type;
        int n2 = exprTypeHelper.righExprType.type;
        int n3 = -1;
        n3 = n == 91 ? n2 : n;
        if (n3 == 0) {
            ExpressionType expressionType = new ExpressionType();
            expressionType.type = 91;
            expressionType.precision = -1;
            expressionType.length = DATELEN;
            expressionType.scale = -1;
            return expressionType;
        }
        if (n3 == 1111) {
            ExpressionType expressionType = new ExpressionType();
            expressionType.type = 93;
            expressionType.precision = -1;
            expressionType.length = DATELEN;
            expressionType.scale = -1;
            return expressionType;
        }
        if (n3 == 92) {
            ExpressionType expressionType = new ExpressionType();
            expressionType.type = 92;
            expressionType.precision = -1;
            expressionType.length = TIMELEN;
            expressionType.scale = -1;
            return expressionType;
        }
        if (n3 == 91) {
            ExpressionType expressionType = new ExpressionType();
            expressionType.type = 91;
            expressionType.precision = -1;
            expressionType.length = DATELEN;
            expressionType.scale = -1;
            return expressionType;
        }
        if (n3 == 93) {
            ExpressionType expressionType = new ExpressionType();
            expressionType.type = 12;
            expressionType.length = VARCHAR_MAX;
            expressionType.precision = -1;
            expressionType.scale = -1;
            return expressionType;
        }
        throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
    }

    private ExpressionType HandleFloat(ExprTypeHelper exprTypeHelper) {
        ExpressionType expressionType = new ExpressionType();
        int n = exprTypeHelper.leftExprType.type;
        ExpressionType expressionType2 = null;
        ExpressionType expressionType3 = null;
        if (n == 6) {
            expressionType2 = exprTypeHelper.righExprType;
            expressionType3 = exprTypeHelper.leftExprType;
        } else {
            expressionType2 = exprTypeHelper.leftExprType;
            expressionType3 = exprTypeHelper.righExprType;
        }
        if (expressionType2.type == 6 || expressionType2.type == 3 || expressionType2.type == 0) {
            expressionType = ExpressionType.MergeNumericTypes(expressionType2, expressionType3);
        } else {
            if (expressionType2.type == 91) {
                throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
            }
            if (expressionType2.type == 93) {
                throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
            }
        }
        return expressionType;
    }

    private ExpressionType HandleReal(ExprTypeHelper exprTypeHelper) {
        ExpressionType expressionType = new ExpressionType();
        int n = exprTypeHelper.leftExprType.type;
        ExpressionType expressionType2 = null;
        ExpressionType expressionType3 = null;
        if (n == 7) {
            expressionType2 = exprTypeHelper.righExprType;
            expressionType3 = exprTypeHelper.leftExprType;
        } else {
            expressionType2 = exprTypeHelper.leftExprType;
            expressionType3 = exprTypeHelper.righExprType;
        }
        if (expressionType2.type == 7 || expressionType2.type == 6 || expressionType2.type == 3 || expressionType2.type == 0) {
            expressionType = ExpressionType.MergeNumericTypes(expressionType2, expressionType3);
        } else {
            if (expressionType2.type == 91) {
                throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
            }
            if (expressionType2.type == 93) {
                throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
            }
        }
        return expressionType;
    }

    private ExpressionType HandleNumeric(ExprTypeHelper exprTypeHelper) {
        ExpressionType expressionType = new ExpressionType();
        int n = exprTypeHelper.leftExprType.type;
        ExpressionType expressionType2 = null;
        ExpressionType expressionType3 = null;
        if (n == 2) {
            expressionType2 = exprTypeHelper.righExprType;
            expressionType3 = exprTypeHelper.leftExprType;
        } else {
            expressionType2 = exprTypeHelper.leftExprType;
            expressionType3 = exprTypeHelper.righExprType;
        }
        if (expressionType2.type == 2 || expressionType2.type == 7 || expressionType2.type == 6 || expressionType2.type == 3 || expressionType2.type == 0) {
            expressionType = ExpressionType.MergeNumericTypes(expressionType2, expressionType3);
        } else {
            if (expressionType2.type == 91) {
                throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
            }
            if (expressionType2.type == 93) {
                throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
            }
        }
        return expressionType;
    }

    public static ExpressionType MergeNumericTypes(ExpressionType expressionType, ExpressionType expressionType2) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        int n5 = expressionType.getTypePrecedence();
        int n6 = expressionType2.getTypePrecedence();
        n4 = n6 < n5 ? expressionType2.type : expressionType.type;
        ExpressionType expressionType3 = new ExpressionType();
        if (n4 == 8) {
            expressionType3.setExpressionType(n4, 38, 0, 0);
            return expressionType3;
        }
        expressionType.determinePrecisionValues(expressionType);
        expressionType2.determinePrecisionValues(expressionType2);
        int n7 = expressionType.precision;
        int n8 = expressionType.scale;
        int n9 = expressionType2.precision;
        int n10 = expressionType2.scale;
        n2 = n7 + n9;
        n3 = n8 + n10;
        if (n2 > 38) {
            n2 = 0;
            n3 = 0;
            n = 38;
            n4 = 6;
        } else if (n2 < 38) {
            // empty if block
        }
        n = n2;
        expressionType3.setExpressionType(n4, n, n2, n3);
        return expressionType3;
    }

    void determinePrecisionValues(ExpressionType expressionType) {
        if (expressionType.type == 4) {
            expressionType.length = 10;
            expressionType.precision = 10;
            expressionType.scale = 0;
        } else if (expressionType.type == 5) {
            expressionType.length = 5;
            expressionType.precision = 5;
            expressionType.scale = 0;
        } else if (expressionType.type == -5) {
            expressionType.length = 16;
            expressionType.precision = 16;
            expressionType.scale = 0;
        } else if (expressionType.type == 6 || expressionType.type == 7) {
            if (expressionType.length == 0) {
                expressionType.length = 16;
                expressionType.precision = 16;
                expressionType.scale = 0;
            } else {
                expressionType.precision = this.length;
                this.scale = 0;
            }
        } else if (expressionType.type == 2 || expressionType.type == 3) {
            this.length = expressionType.length;
            this.precision = expressionType.precision == -1 ? 0 : expressionType.precision;
            this.scale = expressionType.scale == -1 ? 0 : expressionType.scale;
        } else if (expressionType.type == 8) {
            this.length = 38;
            this.precision = 38;
            this.scale = 0;
        }
    }

    private ExpressionType HandleInt(ExprTypeHelper exprTypeHelper) {
        ExpressionType expressionType = new ExpressionType();
        int n = exprTypeHelper.leftExprType.type;
        ExpressionType expressionType2 = null;
        ExpressionType expressionType3 = null;
        if (n == 4) {
            expressionType2 = exprTypeHelper.righExprType;
            expressionType3 = exprTypeHelper.leftExprType;
        } else {
            expressionType2 = exprTypeHelper.leftExprType;
            expressionType3 = exprTypeHelper.righExprType;
        }
        if (expressionType2.type == 4 || expressionType2.type == 5 || expressionType2.type == -5 || expressionType2.type == 0) {
            expressionType.setExpressionType(6, 32, 0, 0);
        } else if (expressionType2.type == 2 || expressionType2.type == 7 || expressionType2.type == 6 || expressionType2.type == 3) {
            expressionType = ExpressionType.MergeNumericTypes(expressionType2, expressionType3);
        } else if (expressionType2.type == 91) {
            expressionType.setExpressionType(91, DATELEN, -1, -1);
        } else if (expressionType2.type == 93) {
            expressionType.setExpressionType(93, TIMESTAMPLEN, -1, -1);
        }
        return expressionType;
    }

    private ExpressionType HandleBigInt(ExprTypeHelper exprTypeHelper) {
        ExpressionType expressionType = new ExpressionType();
        int n = exprTypeHelper.leftExprType.type;
        ExpressionType expressionType2 = null;
        ExpressionType expressionType3 = null;
        if (n == -5) {
            expressionType2 = exprTypeHelper.righExprType;
            expressionType3 = exprTypeHelper.leftExprType;
        } else {
            expressionType2 = exprTypeHelper.leftExprType;
            expressionType3 = exprTypeHelper.righExprType;
        }
        if (expressionType2.type == 4 || expressionType2.type == 5 || expressionType2.type == -5 || expressionType2.type == 0) {
            expressionType.setExpressionType(6, 32, 0, 0);
        } else if (expressionType2.type == 2 || expressionType2.type == 7 || expressionType2.type == 6 || expressionType2.type == 3) {
            expressionType = ExpressionType.MergeNumericTypes(expressionType2, expressionType3);
        } else if (expressionType2.type == 91) {
            expressionType.setExpressionType(91, DATELEN, -1, -1);
        } else if (expressionType2.type == 93) {
            expressionType.setExpressionType(93, TIMESTAMPLEN, -1, -1);
        }
        return expressionType;
    }

    private ExpressionType HandleSmallInt(ExprTypeHelper exprTypeHelper) {
        ExpressionType expressionType = new ExpressionType();
        int n = exprTypeHelper.leftExprType.type;
        ExpressionType expressionType2 = null;
        ExpressionType expressionType3 = null;
        if (n == 5) {
            expressionType2 = exprTypeHelper.righExprType;
            expressionType3 = exprTypeHelper.leftExprType;
        } else {
            expressionType2 = exprTypeHelper.leftExprType;
            expressionType3 = exprTypeHelper.righExprType;
        }
        if (expressionType2.type == 2 || expressionType2.type == 7 || expressionType2.type == 6 || expressionType2.type == 3 || expressionType2.type == 4 || expressionType2.type == -5 || expressionType2.type == 0) {
            expressionType = ExpressionType.MergeNumericTypes(expressionType2, expressionType3);
        } else if (expressionType2.type == 91) {
            expressionType.setExpressionType(91, DATELEN, -1, -1);
        } else if (expressionType2.type == 93) {
            expressionType.setExpressionType(93, TIMESTAMPLEN, -1, -1);
        }
        return expressionType;
    }

    private ExpressionType HandleDoublePrecison(ExprTypeHelper exprTypeHelper) {
        ExpressionType expressionType = new ExpressionType();
        int n = exprTypeHelper.leftExprType.type;
        ExpressionType expressionType2 = null;
        ExpressionType expressionType3 = null;
        if (n == 8) {
            expressionType2 = exprTypeHelper.righExprType;
            expressionType3 = exprTypeHelper.leftExprType;
        } else {
            expressionType2 = exprTypeHelper.leftExprType;
            expressionType3 = exprTypeHelper.righExprType;
        }
        if (expressionType2.type == 8 || expressionType2.type == 4 || expressionType2.type == -5 || expressionType2.type == 2 || expressionType2.type == 7 || expressionType2.type == 5 || expressionType2.type == 6 || expressionType2.type == 3 || expressionType2.type == 0) {
            if (exprTypeHelper.Operator == "~") {
                expressionType.setExpressionType(16, -1, -1, -1);
            } else {
                expressionType = ExpressionType.MergeNumericTypes(expressionType2, expressionType3);
            }
        } else if (expressionType2.type == 91) {
            expressionType.setExpressionType(91, DATELEN, -1, -1);
        } else if (expressionType2.type == 93) {
            expressionType.setExpressionType(93, TIMESTAMPLEN, -1, -1);
        } else if (expressionType2.type == 1 || expressionType2.type == 12) {
            expressionType.setExpressionType(expressionType2.type, expressionType2.length + expressionType3.length, -1, -1);
        }
        if (expressionType.type == 0) {
            expressionType.setExpressionType(8, -1, -1, -1);
        }
        return expressionType;
    }

    private ExpressionType HandleClobType(ExprTypeHelper exprTypeHelper) {
        throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
    }

    private ExpressionType HandleTimeType(ExprTypeHelper exprTypeHelper) {
        ExpressionType expressionType = new ExpressionType();
        int n = exprTypeHelper.leftExprType.type;
        ExpressionType expressionType2 = null;
        ExpressionType expressionType3 = null;
        if (n == 92) {
            expressionType2 = exprTypeHelper.righExprType;
            expressionType3 = exprTypeHelper.leftExprType;
        } else {
            expressionType2 = exprTypeHelper.leftExprType;
            expressionType3 = exprTypeHelper.righExprType;
        }
        if (expressionType2.type == 0 || expressionType2.type == 91) {
            expressionType = expressionType3;
            return expressionType;
        }
        throw new InvalidExpressionException(exprTypeHelper.leftExprType, exprTypeHelper.Operator, exprTypeHelper.righExprType);
    }

    public int getTypePrecedence() {
        int n = 0;
        switch (this.type) {
            case 5: {
                n = 6;
                break;
            }
            case 4: {
                n = 5;
                break;
            }
            case -5: {
                n = 4;
                break;
            }
            case 7: {
                n = 3;
                break;
            }
            case 6: {
                n = 3;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            case 8: {
                n = 1;
                break;
            }
            case 0: {
                n = 7;
            }
        }
        return n;
    }

    public int getByteLength() {
        int n;
        switch (this.type) {
            case -7: {
                n = 1;
                break;
            }
            case -2: {
                n = this.length;
                break;
            }
            case -3: {
                n = this.length;
                break;
            }
            case 1: {
                n = this.length;
                break;
            }
            case 12: {
                n = this.length / 3;
                break;
            }
            case 5: {
                n = 2;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case -5: {
                n = 8;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 2: {
                n = 4;
                break;
            }
            case 7: {
                n = 8;
                break;
            }
            case 6: {
                n = 8;
                break;
            }
            case 91: {
                n = 2;
                break;
            }
            case 92: {
                n = 2;
                break;
            }
            case 93: {
                n = 4;
                break;
            }
            case 8: {
                n = 8;
                break;
            }
            case 16: {
                n = 1;
                break;
            }
            case 2005: {
                n = 1;
                break;
            }
            case 2004: {
                n = 1;
                break;
            }
            case 1111: {
                n = 12;
                break;
            }
            default: {
                throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + "(" + this.type + " )", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
            }
        }
        return n;
    }
}

