/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata;

import com.edb.gridsql.engine.io.ResponseMessage;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;

public class NodeDBConnectionInfo
implements Serializable {
    private static final long serialVersionUID = 1817345309110297873L;
    private int nodeID;
    private String dbHost;
    private int dbPort;
    private String dbName;
    private String dbUser;
    private String dbPassword;
    private Properties extraProperties;

    public NodeDBConnectionInfo() {
    }

    NodeDBConnectionInfo(int n, String string, int n2, String string2, String string3, String string4, Properties properties) {
        this.nodeID = n;
        this.dbHost = string;
        this.dbPort = n2;
        this.dbName = string2;
        this.dbUser = string3;
        this.dbPassword = string4;
        this.extraProperties = properties == null ? new Properties() : properties;
    }

    public NodeDBConnectionInfo(ResponseMessage responseMessage) {
        this.nodeID = responseMessage.readInt();
        this.dbHost = responseMessage.readString();
        this.dbPort = responseMessage.readInt();
        this.dbName = responseMessage.readString();
        this.dbUser = responseMessage.readString();
        this.dbPassword = responseMessage.readString();
        this.extraProperties = new Properties();
        for (int i = responseMessage.readInt(); i > 0; --i) {
            String string = responseMessage.readString();
            String string2 = responseMessage.readString();
            this.extraProperties.put(string, string2);
        }
    }

    public String getDbHost() {
        return this.dbHost;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public int getDbPort() {
        return this.dbPort;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public int getNodeID() {
        return this.nodeID;
    }

    public Map getProperties() {
        return Collections.unmodifiableMap(this.extraProperties);
    }
}

