/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine.loader;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.engine.loader.CsvProcessorThread;
import com.edb.gridsql.engine.loader.DataProcessorThread;
import com.edb.gridsql.engine.loader.DataReaderAndProcessorBuffer;
import com.edb.gridsql.engine.loader.DefaultWriterFactory;
import com.edb.gridsql.engine.loader.EDBWriterFactory;
import com.edb.gridsql.engine.loader.ILoaderConfigInformation;
import com.edb.gridsql.engine.loader.INodeWriter;
import com.edb.gridsql.engine.loader.INodeWriterFactory;
import com.edb.gridsql.engine.loader.IUniqueValueProvider;
import com.edb.gridsql.engine.loader.ResultSetProcessorThread;
import com.edb.gridsql.engine.loader.ResultSetReaderThread;
import com.edb.gridsql.engine.loader.StreamReaderThread;
import com.edb.gridsql.engine.loader.TableColumnDescription;
import com.edb.gridsql.engine.loader.TextProcessorThread;
import com.edb.gridsql.exception.XDBDataReaderException;
import com.edb.gridsql.exception.XDBGeneratorException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.NodeDBConnectionInfo;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysRowIDHandler;
import com.edb.gridsql.metadata.SysSerialGenerator;
import com.edb.gridsql.metadata.SysSerialIDHandler;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.partitions.PartitionMap;
import com.edb.gridsql.parser.ExpressionType;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Loader
implements ILoaderConfigInformation {
    private static final XLogger logger = XLogger.getLogger(Loader.class);
    private static final String HEADER_COLUMN_SEPARATOR_KEY = "xdb.loader.header.columnseparator";
    private static final String HEADER_TEMPLATE_KEY = "xdb.loader.header.template";
    private static final String FOOTER_COLUMN_SEPARATOR_KEY = "xdb.loader.footer.columnseparator";
    private static final String FOOTER_TEMPLATE_KEY = "xdb.loader.footer.template";
    private static final String ROW_COLUMN_SEPARATOR_KEY = "xdb.loader.row.columnseparator";
    private static ExecutorService executorService = Executors.newCachedThreadPool();
    private DataProcessorThread[] dpThreads;
    private ResultSet inputRS = null;
    private InputStream inputStream = null;
    private char separator = (char)9;
    private String valueNULL = "\\N";
    private char quoteChar;
    private char quoteEscape = this.quoteChar = (char)34;
    private String forcenotnullinfo = Props.XDB_LOADER_NODEWRITER_CSV_FORCENOTNULLINFO_NONE;
    private String columninfo = Props.XDB_LOADER_NODEWRITER_COLUMNINFO_NONE;
    private XDBSessionContext client = null;
    private SysTable table = null;
    private NodeDBConnectionInfo[] nodeInfos;
    private String tableName;
    private List<TableColumnDescription> columns;
    private int partColumn;
    private int serialColumnPosition;
    private PartitionMap partitionMap;
    private ExpressionType hashDataType;
    private INodeWriterFactory writerFactory;
    private HashMap<Integer, INodeWriter> writers;
    private long rowCount = 0L;
    private boolean isDestTypeNodeId = false;
    private boolean suppressSendingNodeId = false;
    private int serialColumn = -1;
    private int xrowidColumn = -1;
    private long maxSuppliedSerialValue = -1L;
    private long maxSuppliedRowIDValue = -1L;
    private IUniqueValueProvider rowIdProvider = null;
    private IUniqueValueProvider serialProvider = null;
    private HashMap<Integer, Long> rowCountMap;
    private DATA_SOURCE dataSource;

    public Loader(ResultSet resultSet, String string) {
        this.inputRS = resultSet;
        this.setColumns(string);
        this.setFieldDelimiter(Props.XDB_LOADER_NODEWRITER_DEFAULT_DELIMITER);
        this.setNullValue(Props.XDB_LOADER_NODEWRITER_DEFAULT_NULL);
        this.dataSource = DATA_SOURCE.RESULT_SET;
    }

    public Loader(String string, String string2) {
        this.setFieldDelimiter(string);
        this.setNullValue(string2);
    }

    public void setDataSource(InputStream inputStream) {
        this.inputStream = inputStream;
        if (this.dataSource != DATA_SOURCE.CSV) {
            this.dataSource = DATA_SOURCE.TEXT;
        }
    }

    public void setDataSource(String string) throws IOException {
        this.setDataSource(new FileInputStream(string));
    }

    public void setQuotes(char c, char c2) {
        this.quoteChar = c;
        this.quoteEscape = c2;
        this.dataSource = DATA_SOURCE.CSV;
    }

    public void setNullValue(String string) {
        this.valueNULL = string;
    }

    public void setFieldDelimiter(String string) {
        if (string == null || string.length() == 0) {
            string = Props.XDB_LOADER_NODEWRITER_DEFAULT_DELIMITER;
        }
        this.separator = string.charAt(0);
    }

    public void setColumns(String string) {
        this.columninfo = string == null || string.length() == 0 ? Props.XDB_LOADER_NODEWRITER_COLUMNINFO_NONE : ParseCmdLine.substitute(Props.XDB_LOADER_NODEWRITER_COLUMNINFO, Collections.singletonMap("columns", string));
    }

    public void setLocalTableInfo(SysTable sysTable, XDBSessionContext xDBSessionContext, List<String> list, boolean bl) throws XDBDataReaderException, XDBGeneratorException {
        this.table = sysTable;
        this.tableName = sysTable.getTableName();
        SysColumn sysColumn = sysTable.getPartitionedColumn();
        int n = this.partColumn = sysColumn == null ? -1 : sysColumn.getColSeq() - 1;
        if (sysColumn != null) {
            this.hashDataType = new ExpressionType(sysColumn);
        }
        this.partitionMap = sysTable.getPartitionMap();
        Collection<DBNode> collection = sysTable.getNodeList();
        this.nodeInfos = new NodeDBConnectionInfo[collection.size()];
        int n2 = 0;
        for (DBNode object3 : collection) {
            this.nodeInfos[n2++] = object3.getNodeDBConnectionInfo();
        }
        if (list == null || list.size() == 0) {
            this.columninfo = Props.XDB_LOADER_NODEWRITER_COLUMNINFO_NONE;
            for (SysColumn sysColumn2 : sysTable.getColumns()) {
                this.appendColumnDescription(sysColumn2.getColName(), sysColumn2.isSerial(), sysColumn2.getColLength(), sysColumn2.isNullable());
                if (!"xrowid".equalsIgnoreCase(sysColumn2.getColName()) || bl) continue;
                this.xrowidColumn = this.columns.size() - 1;
                SysRowIDHandler sysRowIDHandler = sysTable.getRowIDHandler();
                sysRowIDHandler.allocateRange(0L, xDBSessionContext);
                this.setRowIdProvider(new SerialGeneratorProvider(sysRowIDHandler));
            }
        } else {
            SysColumn sysColumn3;
            Object object;
            StringBuilder stringBuilder = new StringBuilder(512);
            for (String string : list) {
                object = sysTable.getSysColumn(string);
                if (object == null) {
                    throw new XDBDataReaderException("Column " + string + " does not exist in table " + this.tableName);
                }
                this.appendColumnDescription(((SysColumn)object).getColName(), ((SysColumn)object).isSerial(), ((SysColumn)object).getColLength(), ((SysColumn)object).isNullable());
                stringBuilder.append(string).append(",");
            }
            SysColumn sysColumn4 = sysTable.getSysColumn("xrowid");
            if (sysColumn4 != null) {
                this.appendColumnDescription(sysColumn4.getColName(), sysColumn4.isSerial(), sysColumn4.getColLength(), sysColumn4.isNullable());
                stringBuilder.append("xrowid").append(",");
                if (!bl) {
                    this.xrowidColumn = this.columns.size() - 1;
                    SysRowIDHandler sysRowIDHandler = sysTable.getRowIDHandler();
                    sysRowIDHandler.allocateRange(0L, xDBSessionContext);
                    this.setRowIdProvider(new SerialGeneratorProvider(sysRowIDHandler));
                }
            }
            if ((sysColumn3 = sysTable.getSerialColumn()) != null && !list.contains(sysColumn3.getColName())) {
                this.appendColumnDescription(sysColumn3.getColName(), sysColumn3.isSerial(), sysColumn3.getColLength(), sysColumn3.isNullable());
                this.serialColumn = this.columns.size() - 1;
                object = sysTable.getSerialHandler();
                ((SysSerialIDHandler)object).allocateRange(0L, xDBSessionContext);
                this.setSerialProvider(new SerialGeneratorProvider((SysSerialGenerator)object));
                stringBuilder.append(sysColumn3.getColName());
            } else {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
            this.columninfo = ParseCmdLine.substitute(Props.XDB_LOADER_NODEWRITER_COLUMNINFO, Collections.singletonMap("columns", stringBuilder.toString()));
        }
        this.client = xDBSessionContext;
    }

    public void setTargetTableInfoExt(String string, int n, PartitionMap partitionMap, ExpressionType expressionType, int n2, SysSerialGenerator sysSerialGenerator, boolean bl, boolean bl2, NodeDBConnectionInfo[] nodeDBConnectionInfoArray) {
        this.tableName = string;
        this.partColumn = n;
        this.partitionMap = partitionMap;
        this.serialColumnPosition = n2;
        this.isDestTypeNodeId = bl;
        this.suppressSendingNodeId = bl2;
        this.nodeInfos = nodeDBConnectionInfoArray;
        this.hashDataType = expressionType;
        this.setSerialProvider(new SerialGeneratorProvider(sysSerialGenerator));
    }

    public void setTargetTableInfo(String string, String string2, NodeDBConnectionInfo[] nodeDBConnectionInfoArray) {
        this.tableName = string;
        this.nodeInfos = nodeDBConnectionInfoArray;
        this.partColumn = -1;
        if (string2 != null) {
            Iterator<TableColumnDescription> iterator = this.columns.iterator();
            int n = 0;
            TableColumnDescription tableColumnDescription = null;
            while (iterator.hasNext()) {
                tableColumnDescription = iterator.next();
                if (string2.equals(tableColumnDescription.getName())) {
                    this.partColumn = n;
                    break;
                }
                ++n;
            }
        }
    }

    public void appendColumnDescription(String string, boolean bl, int n, boolean bl2) {
        if (this.columns == null) {
            this.columns = new LinkedList<TableColumnDescription>();
        }
        TableColumnDescription tableColumnDescription = new TableColumnDescription();
        tableColumnDescription.setName(string);
        tableColumnDescription.setSerial(bl);
        tableColumnDescription.setLength(n);
        tableColumnDescription.setNullable(bl2);
        this.columns.add(tableColumnDescription);
    }

    public void setGenerateSerial(boolean bl) throws Exception {
        this.serialColumn = -1;
        if (bl && this.columns != null) {
            int n = 0;
            Iterator<TableColumnDescription> iterator = this.columns.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().isSerial()) {
                    this.serialColumn = n;
                    break;
                }
                ++n;
            }
        }
    }

    public void setVerbose(boolean bl) {
    }

    public boolean getGenerateSerial() {
        return this.serialColumn >= 0;
    }

    public boolean getGenerateRowID() {
        return this.xrowidColumn >= 0;
    }

    public void prepareLoad(String string) throws Exception {
        String string2;
        String string3;
        this.writerFactory = Props.USE_EDB_JDBC_COPY ? new EDBWriterFactory() : new DefaultWriterFactory();
        if (this.nodeInfos != null) {
            this.writerFactory.setNodeConnectionInfos(this.nodeInfos);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("table", IdentifierHandler.quote(this.tableName));
        String string4 = null;
        String string5 = Property.get(HEADER_TEMPLATE_KEY);
        if (string5 != null && string5.length() > 0) {
            if (this.columns != null) {
                string4 = Property.get(HEADER_COLUMN_SEPARATOR_KEY, ",");
                this.putColumnsToMap(string4, hashMap);
            }
            hashMap.put("outheader", ParseCmdLine.substitute(string5, hashMap));
        }
        if ((string3 = Property.get(FOOTER_TEMPLATE_KEY)) != null && string3.length() > 0) {
            string2 = Property.get(FOOTER_COLUMN_SEPARATOR_KEY, ",");
            if (this.columns != null && !string2.equals(string4)) {
                string4 = string2;
                this.putColumnsToMap(string4, hashMap);
            }
            hashMap.put("outfooter", ParseCmdLine.substitute(string3, hashMap));
        }
        string2 = Property.get(ROW_COLUMN_SEPARATOR_KEY, ",");
        if (this.columns != null && !string2.equals(string4)) {
            string4 = string2;
            this.putColumnsToMap(string4, hashMap);
        }
        hashMap.put("columninfo", this.columninfo);
        hashMap.put("delimiter", ParseCmdLine.escape("" + this.separator));
        hashMap.put("null", ParseCmdLine.escape(this.valueNULL));
        hashMap.put("quote", ParseCmdLine.escape("" + this.quoteChar));
        hashMap.put("escape", ParseCmdLine.escape("" + this.quoteEscape));
        hashMap.put("forcenotnullinfo", this.forcenotnullinfo);
        this.writerFactory.setParams(this.dataSource, hashMap);
    }

    private void putColumnsToMap(String string, HashMap<String, String> hashMap) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        Iterator<TableColumnDescription> iterator = this.columns.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().getName()).append(string);
        }
        stringBuilder.setLength(stringBuilder.length() - string.length());
        hashMap.put("column_list", stringBuilder.toString());
    }

    @Override
    public char getQuoteEscape() {
        return this.quoteEscape;
    }

    @Override
    public char getQuoteChar() {
        return this.quoteChar;
    }

    public void setPartitionMap(PartitionMap partitionMap) {
        this.partitionMap = partitionMap;
    }

    public void setRowIdProvider(IUniqueValueProvider iUniqueValueProvider) {
        this.rowIdProvider = iUniqueValueProvider;
    }

    public void setSerialProvider(IUniqueValueProvider iUniqueValueProvider) {
        this.serialProvider = iUniqueValueProvider;
    }

    @Override
    public Loader getLoaderInstance() {
        return this;
    }

    @Override
    public INodeWriterFactory getWriterFactory() {
        return this.writerFactory;
    }

    @Override
    public PartitionMap getPartitionMap() {
        return this.partitionMap;
    }

    @Override
    public XDBSessionContext getClient() {
        return this.client;
    }

    @Override
    public SysTable getTableInformation() {
        return this.table;
    }

    @Override
    public List<TableColumnDescription> getTableColumnsInformation() {
        return this.columns;
    }

    @Override
    public IUniqueValueProvider getRowIdProvider() {
        return this.rowIdProvider;
    }

    @Override
    public IUniqueValueProvider getSerialProvider() {
        return this.serialProvider;
    }

    @Override
    public char getSeparator() {
        return this.separator;
    }

    @Override
    public boolean noParse() {
        return this.serialColumn < 1 && this.xrowidColumn < 1 && this.serialColumnPosition < 1;
    }

    @Override
    public boolean destinationTypeNodeId() {
        return this.isDestTypeNodeId;
    }

    @Override
    public boolean suppressSendingNodeId() {
        return this.suppressSendingNodeId;
    }

    @Override
    public int getTableColumnsCount() {
        try {
            if (this.inputRS != null) {
                return this.inputRS.getMetaData().getColumnCount();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return -1;
    }

    @Override
    public int getSerialColumnPosition() {
        return this.serialColumnPosition;
    }

    @Override
    public int getSerialColumnSequence() {
        return this.serialColumn;
    }

    @Override
    public int getPartitionColumnSequence() {
        return this.partColumn;
    }

    @Override
    public int getXRowidColumnSequence() {
        return this.xrowidColumn;
    }

    @Override
    public String getNULLValue() {
        return this.valueNULL;
    }

    public void runWriters() throws Exception {
        int n;
        Callable<Boolean> callable;
        Future[] futureArray;
        Future<Boolean> future;
        if (this.inputRS != null && this.partColumn >= 0 && this.hashDataType == null) {
            this.hashDataType = new ExpressionType();
            future = this.inputRS.getMetaData();
            this.hashDataType.setExpressionType(future.getColumnType(this.partColumn + 1), future.getColumnDisplaySize(this.partColumn + 1), future.getPrecision(this.partColumn + 1), future.getScale(this.partColumn + 1));
        }
        int n2 = this.dataSource == DATA_SOURCE.CSV ? 1 : Props.XDB_LOADER_DATAPROCESSORS_COUNT;
        this.dpThreads = new DataProcessorThread[n2];
        Future[] futureArray2 = new Future[n2];
        if (this.dataSource == DATA_SOURCE.RESULT_SET) {
            futureArray = new DataReaderAndProcessorBuffer(Props.XDB_LOADER_DATAPROCESSOR_BUFFER, this.dataSource);
            callable = new ResultSetReaderThread(this.inputRS, (DataReaderAndProcessorBuffer<String[]>)futureArray);
            future = executorService.submit(callable);
            for (n = 0; n < this.dpThreads.length; ++n) {
                this.dpThreads[n] = new ResultSetProcessorThread((ILoaderConfigInformation)this, n + 1, (DataReaderAndProcessorBuffer<String[]>)futureArray);
                this.dpThreads[n].initializeDataWriters();
                futureArray2[n] = executorService.submit(this.dpThreads[n]);
            }
        } else if (this.inputStream != null) {
            futureArray = new DataReaderAndProcessorBuffer(Props.XDB_LOADER_DATAPROCESSOR_BUFFER, this.dataSource);
            callable = new StreamReaderThread(this.inputStream, (DataReaderAndProcessorBuffer<byte[]>)futureArray, this.dataSource == DATA_SOURCE.CSV);
            future = executorService.submit(callable);
            for (n = 0; n < this.dpThreads.length; ++n) {
                this.dpThreads[n] = this.dataSource == DATA_SOURCE.CSV ? new CsvProcessorThread((ILoaderConfigInformation)this, n + 1, (DataReaderAndProcessorBuffer<byte[]>)futureArray) : new TextProcessorThread((ILoaderConfigInformation)this, n + 1, (DataReaderAndProcessorBuffer<byte[]>)futureArray);
                this.dpThreads[n].initializeDataWriters();
                futureArray2[n] = executorService.submit(this.dpThreads[n]);
            }
        } else {
            throw new Exception("Source is not specified");
        }
        try {
            future.get();
        }
        catch (Exception exception) {
            logger.throwing(exception);
            throw exception;
        }
        for (Future future2 : futureArray2) {
            try {
                this.rowCount += (long)((Integer)future2.get()).intValue();
            }
            catch (Exception exception) {
                logger.throwing(exception);
                throw exception;
            }
        }
        for (DataProcessorThread dataProcessorThread : this.dpThreads) {
            long l = dataProcessorThread.getMaxSuppliedRowIDValue();
            if (l > this.maxSuppliedRowIDValue) {
                this.maxSuppliedRowIDValue = l;
            }
            if ((l = dataProcessorThread.getMaxSuppliedSerialValue()) <= this.maxSuppliedSerialValue) continue;
            this.maxSuppliedSerialValue = l;
        }
        logger.info("Data processing has finished.");
        logger.log(Level.INFO, " %0% input rows have been handed off to Node Writers.", new Object[]{this.rowCount});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishLoad(boolean bl) throws Exception {
        Exception exception = null;
        if (this.dpThreads != null) {
            try {
                for (DataProcessorThread dataProcessorThread : this.dpThreads) {
                    try {
                        dataProcessorThread.finishLoad(bl);
                    }
                    catch (Exception exception2) {
                        if (!bl) continue;
                        exception = exception2;
                        bl = false;
                    }
                }
                if (bl) {
                    for (DataProcessorThread dataProcessorThread : this.dpThreads) {
                        dataProcessorThread.commitLoad();
                    }
                }
                for (DataProcessorThread dataProcessorThread : this.dpThreads) {
                    dataProcessorThread.rollbackLoad();
                }
            }
            finally {
                for (DataProcessorThread dataProcessorThread : this.dpThreads) {
                    dataProcessorThread.close();
                }
            }
        } else {
            try {
                Iterator<INodeWriter> iterator = this.writers.values().iterator();
                while (iterator.hasNext()) {
                    INodeWriter iNodeWriter;
                    INodeWriter iNodeWriter2 = iNodeWriter = iterator.next();
                    try {
                        iNodeWriter2.finish(bl);
                    }
                    catch (Exception exception3) {
                        if (!bl) continue;
                        exception = exception3;
                        bl = false;
                    }
                }
                this.initRowCountMap();
            }
            finally {
                this.writerFactory.close();
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public long getMaxSuppliedSerialValue() {
        return this.maxSuppliedSerialValue;
    }

    public long getMaxSuppliedRowIDValue() {
        return this.maxSuppliedRowIDValue;
    }

    public void initRowCountMap() {
        this.rowCountMap = new HashMap();
        Iterator<Integer> iterator = this.writers.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n;
            Integer n2 = n = iterator.next();
            INodeWriter iNodeWriter = this.writers.get(n2);
            this.rowCountMap.put(n2, iNodeWriter.getRowCount());
        }
    }

    public HashMap<Integer, Long> getRowCountMap() {
        if (this.dpThreads != null) {
            if (this.rowCountMap == null) {
                this.rowCountMap = new HashMap();
            }
            Integer n2 = -1;
            Long l = 0L;
            Long l2 = 0L;
            for (DataProcessorThread dataProcessorThread : this.dpThreads) {
                HashMap<Integer, Long> hashMap = dataProcessorThread.getRowCountMap();
                for (Integer n2 : hashMap.keySet()) {
                    l2 = hashMap.get(n2);
                    l = this.rowCountMap.get(n2);
                    this.rowCountMap.put(n2, l == null ? l2 : l + l2);
                }
            }
            return this.rowCountMap;
        }
        return null;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    @Override
    public ExpressionType getHashDataType() {
        return this.hashDataType;
    }

    public void setForceNotNullColumns(Collection<String> collection) {
        if (collection == null || collection.size() == 0) {
            this.forcenotnullinfo = Props.XDB_LOADER_NODEWRITER_CSV_FORCENOTNULLINFO_NONE;
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            block0: for (String string : collection) {
                stringBuffer.append(string).append(",");
                for (TableColumnDescription tableColumnDescription : this.columns) {
                    if (!string.equalsIgnoreCase(tableColumnDescription.getName())) continue;
                    tableColumnDescription.setNullable(false);
                    continue block0;
                }
            }
            this.forcenotnullinfo = ParseCmdLine.substitute(Props.XDB_LOADER_NODEWRITER_CSV_FORCENOTNULLINFO, Collections.singletonMap("columns", stringBuffer.substring(0, stringBuffer.length() - 1)));
        }
    }

    private static class SerialGeneratorProvider
    implements IUniqueValueProvider {
        private SysSerialGenerator serialGenerator;

        private SerialGeneratorProvider(SysSerialGenerator sysSerialGenerator) {
            this.serialGenerator = sysSerialGenerator;
        }

        public String getNextValue() throws XDBGeneratorException {
            return "" + this.serialGenerator.allocateValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DATA_SOURCE {
        RESULT_SET,
        TEXT,
        CSV,
        BINARY;

    }
}

