/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine;

import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.exception.XDBServerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Level;

public class AckTracker {
    private static final XLogger logger = XLogger.getLogger(AckTracker.class);
    private static final int MAX_ATTEMPTS = Property.getInt("xdb.broadcast.retries", 5);
    private Map packets;
    private Map acknowlegements;
    private Collection nodeList = null;
    private boolean wasNewAck = false;
    private int attempt = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init(Map map, Collection collection) throws XDBServerException {
        if (this.packets != null && !this.packets.isEmpty()) {
            XDBServerException xDBServerException = new XDBServerException("Tracker not empty");
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
        this.packets = map;
        this.nodeList = collection;
        this.acknowlegements = new HashMap();
        if (collection != null && !collection.isEmpty()) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                this.acknowlegements.put(iterator.next(), new HashSet(collection));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() {
        this.packets.clear();
        this.acknowlegements.clear();
        this.notifyAll();
    }

    public synchronized void addPacket(Object object, Object object2) {
        this.addPacket(object, object2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addPacket(Object object, Object object2, Collection collection) {
        if (collection != null && !collection.isEmpty()) {
            this.packets.put(object, object2);
            this.acknowlegements.put(object, new HashSet(collection));
        } else if (this.nodeList != null && !this.nodeList.isEmpty()) {
            this.packets.put(object, object2);
            this.acknowlegements.put(object, new HashSet(this.nodeList));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection getPackets() {
        ArrayList arrayList = null;
        ArrayList arrayList2 = arrayList = this.packets == null ? new ArrayList() : new ArrayList(this.packets.values());
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getUnackedKeyCount() {
        int n = this.acknowlegements.size();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void register(Object object, int n) {
        HashSet hashSet;
        if (this.acknowlegements != null && (hashSet = (HashSet)this.acknowlegements.get(object)) != null) {
            if (hashSet.remove(new Integer(n))) {
                this.wasNewAck = true;
            }
            if (hashSet.isEmpty()) {
                this.acknowlegements.remove(object);
                this.packets.remove(object);
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void waitAcks(long l) {
        this.wasNewAck = false;
        long l2 = System.currentTimeMillis();
        while (this.acknowlegements != null && !this.acknowlegements.isEmpty()) {
            try {
                logger.log(Level.DEBUG, "Start waiting for %0% acknowledgements", new Object[]{new Integer(this.acknowlegements.size())});
                this.wait(l);
                logger.log(Level.DEBUG, "Stop waiting for %0% acknowledgements", new Object[]{new Integer(this.acknowlegements.size())});
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (l2 + l >= System.currentTimeMillis()) continue;
            if (this.wasNewAck) {
                this.attempt = 0;
                return;
            }
            if (++this.attempt >= MAX_ATTEMPTS) {
                this.attempt = 0;
                throw new XDBServerException("Any acknowlegement has not been received while waiting");
            }
            logger.debug("Any acknowlegement has not been received while waiting, attempt " + this.attempt);
            return;
        }
        this.packets = null;
    }
}

