/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.common.util;

import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseCmdLine {
    public static String substitute(String string, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            string = string.replace("{" + entry.getKey() + "}", "" + entry.getValue());
        }
        return string;
    }

    public static String[] splitCmdLine(String string) {
        if (string == null) {
            throw new XDBServerException("Missed cmd string");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    public static String stripEscapes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (char c : string.toCharArray()) {
            if (bl) {
                switch (c) {
                    case '\\': {
                        stringBuffer.append("\\");
                        break;
                    }
                    case 'n': {
                        stringBuffer.append("\n");
                        break;
                    }
                    case 'r': {
                        stringBuffer.append("\r");
                        break;
                    }
                    case 't': {
                        stringBuffer.append("\t");
                        break;
                    }
                    case 'b': {
                        stringBuffer.append("\b");
                        break;
                    }
                    case 'f': {
                        stringBuffer.append("\f");
                        break;
                    }
                    case '\"': {
                        stringBuffer.append("\"");
                        break;
                    }
                    case '\'': {
                        stringBuffer.append("'");
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
                bl = false;
                continue;
            }
            if (c == '\\') {
                bl = true;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String escape(String string) {
        return ParseCmdLine.escape(string, -1);
    }

    public static String escape(String string, int n) {
        int n2 = 0;
        StringBuffer stringBuffer = null;
        boolean bl = false;
        if (n != -1) {
            bl = true;
        }
        for (char c : string.toCharArray()) {
            switch (c) {
                case '\\': {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(2 * string.length() + 1);
                        stringBuffer.append(string.subSequence(0, n2));
                    }
                    stringBuffer.append("\\\\");
                    break;
                }
                case '\n': {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(2 * string.length() + 1);
                        stringBuffer.append(string.subSequence(0, n2));
                    }
                    stringBuffer.append("\\n");
                    break;
                }
                case '\r': {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(2 * string.length() + 1);
                        stringBuffer.append(string.subSequence(0, n2));
                    }
                    stringBuffer.append("\\r");
                    break;
                }
                case '\t': {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(2 * string.length() + 1);
                        stringBuffer.append(string.subSequence(0, n2));
                    }
                    stringBuffer.append("\\t");
                    break;
                }
                case '\b': {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(2 * string.length() + 1);
                        stringBuffer.append(string.subSequence(0, n2));
                    }
                    stringBuffer.append("\\b");
                    break;
                }
                case '\f': {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(2 * string.length() + 1);
                        stringBuffer.append(string.subSequence(0, n2));
                    }
                    stringBuffer.append("\\f");
                    break;
                }
                case '\'': {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(2 * string.length() + 1);
                        stringBuffer.append(string.subSequence(0, n2));
                    }
                    stringBuffer.append("''");
                    break;
                }
                default: {
                    if (stringBuffer != null) {
                        if (bl && c == n) {
                            stringBuffer.append("\\");
                            stringBuffer.append(n);
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    if (!bl || c != n) break;
                    stringBuffer = new StringBuffer(2 * string.length() + 1);
                    stringBuffer.append(string.subSequence(0, n2));
                    stringBuffer.append("\\");
                    stringBuffer.append(n);
                }
            }
            ++n2;
        }
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return string;
    }

    public static String replace(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        ParseCmdLine.replace(stringBuffer, string2, string3, true);
        String string4 = stringBuffer.toString();
        return string4;
    }

    public static void replace(StringBuffer stringBuffer, String string, String string2, boolean bl) {
        if (stringBuffer == null || string == null || string.length() == 0 || string2 == null) {
            throw new XDBServerException(ErrorMessageRepository.ILLEGAL_PARAMETER, 0, ErrorMessageRepository.ILLEGAL_PARAMETER_CODE);
        }
        int n = 0;
        while (n + string.length() <= stringBuffer.length()) {
            if (stringBuffer.substring(n, n + string.length()).equalsIgnoreCase(string)) {
                stringBuffer.replace(n, n + string.length(), string2);
                if (!bl) break;
                n += string2.length();
                continue;
            }
            ++n;
        }
    }
}

