/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.common.util;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.util.XdbImpEx;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputFormatter {
    public String[] field;
    private int[] staPos;
    String[] colNames;
    ResultSet rs;
    private boolean trimTrailingSpaces = false;
    private boolean hasTrailingDelimiter = false;
    private char sFieldSep = Props.XDB_LOADER_NODEWRITER_DEFAULT_DELIMITER.charAt(0);
    private byte[] sTerminator = System.getProperty("line.separator").getBytes();
    private byte[] nullValue = Props.XDB_LOADER_NODEWRITER_DEFAULT_NULL.getBytes();
    private char quoteChar = '\u0000';
    private char quoteEscape = '\u0000';
    private HashSet<String> forceQuoteColumns = null;
    private byte[] rowBuffer = new byte[1024];
    private int position = 0;

    private void ensureCapacity(int n) {
        if (this.rowBuffer.length < n) {
            byte[] byArray = new byte[Math.max(n, this.rowBuffer.length * 2)];
            System.arraycopy(this.rowBuffer, 0, byArray, 0, this.position);
            this.rowBuffer = byArray;
        }
    }

    private void toRowBuffer(byte[] byArray) {
        if (byArray != null && byArray.length > 0) {
            this.ensureCapacity(this.position + byArray.length);
            System.arraycopy(byArray, 0, this.rowBuffer, this.position, byArray.length);
            this.position += byArray.length;
        }
    }

    private void toRowBuffer(byte by) {
        this.ensureCapacity(this.position + 1);
        this.rowBuffer[this.position++] = by;
    }

    public boolean isTrimTrailingSpaces() {
        return this.trimTrailingSpaces;
    }

    public void setTrimTrailingSpaces(boolean bl) {
        this.trimTrailingSpaces = bl;
    }

    public boolean isHasTrailingDelimiter() {
        return this.hasTrailingDelimiter;
    }

    public void setHasTrailingDelimiter(boolean bl) {
        this.hasTrailingDelimiter = bl;
    }

    public void setSFieldSep(String string) {
        this.sFieldSep = string == null || string.length() == 0 ? Props.XDB_LOADER_NODEWRITER_DEFAULT_DELIMITER.charAt(0) : string.charAt(0);
    }

    public void setSTerminator(String string) {
        this.sTerminator = string.getBytes();
    }

    public void setNullValue(String string) {
        this.nullValue = string == null ? Props.XDB_LOADER_NODEWRITER_DEFAULT_NULL.getBytes() : string.getBytes();
    }

    public OutputFormatter(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            this.field = new String[stringTokenizer.countTokens() / 2];
            this.staPos = new int[stringTokenizer.countTokens() / 2];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken(",");
                string2 = string2.trim();
                int n2 = string2.indexOf(" ", 0);
                this.field[n] = string2.substring(0, n2);
                int n3 = XdbImpEx.skipWhiteSpaces(n2, string2);
                n2 = string2.indexOf(":", n3);
                String string3 = string2.substring(n3, n2);
                n3 = n2 + 1;
                n2 = string2.length();
                String string4 = string2.substring(n3, n2);
                string3 = string3.trim();
                string4 = string4.trim();
                this.staPos[n] = Integer.parseInt(string3);
                ++n;
            }
        }
    }

    public long printRS(ResultSet resultSet, OutputStream outputStream) throws SQLException, IOException {
        this.rs = resultSet;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        this.colNames = new String[resultSetMetaData.getColumnCount()];
        for (int i = 0; i < this.colNames.length; ++i) {
            this.colNames[i] = resultSetMetaData.getColumnName(i + 1);
        }
        long l = 0L;
        if (this.field != null) {
            while (resultSet.next()) {
                this.printFormattedRow();
                outputStream.write(this.rowBuffer, 0, this.position);
                this.position = 0;
                ++l;
            }
        } else if (this.quoteChar == '\u0000') {
            while (resultSet.next()) {
                this.printRow();
                outputStream.write(this.rowBuffer, 0, this.position);
                this.position = 0;
                ++l;
            }
        } else {
            for (int i = 0; i < this.colNames.length; ++i) {
                if (!this.forceQuoteColumns.contains(this.colNames[i].toLowerCase())) continue;
                this.colNames[i] = null;
            }
            while (resultSet.next()) {
                this.printCsvRow();
                outputStream.write(this.rowBuffer, 0, this.position);
                this.position = 0;
                ++l;
            }
        }
        return l;
    }

    private void printRow() throws SQLException {
        String string = null;
        for (int i = 0; i < this.colNames.length; ++i) {
            string = this.rs.getString(i + 1);
            if (string == null) {
                this.toRowBuffer(this.nullValue);
            } else {
                if (this.trimTrailingSpaces) {
                    string = this.trimTrailing(string);
                }
                string = ParseCmdLine.escape(string, this.sFieldSep);
                this.toRowBuffer(string.getBytes());
            }
            if (!this.hasTrailingDelimiter && i >= this.colNames.length - 1) continue;
            this.toRowBuffer((byte)this.sFieldSep);
        }
        this.toRowBuffer(this.sTerminator);
    }

    private boolean hasSpecialCharsCSV(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != this.sFieldSep && c != '\n' && c != '\r') continue;
            return true;
        }
        return false;
    }

    private void printCsvRow() throws SQLException {
        String string = null;
        for (int i = 0; i < this.colNames.length; ++i) {
            string = this.rs.getString(i + 1);
            if (string == null) {
                this.toRowBuffer(this.nullValue);
            } else {
                boolean bl;
                boolean bl2 = bl = this.colNames[i] == null || string.length() > 0 && string.charAt(0) == this.quoteChar || Arrays.equals(string.getBytes(), this.nullValue) || this.hasSpecialCharsCSV(string);
                if (bl) {
                    this.toRowBuffer((byte)this.quoteChar);
                    int n = 0;
                    int n2 = string.indexOf(this.quoteChar, n);
                    while (n2 >= 0) {
                        this.toRowBuffer(string.substring(n, n2).getBytes());
                        this.toRowBuffer((byte)this.quoteEscape);
                        this.toRowBuffer((byte)this.quoteChar);
                        n = n2 + 1;
                        n2 = string.indexOf(this.quoteChar, n);
                    }
                    this.toRowBuffer(string.substring(n).getBytes());
                    this.toRowBuffer((byte)this.quoteChar);
                } else {
                    this.toRowBuffer(string.getBytes());
                }
            }
            if (i >= this.colNames.length - 1) continue;
            this.toRowBuffer((byte)this.sFieldSep);
        }
        this.toRowBuffer(this.sTerminator);
    }

    private void printFormattedRow() throws SQLException, IOException {
        String string = null;
        int n = 0;
        block0: for (int i = 0; i < this.field.length; ++i) {
            for (int j = 0; j < this.colNames.length; ++j) {
                n = 0;
                if (!this.field[i].equals(this.colNames[j])) continue;
                string = this.rs.getString(j + 1);
                if (string == null) {
                    this.toRowBuffer(this.nullValue);
                } else if (this.trimTrailingSpaces) {
                    string = this.trimTrailing(string);
                }
                this.toRowBuffer(string.getBytes());
                n = string.length();
                int n2 = 0;
                if (i < this.field.length - 1) {
                    n2 = this.staPos[i + 1] - this.staPos[i] - n;
                }
                for (int k = 0; k < n2; ++k) {
                    this.toRowBuffer((byte)32);
                }
                continue block0;
            }
        }
        this.toRowBuffer(this.sTerminator);
    }

    private String trimTrailing(String string) {
        int n;
        for (n = string.length(); n > 0 && string.charAt(n - 1) == ' '; --n) {
        }
        if (n == 0) {
            return "";
        }
        return string.substring(0, n);
    }

    public void setQuoteInfo(String string, String string2, Collection<String> collection) {
        this.quoteChar = string.charAt(0);
        this.quoteEscape = string2 == null ? this.quoteChar : string2.charAt(0);
        this.forceQuoteColumns = new HashSet();
        if (collection != null) {
            for (String string3 : collection) {
                this.forceQuoteColumns.add(string3.toLowerCase());
            }
        }
    }
}

