/*
 * Decompiled with CFR 0.152.
 */
package com.edb.jdbc2;

import com.edb.core.BaseConnection;
import com.edb.core.BaseStatement;
import com.edb.util.GT;
import com.edb.util.PSQLException;
import com.edb.util.PSQLState;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TypeInfoCache {
    private static final Map _pgNameToSQLType;
    private Map _pgNameToJavaClass;
    private Map _oidToPgName;
    private Map _pgNameToOid;
    private Map _pgNameToPgObject;
    private BaseConnection _conn;
    private PreparedStatement _getOidStatement;
    private PreparedStatement _getNameStatement;
    private static final Object[][] types;
    static /* synthetic */ Class class$com$edb$util$PGobject;

    public TypeInfoCache(BaseConnection conn) {
        this._conn = conn;
        this._oidToPgName = new HashMap();
        this._pgNameToOid = new HashMap();
        this._pgNameToJavaClass = new HashMap();
        this._pgNameToPgObject = new HashMap();
        for (int i = 0; i < types.length; ++i) {
            this._pgNameToJavaClass.put(types[i][0], types[i][3]);
            this._pgNameToOid.put(types[i][0], types[i][1]);
            this._oidToPgName.put(types[i][1], types[i][0]);
            String arrayType = "_" + types[i][0];
            this._pgNameToJavaClass.put(arrayType, "java.sql.Array");
        }
    }

    public synchronized void addDataType(String type, Class klass) throws SQLException {
        if (!(class$com$edb$util$PGobject == null ? (class$com$edb$util$PGobject = TypeInfoCache.class$("com.edb.util.PGobject")) : class$com$edb$util$PGobject).isAssignableFrom(klass)) {
            throw new PSQLException(GT.tr("The class {0} does not implement com.edb.util.PGobject.", klass.toString()), PSQLState.INVALID_PARAMETER_TYPE);
        }
        this._pgNameToPgObject.put(type, klass);
        this._pgNameToJavaClass.put(type, klass.getName());
    }

    public static Iterator getPGTypeNamesWithSQLTypes() {
        return _pgNameToSQLType.keySet().iterator();
    }

    public int getSQLType(int oid) throws SQLException {
        return TypeInfoCache.getSQLType(this.getPGType(oid));
    }

    public static int getSQLType(String pgTypeName) {
        Integer i = (Integer)_pgNameToSQLType.get(pgTypeName);
        if (i != null) {
            return i;
        }
        return 1111;
    }

    public synchronized int getPGType(String pgTypeName) throws SQLException {
        Integer oid = (Integer)this._pgNameToOid.get(pgTypeName);
        if (oid != null) {
            return oid;
        }
        String sql = this._conn.haveMinimumServerVersion("7.3") ? "SELECT oid FROM pg_catalog.pg_type WHERE typname = ?" : "SELECT oid FROM pg_type WHERE typname = ?";
        if (this._getOidStatement == null) {
            this._getOidStatement = this._conn.prepareStatement(sql);
        }
        this._getOidStatement.setString(1, pgTypeName);
        if (!((BaseStatement)((Object)this._getOidStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
        }
        oid = new Integer(0);
        ResultSet rs = this._getOidStatement.getResultSet();
        if (rs.next()) {
            oid = new Integer(rs.getInt(1));
            this._oidToPgName.put(oid, pgTypeName);
        }
        this._pgNameToOid.put(pgTypeName, oid);
        rs.close();
        return oid;
    }

    public synchronized String getPGType(int oid) throws SQLException {
        if (oid == 0) {
            return null;
        }
        String pgTypeName = (String)this._oidToPgName.get(new Integer(oid));
        if (pgTypeName != null) {
            return pgTypeName;
        }
        String sql = this._conn.haveMinimumServerVersion("7.3") ? "SELECT typname FROM pg_catalog.pg_type WHERE oid = ?" : "SELECT typname FROM pg_type WHERE oid = ?";
        if (this._getNameStatement == null) {
            this._getNameStatement = this._conn.prepareStatement(sql);
        }
        this._getNameStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this._getNameStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getNameStatement.getResultSet();
        if (rs.next()) {
            pgTypeName = rs.getString(1);
            this._pgNameToOid.put(pgTypeName, new Integer(oid));
            this._oidToPgName.put(new Integer(oid), pgTypeName);
        }
        rs.close();
        return pgTypeName;
    }

    public synchronized Class getPGobject(String type) {
        return (Class)this._pgNameToPgObject.get(type);
    }

    public synchronized String getJavaClass(int oid) throws SQLException {
        String pgTypeName = this.getPGType(oid);
        return (String)this._pgNameToJavaClass.get(pgTypeName);
    }

    public static int getPrecision(int oid, int typmod) {
        switch (oid) {
            case 21: {
                return 5;
            }
            case 23: 
            case 26: {
                return 10;
            }
            case 20: {
                return 19;
            }
            case 700: {
                return 8;
            }
            case 701: {
                return 17;
            }
            case 1700: {
                if (typmod == -1) {
                    return 0;
                }
                return (typmod - 4 & 0xFFFF0000) >> 16;
            }
            case 16: 
            case 18: {
                return 1;
            }
            case 1042: 
            case 1043: {
                if (typmod == -1) {
                    return 0;
                }
                return typmod - 4;
            }
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: {
                return TypeInfoCache.getDisplaySize(oid, typmod);
            }
            case 1560: {
                return typmod;
            }
            case 1562: {
                if (typmod == -1) {
                    return 0;
                }
                return typmod;
            }
        }
        return 0;
    }

    public static int getScale(int oid, int typmod) {
        switch (oid) {
            case 700: {
                return 8;
            }
            case 701: {
                return 17;
            }
            case 1700: {
                if (typmod == -1) {
                    return 0;
                }
                return typmod - 4 & 0xFFFF;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: {
                if (typmod == -1) {
                    return 6;
                }
                return typmod;
            }
            case 1186: {
                if (typmod == -1) {
                    return 6;
                }
                return typmod & 0xFFFF;
            }
        }
        return 0;
    }

    public static boolean isCaseSensitive(int oid) {
        switch (oid) {
            case 16: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 700: 
            case 701: 
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: 
            case 1560: 
            case 1562: 
            case 1700: {
                return false;
            }
        }
        return true;
    }

    public static boolean isSigned(int oid) {
        switch (oid) {
            case 20: 
            case 21: 
            case 23: 
            case 700: 
            case 701: 
            case 1700: {
                return true;
            }
        }
        return false;
    }

    public static int getDisplaySize(int oid, int typmod) {
        switch (oid) {
            case 21: {
                return 6;
            }
            case 23: {
                return 11;
            }
            case 26: {
                return 10;
            }
            case 20: {
                return 20;
            }
            case 700: {
                return 14;
            }
            case 701: {
                return 24;
            }
            case 18: {
                return 1;
            }
            case 16: {
                return 1;
            }
            case 1082: {
                return 13;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: {
                int secondSize;
                switch (typmod) {
                    case -1: {
                        secondSize = 7;
                        break;
                    }
                    case 0: {
                        secondSize = 0;
                        break;
                    }
                    case 1: {
                        secondSize = 3;
                        break;
                    }
                    default: {
                        secondSize = typmod + 1;
                    }
                }
                switch (oid) {
                    case 1083: {
                        return 8 + secondSize;
                    }
                    case 1266: {
                        return 8 + secondSize + 6;
                    }
                    case 1114: {
                        return 22 + secondSize;
                    }
                    case 1184: {
                        return 22 + secondSize + 6;
                    }
                }
            }
            case 1186: {
                return 49;
            }
            case 1042: 
            case 1043: {
                if (typmod == -1) {
                    return Integer.MAX_VALUE;
                }
                return typmod - 4;
            }
            case 1700: {
                if (typmod == -1) {
                    return 131089;
                }
                int precision = typmod - 4 >> 16 & 0xFFFF;
                int scale = typmod - 4 & 0xFFFF;
                return 1 + precision + (scale != 0 ? 1 : 0);
            }
            case 1560: {
                return typmod;
            }
            case 1562: {
                if (typmod == -1) {
                    return Integer.MAX_VALUE;
                }
                return typmod;
            }
            case 17: 
            case 25: {
                return Integer.MAX_VALUE;
            }
        }
        return Integer.MAX_VALUE;
    }

    public static int getMaximumPrecision(int oid) {
        switch (oid) {
            case 1700: {
                return 1000;
            }
            case 1083: 
            case 1266: {
                return 6;
            }
            case 1114: 
            case 1184: 
            case 1186: {
                return 6;
            }
            case 1042: 
            case 1043: {
                return 0xA00000;
            }
            case 1560: 
            case 1562: {
                return 0x5000000;
            }
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        types = new Object[][]{{"int2", new Integer(21), new Integer(5), "java.lang.Integer"}, {"int4", new Integer(23), new Integer(4), "java.lang.Integer"}, {"oid", new Integer(26), new Integer(-5), "java.lang.Long"}, {"int8", new Integer(20), new Integer(-5), "java.lang.Long"}, {"money", new Integer(790), new Integer(8), "java.lang.Double"}, {"numeric", new Integer(1700), new Integer(2), "java.math.BigDecimal"}, {"float4", new Integer(700), new Integer(7), "java.lang.Float"}, {"float8", new Integer(701), new Integer(8), "java.lang.Double"}, {"bpchar", new Integer(1042), new Integer(1), "java.lang.String"}, {"varchar", new Integer(1043), new Integer(12), "java.lang.String"}, {"varchar2", new Integer(1043), new Integer(12), "java.lang.String"}, {"text", new Integer(25), new Integer(12), "java.lang.String"}, {"name", new Integer(19), new Integer(12), "java.lang.String"}, {"bytea", new Integer(17), new Integer(-2), "[B"}, {"bool", new Integer(16), new Integer(-7), "java.lang.Boolean"}, {"bit", new Integer(1560), new Integer(-7), "java.lang.Boolean"}, {"date", new Integer(1082), new Integer(91), "java.sql.Date"}, {"datetime", new Integer(1079), new Integer(91), "java.sql.Date"}, {"time", new Integer(1083), new Integer(92), "java.sql.Time"}, {"timetz", new Integer(1266), new Integer(92), "java.sql.Time"}, {"timestamp", new Integer(1114), new Integer(93), "java.sql.Timestamp"}, {"timestamptz", new Integer(1184), new Integer(93), "java.sql.Timestamp"}, {"refcursor", new Integer(1790), new Integer(2006), "java.sql.ResultSet"}};
        HashMap<Object, Object> pgNameToSQLType = new HashMap<Object, Object>();
        for (int i = 0; i < types.length; ++i) {
            pgNameToSQLType.put(types[i][0], types[i][2]);
            String arrayType = "_" + types[i][0];
            pgNameToSQLType.put(arrayType, new Integer(2003));
        }
        _pgNameToSQLType = Collections.unmodifiableMap(pgNameToSQLType);
    }
}

